/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.nio.ByteBuffer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.Pool;

public class BufferPoolService
implements Service<Pool<ByteBuffer>> {
    private volatile Pool<ByteBuffer> bufferPool;
    private final int bufferSize;
    private final int buffersPerSlice;
    private final boolean directBuffers;

    public BufferPoolService(int bufferSize, int buffersPerSlice, boolean directBuffers) {
        this.bufferSize = bufferSize;
        this.buffersPerSlice = buffersPerSlice;
        this.directBuffers = directBuffers;
    }

    public void start(StartContext context) throws StartException {
        this.bufferPool = new ByteBufferSlicePool(this.directBuffers ? BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR : BufferAllocator.BYTE_BUFFER_ALLOCATOR, this.bufferSize, this.buffersPerSlice * this.bufferSize);
    }

    public void stop(StopContext context) {
    }

    public Pool<ByteBuffer> getValue() throws IllegalStateException, IllegalArgumentException {
        return this.bufferPool;
    }
}

