/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.management.security.DomainManagedServerCallbackHandler;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.ProcessControllerConnectionService;
import org.jboss.as.host.controller.RestartMode;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.ServerInventoryCallbackService;
import org.jboss.as.host.controller.ServerInventoryImpl;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.AsyncFutureTask;

class ServerInventoryService
implements Service<ServerInventory> {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "server-inventory"});
    private final InjectedValue<ProcessControllerConnectionService> client = new InjectedValue();
    private final InjectedValue<NetworkInterfaceBinding> interfaceBinding = new InjectedValue();
    private final InjectedValue<ServerInventoryCallbackService> serverCallback = new InjectedValue();
    private final InjectedValue<DomainManagedServerCallbackHandler> domainServerCallback = new InjectedValue();
    private final DomainController domainController;
    private final HostControllerEnvironment environment;
    private final HostRunningModeControl runningModeControl;
    private final ExtensionRegistry extensionRegistry;
    private final int port;
    private final String protocol;
    private final InjectedValue<ExecutorService> executorService = new InjectedValue();
    private final FutureServerInventory futureInventory = new FutureServerInventory();
    private ServerInventoryImpl serverInventory;

    private ServerInventoryService(DomainController domainController, HostRunningModeControl runningModeControl, HostControllerEnvironment environment, ExtensionRegistry extensionRegistry, int port, String protocol) {
        this.extensionRegistry = extensionRegistry;
        this.domainController = domainController;
        this.runningModeControl = runningModeControl;
        this.environment = environment;
        this.port = port;
        this.protocol = protocol;
    }

    static Future<ServerInventory> install(ServiceTarget serviceTarget, DomainController domainController, HostRunningModeControl runningModeControl, HostControllerEnvironment environment, ExtensionRegistry extensionRegistry, String interfaceBinding, int port, String protocol) {
        ServerInventoryService inventory = new ServerInventoryService(domainController, runningModeControl, environment, extensionRegistry, port, protocol);
        ServiceBuilder sb = serviceTarget.addService(SERVICE_NAME, (Service)inventory);
        sb.addDependency(HostControllerService.HC_EXECUTOR_SERVICE_NAME, ExecutorService.class, inventory.executorService);
        sb.addDependency(ProcessControllerConnectionService.SERVICE_NAME, ProcessControllerConnectionService.class, inventory.getClient());
        sb.addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceBinding}), NetworkInterfaceBinding.class, inventory.interfaceBinding);
        sb.addDependency(ServerInventoryCallbackService.SERVICE_NAME, ServerInventoryCallbackService.class, inventory.serverCallback);
        sb.addDependency(DomainManagedServerCallbackHandler.SERVICE_NAME, DomainManagedServerCallbackHandler.class, inventory.domainServerCallback);
        sb.requires(ManagementChannelRegistryService.SERVICE_NAME);
        sb.install();
        return inventory.futureInventory;
    }

    public synchronized void start(StartContext context) throws StartException {
        HostControllerLogger.ROOT_LOGGER.debug("Starting Host Controller Server Inventory");
        try {
            ProcessControllerConnectionService processControllerConnectionService = (ProcessControllerConnectionService)this.client.getValue();
            URI managementURI = new URI(this.protocol, null, NetworkUtils.formatAddress((InetAddress)this.getNonWildCardManagementAddress()), this.port, null, null, null);
            this.serverInventory = new ServerInventoryImpl(this.domainController, this.environment, managementURI, processControllerConnectionService.getClient(), this.extensionRegistry);
            processControllerConnectionService.setServerInventory(this.serverInventory);
            ((ServerInventoryCallbackService)this.serverCallback.getValue()).setCallbackHandler(this.serverInventory.getServerCallbackHandler());
            if (this.domainServerCallback != null && this.domainServerCallback.getValue() != null) {
                ((DomainManagedServerCallbackHandler)this.domainServerCallback.getValue()).getServerCallbackHandlerInjector().inject((Object)this.serverInventory.getServerCallbackHandler());
            }
            this.futureInventory.setInventory(this.serverInventory);
        }
        catch (Exception e) {
            this.futureInventory.setFailure(e);
            throw new StartException((Throwable)e);
        }
    }

    private InetAddress getNonWildCardManagementAddress() throws UnknownHostException {
        InetAddress binding = ((NetworkInterfaceBinding)this.interfaceBinding.getValue()).getAddress();
        return binding.isAnyLocalAddress() ? InetAddress.getLocalHost() : binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(final StopContext context) {
        boolean shutdownServers;
        boolean bl = shutdownServers = this.runningModeControl.getRestartMode() == RestartMode.SERVERS;
        if (shutdownServers) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        ServerInventoryService.this.serverInventory.shutdown(true, -1, true);
                        ServerInventoryService.this.serverInventory = null;
                    }
                    finally {
                        ((ServerInventoryCallbackService)ServerInventoryService.this.serverCallback.getValue()).setCallbackHandler(null);
                        context.complete();
                    }
                }
            };
            try {
                ((ExecutorService)this.executorService.getValue()).execute(task);
            }
            catch (RejectedExecutionException e) {
                task.run();
            }
            finally {
                context.asynchronous();
            }
        } else {
            this.serverInventory.shutdown(false, -1, true);
            this.serverInventory = null;
        }
    }

    public synchronized ServerInventory getValue() throws IllegalStateException, IllegalArgumentException {
        ServerInventoryImpl serverInventory = this.serverInventory;
        if (serverInventory == null) {
            throw new IllegalStateException();
        }
        return serverInventory;
    }

    InjectedValue<ProcessControllerConnectionService> getClient() {
        return this.client;
    }

    private class FutureServerInventory
    extends AsyncFutureTask<ServerInventory> {
        protected FutureServerInventory() {
            super(null);
        }

        private void setInventory(ServerInventory inventory) {
            super.setResult((Object)inventory);
        }

        private void setFailure(Throwable t) {
            super.setFailed(t);
        }
    }
}

