/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.operations.common.ProcessEnvironment;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.RestartMode;
import org.jboss.as.host.controller.jvm.JvmType;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.version.ProductConfig;
import org.wildfly.common.Assert;
import org.wildfly.security.manager.WildFlySecurityManager;

public class HostControllerEnvironment
extends ProcessEnvironment {
    public static final String HOME_DIR = "jboss.home.dir";
    @Deprecated
    public static final String MODULES_DIR = "jboss.modules.dir";
    public static final String DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    public static final String DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    public static final String DOMAIN_DATA_DIR = "jboss.domain.data.dir";
    public static final String DOMAIN_CONTENT_DIR = "jboss.domain.content.dir";
    @Deprecated
    public static final String DOMAIN_DEPLOYMENT_DIR = "jboss.domain.deployment.dir";
    public static final String DOMAIN_LOG_DIR = "jboss.domain.log.dir";
    public static final String DOMAIN_SERVERS_DIR = "jboss.domain.servers.dir";
    public static final String DOMAIN_TEMP_DIR = "jboss.domain.temp.dir";
    public static final String HOST_NAME = "jboss.host.name";
    public static final String QUALIFIED_HOST_NAME = "jboss.qualified.host.name";
    public static final String CONTROLLER_TEMP_DIR = "jboss.controller.temp.dir";
    public static final String JBOSS_BIND_ADDRESS = "jboss.bind.address";
    public static final String JBOSS_BIND_ADDRESS_PREFIX = "jboss.bind.address.";
    public static final String JBOSS_DEFAULT_MULTICAST_ADDRESS = "jboss.default.multicast.address";
    public static final String JBOSS_DOMAIN_MASTER_ADDRESS = "jboss.domain.master.address";
    public static final String JBOSS_DOMAIN_MASTER_PORT = "jboss.domain.master.port";
    public static final String JBOSS_DOMAIN_DEFAULT_CONFIG = "jboss.domain.default.config";
    public static final String JBOSS_HOST_DEFAULT_CONFIG = "jboss.host.default.config";
    public static final String JBOSS_HOST_MANAGEMENT_UUID = "jboss.host.management.uuid";
    private final Map<String, String> hostSystemProperties;
    private final InetAddress processControllerAddress;
    private final Integer processControllerPort;
    private final InetAddress hostControllerAddress;
    private final Integer hostControllerPort;
    private final File homeDir;
    private final File modulesDir;
    private final File domainBaseDir;
    private final File domainConfigurationDir;
    private final ConfigurationFile hostConfigurationFile;
    private final String domainConfig;
    private final String initialDomainConfig;
    private ConfigurationFile domainConfigurationFile;
    private final ConfigurationFile.InteractionPolicy domainConfigInteractionPolicy;
    private final File domainContentDir;
    private final File domainDataDir;
    private final File domainLogDir;
    private final File domainServersDir;
    private final File domainTempDir;
    private final JvmType defaultJvm;
    private final boolean isRestart;
    private final boolean backupDomainFiles;
    private final boolean useCachedDc;
    private final RunningMode initialRunningMode;
    private final ProductConfig productConfig;
    private final String qualifiedHostName;
    private final String hostName;
    private final String modulePath;
    private volatile String hostControllerName;
    private final HostRunningModeControl runningModeControl;
    private final boolean securityManagerEnabled;
    private final UUID hostControllerUUID;
    private final long startTime;
    private final ProcessType processType;

    public HostControllerEnvironment(Map<String, String> hostSystemProperties, boolean isRestart, String modulePath, InetAddress processControllerAddress, Integer processControllerPort, InetAddress hostControllerAddress, Integer hostControllerPort, String defaultJVM, String domainConfig, String initialDomainConfig, String hostConfig, String initialHostConfig, RunningMode initialRunningMode, boolean backupDomainFiles, boolean useCachedDc, ProductConfig productConfig) {
        this(hostSystemProperties, isRestart, modulePath, processControllerAddress, processControllerPort, hostControllerAddress, hostControllerPort, defaultJVM, domainConfig, initialDomainConfig, hostConfig, initialHostConfig, initialRunningMode, backupDomainFiles, useCachedDc, productConfig, false, System.currentTimeMillis(), ProcessType.HOST_CONTROLLER, ConfigurationFile.InteractionPolicy.STANDARD, ConfigurationFile.InteractionPolicy.STANDARD);
    }

    public HostControllerEnvironment(Map<String, String> hostSystemProperties, boolean isRestart, String modulePath, InetAddress processControllerAddress, Integer processControllerPort, InetAddress hostControllerAddress, Integer hostControllerPort, String defaultJVM, String domainConfig, String initialDomainConfig, String hostConfig, String initialHostConfig, RunningMode initialRunningMode, boolean backupDomainFiles, boolean useCachedDc, ProductConfig productConfig, boolean securityManagerEnabled, long startTime, ProcessType processType, ConfigurationFile.InteractionPolicy hostConfigInteractionPolicy, ConfigurationFile.InteractionPolicy domainConfigInteractionPolicy) {
        UUID uuid;
        this.hostSystemProperties = Collections.unmodifiableMap((Map)Assert.checkNotNullParam((String)"hostSystemProperties", hostSystemProperties));
        Assert.checkNotNullParam((String)"modulePath", (Object)modulePath);
        Assert.checkNotNullParam((String)"processControllerAddress", (Object)processControllerAddress);
        Assert.checkNotNullParam((String)"processControllerPort", (Object)processControllerPort);
        Assert.checkNotNullParam((String)"hostControllerAddress", (Object)hostControllerAddress);
        Assert.checkNotNullParam((String)"hostControllerPort", (Object)hostControllerPort);
        this.processControllerPort = processControllerPort;
        this.processControllerAddress = processControllerAddress;
        this.hostControllerAddress = hostControllerAddress;
        this.hostControllerPort = hostControllerPort;
        this.isRestart = isRestart;
        this.modulePath = modulePath;
        this.startTime = startTime;
        this.initialRunningMode = initialRunningMode;
        this.runningModeControl = new HostRunningModeControl(initialRunningMode, RestartMode.SERVERS);
        this.domainConfigInteractionPolicy = domainConfigInteractionPolicy;
        String hostName = hostSystemProperties.get(HOST_NAME);
        String qualifiedHostName = hostSystemProperties.get(QUALIFIED_HOST_NAME);
        if (qualifiedHostName == null) {
            Map env = null;
            qualifiedHostName = hostName;
            if (qualifiedHostName == null) {
                env = WildFlySecurityManager.getSystemEnvironmentPrivileged();
                qualifiedHostName = (String)env.get("HOSTNAME");
            }
            if (qualifiedHostName == null) {
                qualifiedHostName = (String)env.get("COMPUTERNAME");
            }
            if (qualifiedHostName == null) {
                try {
                    qualifiedHostName = NetworkUtils.canonize((String)InetAddress.getLocalHost().getHostName());
                }
                catch (UnknownHostException e) {
                    qualifiedHostName = null;
                }
            }
            if (qualifiedHostName != null && qualifiedHostName.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$|:")) {
                qualifiedHostName = null;
            }
            qualifiedHostName = qualifiedHostName == null ? "unknown-host.unknown-domain" : qualifiedHostName.trim().toLowerCase();
        }
        this.qualifiedHostName = qualifiedHostName;
        this.hostControllerName = qualifiedHostName;
        if (hostName == null) {
            int idx = qualifiedHostName.indexOf(46);
            hostName = idx == -1 ? qualifiedHostName : qualifiedHostName.substring(0, idx);
        }
        this.hostName = hostName;
        File home = this.getFileFromProperty(HOME_DIR);
        if (home == null) {
            if (processType != ProcessType.EMBEDDED_HOST_CONTROLLER) {
                throw HostControllerLogger.ROOT_LOGGER.missingHomeDirConfiguration(HOME_DIR);
            }
            String homeStr = WildFlySecurityManager.getPropertyPrivileged((String)HOME_DIR, null);
            if (homeStr == null) {
                throw HostControllerLogger.ROOT_LOGGER.missingHomeDirConfiguration(HOME_DIR);
            }
            home = new File(homeStr);
        }
        this.homeDir = home;
        if (!this.homeDir.exists() || !this.homeDir.isDirectory()) {
            throw HostControllerLogger.ROOT_LOGGER.homeDirectoryDoesNotExist(this.homeDir);
        }
        WildFlySecurityManager.setPropertyPrivileged((String)HOME_DIR, (String)this.homeDir.getAbsolutePath());
        File tmp = this.getFileFromProperty(MODULES_DIR);
        if (tmp == null) {
            tmp = new File(this.homeDir, "modules");
        }
        this.modulesDir = tmp;
        String deprecatedModDir = MODULES_DIR;
        WildFlySecurityManager.setPropertyPrivileged((String)deprecatedModDir, (String)this.modulesDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_BASE_DIR);
        if (tmp == null) {
            tmp = new File(this.homeDir, "domain");
        }
        if (!tmp.exists()) {
            throw HostControllerLogger.ROOT_LOGGER.domainBaseDirectoryDoesNotExist(tmp);
        }
        if (!tmp.isDirectory()) {
            throw HostControllerLogger.ROOT_LOGGER.domainBaseDirectoryIsNotADirectory(tmp);
        }
        this.domainBaseDir = tmp;
        WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_BASE_DIR, (String)this.domainBaseDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_CONFIG_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "configuration");
        }
        if (!tmp.exists() || !tmp.isDirectory()) {
            throw HostControllerLogger.ROOT_LOGGER.configDirectoryDoesNotExist(tmp);
        }
        this.domainConfigurationDir = tmp;
        WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_CONFIG_DIR, (String)this.domainConfigurationDir.getAbsolutePath());
        this.domainConfig = domainConfig;
        this.initialDomainConfig = initialDomainConfig;
        tmp = this.getFileFromProperty(DOMAIN_DATA_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "data");
        }
        this.domainDataDir = tmp;
        if (this.domainDataDir.exists()) {
            if (!this.domainDataDir.isDirectory()) {
                throw HostControllerLogger.ROOT_LOGGER.domainDataDirectoryIsNotDirectory(this.domainDataDir);
            }
        } else if (!this.domainDataDir.mkdirs()) {
            throw HostControllerLogger.ROOT_LOGGER.couldNotCreateDomainDataDirectory(this.domainDataDir);
        }
        WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_DATA_DIR, (String)this.domainDataDir.getAbsolutePath());
        String deprecatedDepDir = DOMAIN_DEPLOYMENT_DIR;
        tmp = this.getFileFromProperty(DOMAIN_CONTENT_DIR);
        if (tmp == null) {
            tmp = this.getFileFromProperty(deprecatedDepDir);
        }
        if (tmp == null) {
            tmp = new File(this.domainDataDir, "content");
        }
        this.domainContentDir = tmp;
        if (this.domainContentDir.exists()) {
            if (!this.domainContentDir.isDirectory()) {
                throw HostControllerLogger.ROOT_LOGGER.domainContentDirectoryIsNotDirectory(this.domainContentDir);
            }
        } else if (!this.domainContentDir.mkdirs()) {
            throw HostControllerLogger.ROOT_LOGGER.couldNotCreateDomainContentDirectory(this.domainContentDir);
        }
        WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_CONTENT_DIR, (String)this.domainContentDir.getAbsolutePath());
        WildFlySecurityManager.setPropertyPrivileged((String)deprecatedDepDir, (String)this.domainContentDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_LOG_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "log");
        }
        if (tmp.exists()) {
            if (!tmp.isDirectory()) {
                throw HostControllerLogger.ROOT_LOGGER.logDirectoryIsNotADirectory(tmp);
            }
        } else if (!tmp.mkdirs()) {
            throw HostControllerLogger.ROOT_LOGGER.couldNotCreateLogDirectory(tmp);
        }
        this.domainLogDir = tmp;
        WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_LOG_DIR, (String)this.domainLogDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_SERVERS_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "servers");
        }
        if (tmp.exists()) {
            if (!tmp.isDirectory()) {
                throw HostControllerLogger.ROOT_LOGGER.serversDirectoryIsNotADirectory(tmp);
            }
        } else if (!tmp.mkdirs()) {
            throw HostControllerLogger.ROOT_LOGGER.couldNotCreateServersDirectory(tmp);
        }
        this.domainServersDir = tmp;
        WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_SERVERS_DIR, (String)this.domainServersDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_TEMP_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "tmp");
        }
        if (tmp.exists()) {
            if (!tmp.isDirectory()) {
                throw HostControllerLogger.ROOT_LOGGER.domainTempDirectoryIsNotADirectory(tmp);
            }
        } else if (!tmp.mkdirs()) {
            throw HostControllerLogger.ROOT_LOGGER.couldNotCreateDomainTempDirectory(tmp);
        }
        this.domainTempDir = tmp;
        WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_TEMP_DIR, (String)this.domainTempDir.getAbsolutePath());
        this.defaultJvm = defaultJVM != null ? JvmType.createFromJavaExecutable(defaultJVM, false) : null;
        String defaultHostConfig = WildFlySecurityManager.getPropertyPrivileged((String)JBOSS_HOST_DEFAULT_CONFIG, (String)"host.xml");
        this.hostConfigurationFile = new ConfigurationFile(this.domainConfigurationDir, defaultHostConfig, initialHostConfig == null ? hostConfig : initialHostConfig, hostConfigInteractionPolicy, false);
        Path filePath = this.domainDataDir.toPath().resolve("kernel").resolve("process-uuid");
        try {
            String sysPropUUID = hostSystemProperties.get(JBOSS_HOST_MANAGEMENT_UUID);
            uuid = this.obtainProcessUUID(filePath, sysPropUUID);
        }
        catch (IOException ex) {
            throw HostControllerLogger.ROOT_LOGGER.couldNotObtainDomainUuid(ex, filePath);
        }
        this.hostControllerUUID = uuid;
        this.backupDomainFiles = backupDomainFiles;
        this.useCachedDc = useCachedDc;
        this.productConfig = productConfig;
        this.securityManagerEnabled = securityManagerEnabled || hostSystemProperties.containsKey("java.security.manager");
        this.processType = processType;
    }

    public InetAddress getProcessControllerAddress() {
        return this.processControllerAddress;
    }

    public Integer getProcessControllerPort() {
        return this.processControllerPort;
    }

    public InetAddress getHostControllerAddress() {
        return this.hostControllerAddress;
    }

    public Integer getHostControllerPort() {
        return this.hostControllerPort;
    }

    public boolean isRestart() {
        return this.isRestart;
    }

    public boolean isBackupDomainFiles() {
        return this.backupDomainFiles;
    }

    public boolean isUseCachedDc() {
        return this.useCachedDc;
    }

    public RunningMode getInitialRunningMode() {
        return this.initialRunningMode;
    }

    public HostRunningModeControl getRunningModeControl() {
        return this.runningModeControl;
    }

    public ProductConfig getProductConfig() {
        return this.productConfig;
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    @Deprecated
    public File getModulesDir() {
        return this.modulesDir;
    }

    public File getDomainBaseDir() {
        return this.domainBaseDir;
    }

    public File getDomainConfigurationDir() {
        return this.domainConfigurationDir;
    }

    public File getDomainDataDir() {
        return this.domainDataDir;
    }

    public File getDomainContentDir() {
        return this.domainContentDir;
    }

    @Deprecated
    public File getDomainDeploymentDir() {
        return this.domainContentDir;
    }

    public File getDomainLogDir() {
        return this.domainLogDir;
    }

    public File getDomainServersDir() {
        return this.domainServersDir;
    }

    public File getDomainTempDir() {
        return this.domainTempDir;
    }

    public File getDefaultJVM() {
        return this.defaultJvm != null ? new File(this.defaultJvm.getJavaExecutable()) : null;
    }

    public Map<String, String> getHostSystemProperties() {
        return this.hostSystemProperties;
    }

    public String getQualifiedHostName() {
        return this.qualifiedHostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostControllerName() {
        return this.hostControllerName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    protected String getProcessName() {
        return this.hostControllerName;
    }

    protected void setProcessName(String processName) {
        if (processName != null) {
            this.hostControllerName = processName;
        }
    }

    public ProcessType getProcessType() {
        return this.processType;
    }

    protected boolean isRuntimeSystemPropertyUpdateAllowed(String propertyName, String propertyValue, boolean bootTime) {
        throw HostControllerLogger.ROOT_LOGGER.hostControllerSystemPropertyUpdateNotSupported();
    }

    protected void systemPropertyUpdated(String propertyName, String propertyValue) {
    }

    public ConfigurationFile getHostConfigurationFile() {
        return this.hostConfigurationFile;
    }

    public ConfigurationFile getDomainConfigurationFile() {
        return this.domainConfigurationFile;
    }

    public ConfigurationFile.InteractionPolicy getDomainConfigurationFileInteractionPolicy() {
        return this.domainConfigInteractionPolicy;
    }

    String getDomainConfig() {
        return this.domainConfig;
    }

    String getInitialDomainConfig() {
        return this.initialDomainConfig;
    }

    void setDomainConfigurationFile(ConfigurationFile domainConfigurationFile) {
        this.domainConfigurationFile = domainConfigurationFile;
    }

    String getModulePath() {
        return this.modulePath;
    }

    boolean isSecurityManagerEnabled() {
        return this.securityManagerEnabled;
    }

    private File getFileFromProperty(String name) {
        File relative;
        File result;
        String value = this.hostSystemProperties.get(name);
        File file = result = value != null ? new File(value) : null;
        if (result != null && this.homeDir != null && !result.exists() && !result.isAbsolute() && (relative = new File(this.homeDir, value)).exists()) {
            result = relative;
        }
        return result;
    }

    public UUID getInstanceUuid() {
        return this.hostControllerUUID;
    }
}

