/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.model.jvm;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.model.jvm.JvmElement;
import org.jboss.as.host.controller.model.jvm.JvmType;
import org.wildfly.common.Assert;

public class JvmOptionsBuilderFactory {
    private static final JvmOptionsBuilderFactory INSTANCE = new JvmOptionsBuilderFactory();
    private static final Map<JvmType, JvmOptionsBuilder> BUILDERS;

    private JvmOptionsBuilderFactory() {
    }

    public static JvmOptionsBuilderFactory getInstance() {
        return INSTANCE;
    }

    public void addOptions(JvmElement jvmElement, List<String> command) {
        Assert.checkNotNullParam((String)"jvmElement", (Object)jvmElement);
        Assert.checkNotNullParam((String)"command", command);
        JvmOptionsBuilder builder = BUILDERS.get((Object)jvmElement.getJvmType());
        if (builder == null) {
            throw HostControllerLogger.ROOT_LOGGER.unknown("jvm", (Object)jvmElement.getJvmType());
        }
        builder.addToOptions(jvmElement, command);
    }

    static {
        HashMap<JvmType, OracleJvmOptionsBuilder> map = new HashMap<JvmType, OracleJvmOptionsBuilder>();
        map.put(JvmType.ORACLE, new OracleJvmOptionsBuilder(JvmType.ORACLE));
        map.put(JvmType.IBM, new OracleJvmOptionsBuilder(JvmType.IBM));
        map.put(JvmType.SUN, new OracleJvmOptionsBuilder(JvmType.SUN));
        BUILDERS = Collections.unmodifiableMap(map);
    }

    private static class IbmJvmOptionsBuilder
    extends JvmOptionsBuilder {
        private IbmJvmOptionsBuilder(JvmType type) {
            super(type);
        }
    }

    private static class OracleJvmOptionsBuilder
    extends JvmOptionsBuilder {
        private static final int JVM_MAJOR_VERSION = JvmElement.getJVMMajorVersion();
        private static final List<String> ALLOWED_JDK9_PARAMS = Arrays.asList("--permit-illegal-access", "--add-exports", "--add-opens", "--add-modules", "--add-reads", "--illegal-access");

        private OracleJvmOptionsBuilder(JvmType type) {
            super(type);
        }

        @Override
        boolean checkAdditionalJvmOption(String option) {
            if (JVM_MAJOR_VERSION >= 9) {
                return true;
            }
            return !ALLOWED_JDK9_PARAMS.contains(option.contains("=") ? option.substring(0, option.indexOf("=")) : option);
        }
    }

    private static abstract class JvmOptionsBuilder {
        final JvmType type;

        JvmOptionsBuilder(JvmType type) {
            this.type = type;
        }

        void addToOptions(JvmElement jvmElement, List<String> command) {
            List<String> options;
            String heap = jvmElement.getHeapSize();
            String maxHeap = jvmElement.getMaxHeap();
            if (maxHeap == null && heap != null) {
                maxHeap = heap;
            }
            if (heap == null && maxHeap != null) {
                heap = maxHeap;
            }
            this.addPermGen(jvmElement, command);
            if (heap != null) {
                command.add("-Xms" + heap);
            }
            if (maxHeap != null) {
                command.add("-Xmx" + maxHeap);
            }
            if (jvmElement.getStack() != null) {
                command.add("-Xss" + jvmElement.getStack());
            }
            if (jvmElement.getAgentPath() != null) {
                command.add("-agentpath:" + jvmElement.getAgentPath());
            }
            if (jvmElement.getAgentLib() != null) {
                command.add("-agentlib:" + jvmElement.getAgentLib());
            }
            if (jvmElement.getJavaagent() != null) {
                command.add("-javaagent:" + jvmElement.getJavaagent());
            }
            if (jvmElement.isDebugEnabled() != null && jvmElement.isDebugEnabled().booleanValue() && jvmElement.getDebugOptions() != null) {
                command.add(jvmElement.getDebugOptions());
            }
            if ((options = jvmElement.getJvmOptions().getOptions()).size() > 0) {
                String jvmName = jvmElement.getName();
                for (String option : options) {
                    if (!this.checkOption(heap != null && option.startsWith("-Xms"), jvmName, option, Element.HEAP.toString()) || !this.checkOption(maxHeap != null && option.startsWith("-Xmx"), jvmName, option, Element.HEAP.toString()) || !this.checkOption(jvmElement.getStack() != null && option.startsWith("-Xss"), jvmName, option, Element.STACK.toString()) || !this.checkOption(jvmElement.isDebugEnabled() != null && jvmElement.isDebugEnabled() != false && jvmElement.getDebugOptions() != null && (option.startsWith("-Xrunjdwp") || option.startsWith("-agentlib:jdwp")), jvmName, option, Attribute.DEBUG_OPTIONS.toString()) || !this.checkOption(jvmElement.getAgentPath() != null && option.startsWith("-agentpath:"), jvmName, option, Element.AGENT_PATH.toString()) || !this.checkOption(jvmElement.getAgentLib() != null && option.startsWith("-agentlib:"), jvmName, option, Element.AGENT_LIB.toString()) || !this.checkOption(jvmElement.getAgentLib() != null && option.startsWith("-javaagent:"), jvmName, option, Element.AGENT_LIB.toString()) || !this.checkOption(jvmElement.getJavaagent() != null && option.startsWith("-Xmx"), jvmName, option, Element.JAVA_AGENT.toString()) || !this.checkOption(jvmElement.getJavaagent() != null && option.startsWith("-XX:PermSize"), jvmName, option, Element.PERMGEN.toString()) || !this.checkOption(jvmElement.getJavaagent() != null && option.startsWith("-XX:MaxPermSize"), jvmName, option, Element.PERMGEN.toString()) || !this.checkAdditionalJvmOption(option)) continue;
                    command.add(option);
                }
            }
        }

        boolean checkOption(boolean condition, String jvm, String option, String schemaElement) {
            if (condition) {
                HostControllerLogger.ROOT_LOGGER.optionAlreadySet(option, jvm, schemaElement);
                return false;
            }
            return true;
        }

        void addPermGen(JvmElement jvmElement, List<String> command) {
            if (jvmElement.getPermgenSize() != null || jvmElement.getMaxPermgen() != null) {
                HostControllerLogger.ROOT_LOGGER.ignoringPermGen(this.type, jvmElement.getName());
            }
        }

        boolean checkAdditionalJvmOption(String option) {
            return true;
        }
    }
}

