/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.operations.GenericModelDescribeOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ProfileDescribeHandler
extends GenericModelDescribeOperationHandler {
    public static final ProfileDescribeHandler INSTANCE = new ProfileDescribeHandler();
    public static final AttributeDefinition SERVER_LAUNCH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"server-launch", (ModelType)ModelType.BOOLEAN).setRequired(false)).setDefaultValue(new ModelNode(false))).build();
    private static final Set<Action.ActionEffect> DESCRIBE_EFFECTS = Collections.unmodifiableSet(EnumSet.of(Action.ActionEffect.ADDRESS, Action.ActionEffect.READ_CONFIG));

    private ProfileDescribeHandler() {
        super("describe", true);
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        AuthorizationResult authResult = context.authorize(operation, DESCRIBE_EFFECTS);
        authResult.failIfDenied(operation, context.getCurrentAddress());
        if (SERVER_LAUNCH.resolveModelAttribute(context, operation).asBoolean()) {
            context.attach(GenericSubsystemDescribeHandler.SERVER_LAUNCH_KEY, (Object)Boolean.TRUE);
        }
        super.execute(context, operation);
    }

    @Override
    protected void processMore(OperationContext context, ModelNode operation, Resource resource, PathAddress address, Map<String, ModelNode> includeResults) throws OperationFailedException {
        ModelNode profile = resource.getModel();
        if (profile.hasDefined("includes")) {
            for (ModelNode include : profile.get("includes").asList()) {
                String includeName = include.asString();
                ModelNode includeRsp = new ModelNode();
                includeResults.put(includeName, includeRsp);
                ModelNode includeAddress = address.subAddress(0, address.size() - 1).append(new PathElement[]{PathElement.pathElement((String)"profile", (String)includeName)}).toModelNode();
                ModelNode newOp = operation.clone();
                newOp.get("address").set(includeAddress);
                context.addStep(includeRsp, newOp, (OperationStepHandler)INSTANCE, OperationContext.Stage.MODEL, true);
            }
        }
    }
}

