/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.transformers;

import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.domain.controller.transformers.KernelAPIVersion;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayModel;
import org.jboss.dmr.ModelNode;

class DeploymentOverlayTransformers {
    DeploymentOverlayTransformers() {
    }

    static ChainedTransformationDescriptionBuilder buildTransformerChain() {
        ChainedTransformationDescriptionBuilder chainedBuilder = KernelAPIVersion.createChainFromCurrent(DeploymentOverlayModel.DEPLOYMENT_OVERRIDE_PATH);
        ResourceTransformationDescriptionBuilder builder = KernelAPIVersion.createBuilderFromCurrent(chainedBuilder, KernelAPIVersion.VERSION_1_6);
        builder.addOperationTransformationOverride("remove").setCustomOperationTransformer((context, address, operation) -> {
            Set removedContents = (Set)context.getAttachment(DeploymentOverlayModel.REMOVED_CONTENTS);
            if (removedContents != null && !removedContents.isEmpty()) {
                ModelNode compositeOp = Operations.createCompositeOperation();
                for (PathAddress removed : removedContents) {
                    if (!address.equals(removed.subAddress(0, address.size()))) continue;
                    compositeOp.get("steps").add(Operations.createRemoveOperation((ModelNode)removed.toModelNode()));
                }
                compositeOp.get("steps").add(operation);
                return new OperationTransformer.TransformedOperation(compositeOp, OperationResultTransformer.ORIGINAL_RESULT);
            }
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }).end();
        return chainedBuilder;
    }

    static void registerServerGroupTransformers1_6_AndBelow(ResourceTransformationDescriptionBuilder parent) {
        parent.addChildResource(DeploymentOverlayModel.DEPLOYMENT_OVERRIDE_PATH).addOperationTransformationOverride("remove").setCustomOperationTransformer((context, address, operation) -> {
            Set removedLinks = (Set)context.getAttachment(DeploymentOverlayModel.REMOVED_LINKS);
            if (removedLinks != null && !removedLinks.isEmpty()) {
                ModelNode compositeOp = Operations.createCompositeOperation();
                for (PathAddress removed : removedLinks) {
                    if (!address.equals(removed.subAddress(0, address.size()))) continue;
                    compositeOp.get("steps").add(Operations.createRemoveOperation((ModelNode)removed.toModelNode()));
                }
                compositeOp.get("steps").add(operation);
                return new OperationTransformer.TransformedOperation(compositeOp, OperationResultTransformer.ORIGINAL_RESULT);
            }
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }).end();
    }
}

