/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.discovery.DiscoveryOptionResourceDefinition;
import org.jboss.as.host.controller.discovery.StaticDiscoveryResourceDefinition;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.dmr.ModelNode;

public abstract class AbstractDiscoveryOptionAddHandler
extends AbstractAddStepHandler {
    public static final String OPERATION_NAME = "add";

    static void updateOptionsAttribute(OperationContext context, ModelNode operation, String type) throws OperationFailedException {
        ModelNode list;
        PathAddress operationAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress discoveryOptionsAddress = operationAddress.subAddress(0, operationAddress.size() - 1);
        ModelNode discoveryOptions = Resource.Tools.readModel((Resource)context.readResourceFromRoot(discoveryOptionsAddress));
        ModelNode element = new ModelNode();
        if ("custom-discovery".equals(type)) {
            node = element.get("custom-discovery");
            node.get("name").set(operationAddress.getLastElement().getValue());
            for (AttributeDefinition attributeDefinition : DiscoveryOptionResourceDefinition.DISCOVERY_ATTRIBUTES) {
                attributeDefinition.validateAndSet(operation, node);
            }
        } else if ("static-discovery".equals(type)) {
            node = element.get("static-discovery");
            node.get("name").set(operationAddress.getLastElement().getValue());
            for (AttributeDefinition attributeDefinition : StaticDiscoveryResourceDefinition.STATIC_DISCOVERY_ATTRIBUTES) {
                attributeDefinition.validateAndSet(operation, node);
            }
        } else {
            throw new OperationFailedException(HostControllerLogger.ROOT_LOGGER.invalidDiscoveryType(type));
        }
        if (!(list = discoveryOptions.get("options").clone()).isDefined()) {
            list.setEmptyList();
        }
        list.add(element);
        ModelNode writeOp = Util.getWriteAttributeOperation((PathAddress)discoveryOptionsAddress, (String)"options", (ModelNode)list);
        OperationStepHandler writeHandler = context.getRootResourceRegistration().getSubModel(discoveryOptionsAddress).getOperationHandler(PathAddress.EMPTY_ADDRESS, "write-attribute");
        context.addStep(writeOp, writeHandler, OperationContext.Stage.MODEL, true);
    }

    protected Resource createResource(OperationContext context) {
        return PlaceholderResource.INSTANCE;
    }
}

