/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class IgnoredNonAffectedServerGroupsUtil {
    private final ExtensionRegistry extensionRegistry;

    private IgnoredNonAffectedServerGroupsUtil(ExtensionRegistry extensionRegistry) {
        this.extensionRegistry = extensionRegistry;
    }

    public static IgnoredNonAffectedServerGroupsUtil create(ExtensionRegistry extensionRegistry) {
        return new IgnoredNonAffectedServerGroupsUtil(extensionRegistry);
    }

    public static ModelNode addCurrentServerGroupsToHostInfoModel(boolean ignoreUnaffectedServerGroups, Resource hostModel, ModelNode model) {
        if (!ignoreUnaffectedServerGroups) {
            return model;
        }
        model.get("ignore-unused-configuration").set(ignoreUnaffectedServerGroups);
        IgnoredNonAffectedServerGroupsUtil.addServerGroupsToModel(hostModel, model);
        return model;
    }

    public static void addServerGroupsToModel(Resource hostModel, ModelNode model) {
        ModelNode initialServerGroups = new ModelNode();
        initialServerGroups.setEmptyObject();
        for (Resource.ResourceEntry entry : hostModel.getChildren("server-config")) {
            ModelNode serverNode = new ModelNode();
            serverNode.get("group").set(entry.getModel().get("group"));
            if (entry.getModel().hasDefined("socket-binding-group")) {
                serverNode.get("socket-binding-group").set(entry.getModel().get("socket-binding-group").asString());
            }
            initialServerGroups.get(entry.getName()).set(serverNode);
        }
        model.get("initial-server-groups").set(initialServerGroups);
    }

    public static Set<ServerConfigInfo> createConfigsFromModel(ModelNode model) {
        HashSet<ServerConfigInfo> serverConfigs = new HashSet<ServerConfigInfo>();
        ModelNode initialServerGroups = model.get("initial-server-groups");
        for (Property prop : initialServerGroups.asPropertyList()) {
            List servers = prop.getValue().asList();
            for (ModelNode server : servers) {
                String socketBindingGroupOverride = server.hasDefined("socket-binding-group") ? server.get("socket-binding-group").asString() : null;
                ServerConfigInfo serverConfigInfo = IgnoredNonAffectedServerGroupsUtil.createServerConfigInfo(prop.getValue().get("group").asString(), socketBindingGroupOverride);
                serverConfigs.add(serverConfigInfo);
            }
        }
        return serverConfigs;
    }

    public boolean ignoreOperation(Resource domainResource, Collection<ServerConfigInfo> serverConfigs, PathAddress pathAddress) {
        if (pathAddress.size() == 0) {
            return false;
        }
        boolean ignore = this.ignoreResourceInternal(domainResource, serverConfigs, pathAddress);
        return ignore;
    }

    private boolean ignoreResourceInternal(Resource domainResource, Collection<ServerConfigInfo> serverConfigs, PathAddress pathAddress) {
        String type;
        switch (type = pathAddress.getElement(0).getKey()) {
            case "profile": {
                return this.ignoreProfile(domainResource, serverConfigs, pathAddress.getElement(0).getValue());
            }
            case "server-group": {
                return this.ignoreServerGroup(domainResource, serverConfigs, pathAddress.getElement(0).getValue());
            }
            case "socket-binding-group": {
                return this.ignoreSocketBindingGroups(domainResource, serverConfigs, pathAddress.getElement(0).getValue());
            }
        }
        return false;
    }

    private boolean ignoreProfile(Resource domainResource, Collection<ServerConfigInfo> serverConfigs, String name) {
        HashSet<String> seenGroups = new HashSet<String>();
        HashSet<String> profiles = new HashSet<String>();
        for (ServerConfigInfo serverConfig : serverConfigs) {
            if (seenGroups.contains(serverConfig.getServerGroup())) continue;
            seenGroups.add(serverConfig.getServerGroup());
            Resource serverGroupResource = domainResource.getChild(PathElement.pathElement((String)"server-group", (String)serverConfig.getServerGroup()));
            String profile = serverGroupResource.getModel().get("profile").asString();
            if (profile.equals(name)) {
                return false;
            }
            this.processProfiles(domainResource, profile, profiles);
        }
        return !profiles.contains(name);
    }

    private void processProfiles(Resource domain, String profile, Set<String> profiles) {
        if (!profiles.contains(profile)) {
            Resource resource;
            ModelNode model;
            profiles.add(profile);
            PathElement pathElement = PathElement.pathElement((String)"profile", (String)profile);
            if (domain.hasChild(pathElement) && (model = (resource = domain.getChild(pathElement)).getModel()).hasDefined("includes")) {
                for (ModelNode include : model.get("includes").asList()) {
                    this.processProfiles(domain, include.asString(), profiles);
                }
            }
        }
    }

    private boolean ignoreServerGroup(Resource domainResource, Collection<ServerConfigInfo> serverConfigs, String name) {
        for (ServerConfigInfo serverConfig : serverConfigs) {
            if (!serverConfig.getServerGroup().equals(name)) continue;
            return false;
        }
        return true;
    }

    private boolean ignoreExtension(Resource domainResource, Collection<ServerConfigInfo> serverConfigs, String name) {
        Map subsystems = this.extensionRegistry.getAvailableSubsystems(name);
        for (String subsystem : subsystems.keySet()) {
            for (Resource.ResourceEntry profileEntry : domainResource.getChildren("profile")) {
                if (!profileEntry.hasChild(PathElement.pathElement((String)"subsystem", (String)subsystem)) || this.ignoreProfile(domainResource, serverConfigs, profileEntry.getName())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean ignoreSocketBindingGroups(Resource domainResource, Collection<ServerConfigInfo> serverConfigs, String name) {
        HashSet<String> seenGroups = new HashSet<String>();
        HashSet<String> socketBindingGroups = new HashSet<String>();
        for (ServerConfigInfo serverConfig : serverConfigs) {
            String socketBindingGroup;
            if (serverConfig.getSocketBindingGroup() != null) {
                if (serverConfig.getSocketBindingGroup().equals(name)) {
                    return false;
                }
                socketBindingGroup = serverConfig.getSocketBindingGroup();
            } else {
                if (seenGroups.contains(serverConfig.getServerGroup())) continue;
                seenGroups.add(serverConfig.getServerGroup());
                Resource serverGroupResource = domainResource.getChild(PathElement.pathElement((String)"server-group", (String)serverConfig.getServerGroup()));
                socketBindingGroup = serverGroupResource.getModel().get("socket-binding-group").asString();
                if (socketBindingGroup.equals(name)) {
                    return false;
                }
            }
            this.processSocketBindingGroups(domainResource, socketBindingGroup, socketBindingGroups);
        }
        return !socketBindingGroups.contains(name);
    }

    private void processSocketBindingGroups(Resource domainResource, String name, Set<String> socketBindingGroups) {
        if (!socketBindingGroups.contains(name)) {
            Resource resource;
            ModelNode model;
            socketBindingGroups.add(name);
            PathElement pathElement = PathElement.pathElement((String)"socket-binding-group", (String)name);
            if (domainResource.hasChild(pathElement) && (model = (resource = domainResource.getChild(pathElement)).getModel()).hasDefined("includes")) {
                for (ModelNode include : model.get("includes").asList()) {
                    this.processSocketBindingGroups(domainResource, include.asString(), socketBindingGroups);
                }
            }
        }
    }

    public Set<ServerConfigInfo> getServerConfigsOnSlave(Resource hostResource) {
        HashSet<ServerConfigInfo> groups = new HashSet<ServerConfigInfo>();
        for (Resource.ResourceEntry entry : hostResource.getChildren("server-config")) {
            groups.add(new ServerConfigInfoImpl(entry.getModel()));
        }
        return groups;
    }

    public static ServerConfigInfo createServerConfigInfo(String serverGroup, String socketBindingGroup) {
        return new ServerConfigInfoImpl(serverGroup, socketBindingGroup);
    }

    public static Set<ServerConfigInfo> createConfigsFromDomainWideData(Set<String> activeServerGroups, Set<String> activeSocketBindingGroups) {
        HashSet<ServerConfigInfo> serverConfigs = new HashSet<ServerConfigInfo>();
        if (activeSocketBindingGroups == null || activeSocketBindingGroups.isEmpty()) {
            for (String serverGroup : activeServerGroups) {
                ServerConfigInfoImpl sci = new ServerConfigInfoImpl(serverGroup, null);
                serverConfigs.add(sci);
                DomainControllerLogger.ROOT_LOGGER.tracef("Domain wide host-exclude needs a simple %s", sci);
            }
        } else {
            String[] sbgs;
            String[] sgs = activeServerGroups.toArray(new String[activeServerGroups.size()]);
            if (sgs.length >= (sbgs = activeSocketBindingGroups.toArray(new String[activeSocketBindingGroups.size()])).length) {
                for (int i = 0; i < sgs.length; ++i) {
                    String sbg = i >= sbgs.length ? null : sbgs[i];
                    ServerConfigInfoImpl sci = new ServerConfigInfoImpl(sgs[i], sbg);
                    serverConfigs.add(sci);
                    DomainControllerLogger.ROOT_LOGGER.tracef("Domain wide host-exclude needs a synthetic active combination of %s", sci);
                }
            } else {
                int i = 0;
                for (int j = 0; j < sbgs.length; ++j) {
                    if (i == sgs.length) {
                        i = 0;
                    }
                    ServerConfigInfoImpl sci = new ServerConfigInfoImpl(sgs[i], sbgs[j]);
                    serverConfigs.add(sci);
                    DomainControllerLogger.ROOT_LOGGER.tracef("Domain wide host-exclude needs a synthetic active combination of %s", sci);
                    ++i;
                }
            }
        }
        return serverConfigs;
    }

    public static interface ServerConfigInfo {
        public String getServerGroup();

        public String getSocketBindingGroup();
    }

    private static class ServerConfigInfoImpl
    implements ServerConfigInfo {
        private final String serverGroup;
        private final String socketBindingGroup;

        ServerConfigInfoImpl(ModelNode model) {
            this.serverGroup = model.get("group").asString();
            this.socketBindingGroup = model.hasDefined("socket-binding-group") ? model.get("socket-binding-group").asString() : null;
        }

        ServerConfigInfoImpl(String serverGroup, String socketBindingGroup) {
            this.serverGroup = serverGroup;
            this.socketBindingGroup = socketBindingGroup;
        }

        @Override
        public String getServerGroup() {
            return this.serverGroup;
        }

        @Override
        public String getSocketBindingGroup() {
            return this.socketBindingGroup;
        }

        public String toString() {
            return "ServerConfigInfoImpl{serverGroup='" + this.serverGroup + "', socketBindingGroup='" + this.socketBindingGroup + "'}";
        }
    }
}

