/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.operations.common.OrderedChildTypesAttachment;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.operations.ReadDomainModelHandler;
import org.jboss.as.domain.controller.operations.ReadMasterDomainModelUtil;
import org.jboss.as.domain.controller.operations.ReadMasterDomainOperationsHandler;
import org.jboss.as.domain.controller.operations.SyncModelOperationHandler;
import org.jboss.as.domain.controller.operations.deployment.SyncModelParameters;
import org.jboss.as.host.controller.mgmt.HostControllerRegistrationHandler;
import org.jboss.dmr.ModelNode;

abstract class SyncModelHandlerBase
implements OperationStepHandler {
    private static final Transformers TRANSFORMERS = Transformers.Factory.createLocal();
    private static final ModelNode OPERATION = new ModelNode();
    private final SyncModelParameters parameters;

    protected SyncModelHandlerBase(SyncModelParameters parameters) {
        this.parameters = parameters;
    }

    abstract Transformers.ResourceIgnoredTransformationRegistry createRegistry(OperationContext var1, Resource var2, Set<String> var3);

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final HashSet<String> remoteExtensions = new HashSet<String>();
        final Resource remote = ReadMasterDomainModelUtil.createResourceFromDomainModelOp(operation.require("domain-model"), remoteExtensions);
        Transformers.ResourceIgnoredTransformationRegistry ignoredTransformationRegistry = this.createRegistry(context, remote, remoteExtensions);
        ReadDomainModelHandler readModelHandler = new ReadDomainModelHandler(ignoredTransformationRegistry, TRANSFORMERS, true);
        HostControllerRegistrationHandler.OperationExecutor operationExecutor = this.parameters.getOperationExecutor();
        ModelNode localModel = operationExecutor.executeReadOnly(OPERATION, readModelHandler, ModelController.OperationTransactionControl.COMMIT);
        if (localModel.hasDefined("failure-description")) {
            context.getFailureDescription().set(localModel.get("failure-description"));
            return;
        }
        HashSet<String> localExtensions = new HashSet<String>();
        Resource transformedResource = ReadMasterDomainModelUtil.createResourceFromDomainModelOp(localModel.get("result"), localExtensions);
        OrderedChildTypesAttachment orderedChildTypesAttachment = new OrderedChildTypesAttachment();
        final ReadMasterDomainOperationsHandler readOperationHandler = new ReadMasterDomainOperationsHandler();
        final ModelNode localOperations = operationExecutor.executeReadOnly(OPERATION, transformedResource, readOperationHandler, ModelController.OperationTransactionControl.COMMIT);
        if (localOperations.hasDefined("failure-description")) {
            context.getFailureDescription().set(localOperations.get("failure-description"));
            return;
        }
        for (String extension : localExtensions) {
            remoteExtensions.remove(extension);
        }
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                HostControllerRegistrationHandler.OperationExecutor operationExecutor = SyncModelHandlerBase.this.parameters.getOperationExecutor();
                ModelNode result = localOperations.get("result");
                SyncModelOperationHandler handler = new SyncModelOperationHandler(result.asList(), remote, remoteExtensions, SyncModelHandlerBase.this.parameters, readOperationHandler.getOrderedChildTypes());
                context.addStep(operation, (OperationStepHandler)handler, OperationContext.Stage.MODEL, true);
            }
        }, OperationContext.Stage.MODEL, true);
    }

    protected SyncModelParameters getParameters() {
        return this.parameters;
    }

    static {
        OPERATION.get("operation").set("sync");
        OPERATION.get("address").setEmptyList();
    }
}

