/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.coordination.HostControllerExecutionSupport;
import org.jboss.as.domain.controller.operations.coordination.MultiPhaseLocalContext;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationResolver;
import org.jboss.dmr.ModelNode;

public class ServerOperationsResolverHandler
implements OperationStepHandler {
    public static final String DOMAIN_PUSH_TO_SERVERS = "push-to-servers";
    public static final String OPERATION_NAME = "server-operation-resolver";
    private static final HostControllerExecutionSupport.ServerOperationProvider NO_OP_PROVIDER = new HostControllerExecutionSupport.ServerOperationProvider(){

        @Override
        public Map<Set<ServerIdentity>, ModelNode> getServerOperations(ModelNode domainOp, PathAddress address) {
            return Collections.emptyMap();
        }
    };
    private final ServerOperationResolver resolver;
    private final HostControllerExecutionSupport hostControllerExecutionSupport;
    private final PathAddress originalAddress;
    private final ImmutableManagementResourceRegistration originalRegistration;
    private final MultiPhaseLocalContext multiPhaseLocalContext;

    ServerOperationsResolverHandler(ServerOperationResolver resolver, HostControllerExecutionSupport hostControllerExecutionSupport, PathAddress originalAddress, ImmutableManagementResourceRegistration originalRegistration, MultiPhaseLocalContext multiPhaseLocalContext) {
        this.resolver = resolver;
        this.hostControllerExecutionSupport = hostControllerExecutionSupport;
        this.originalAddress = originalAddress;
        this.originalRegistration = originalRegistration;
        this.multiPhaseLocalContext = multiPhaseLocalContext;
    }

    public void execute(final OperationContext context, ModelNode operation) throws OperationFailedException {
        if (this.multiPhaseLocalContext.getLocalResponse().has("failure-description")) {
            context.setRollbackOnly();
        } else {
            context.attachIfAbsent(CompositeOperationHandler.DOMAIN_EXECUTION_KEY, (Object)Boolean.TRUE);
            boolean nullDomainOp = this.hostControllerExecutionSupport.getDomainOperation() == null;
            final boolean pushToServers = operation.hasDefined("operation-headers") && operation.get(new String[]{"operation-headers", DOMAIN_PUSH_TO_SERVERS}).asBoolean(false);
            HostControllerExecutionSupport.ServerOperationProvider provider = nullDomainOp ? NO_OP_PROVIDER : new HostControllerExecutionSupport.ServerOperationProvider(){

                @Override
                public Map<Set<ServerIdentity>, ModelNode> getServerOperations(ModelNode domainOp, PathAddress address) {
                    Map ops = ServerOperationsResolverHandler.this.getServerOperations(context, domainOp, address, pushToServers);
                    for (Map.Entry entry : ops.entrySet()) {
                        ModelNode op = (ModelNode)entry.getValue();
                        if (!op.hasDefined(new String[]{"operation-headers", "caller-type"}) || !op.get(new String[]{"operation-headers", "caller-type"}).asString().equals("user")) continue;
                        op.get("operation-headers").remove("caller-type");
                    }
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Server ops for %s -- %s", domainOp, ops);
                    return ops;
                }
            };
            Map<ServerIdentity, ModelNode> serverOps = this.hostControllerExecutionSupport.getServerOps(provider);
            ModelNode formattedServerOps = this.getFormattedServerOps(serverOps);
            if (this.multiPhaseLocalContext.isCoordinator()) {
                this.multiPhaseLocalContext.getLocalServerOps().set(formattedServerOps);
                if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("%s server ops local response node is %s", this.getClass().getSimpleName(), formattedServerOps);
                }
            } else {
                ModelNode localResult = nullDomainOp ? new ModelNode("ignored-by-unaffected-host-controller") : this.multiPhaseLocalContext.getLocalResponse().get("result");
                ModelNode domainResult = this.hostControllerExecutionSupport.getFormattedDomainResult(localResult);
                ModelNode contextResult = context.getResult();
                contextResult.setEmptyObject();
                contextResult.get("domain-results").set(domainResult);
                contextResult.get("server-operations").set(formattedServerOps);
                if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("%s server ops remote response node is %s", this.getClass().getSimpleName(), contextResult);
                }
            }
        }
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerOperations(OperationContext context, ModelNode domainOp, PathAddress domainOpAddress, boolean pushToServers) {
        Set flags;
        Map<Set<ServerIdentity>, Object> result = null;
        PathAddress relativeAddress = domainOpAddress.subAddress(this.originalAddress.size());
        if (!pushToServers && (flags = this.originalRegistration.getOperationFlags(relativeAddress, domainOp.require("operation").asString())).contains(OperationEntry.Flag.READ_ONLY) && !flags.contains(OperationEntry.Flag.DOMAIN_PUSH_TO_SERVERS)) {
            result = Collections.emptyMap();
        }
        if (result == null) {
            result = this.resolver.getServerOperations(context, domainOp, domainOpAddress);
        }
        return result;
    }

    private ModelNode getFormattedServerOps(Map<ServerIdentity, ModelNode> serverOps) {
        ModelNode serverOpsNode = new ModelNode();
        HashMap<ModelNode, HashSet<ServerIdentity>> bundled = new HashMap<ModelNode, HashSet<ServerIdentity>>();
        for (Map.Entry<ServerIdentity, ModelNode> entry : serverOps.entrySet()) {
            HashSet<ServerIdentity> idSet = (HashSet<ServerIdentity>)bundled.get(entry.getValue());
            if (idSet == null) {
                idSet = new HashSet<ServerIdentity>();
                bundled.put(entry.getValue(), idSet);
            }
            idSet.add(entry.getKey());
        }
        for (Map.Entry<ServerIdentity, Object> entry : bundled.entrySet()) {
            ModelNode setNode = serverOpsNode.add();
            ModelNode serverNode = setNode.get("servers");
            serverNode.setEmptyList();
            for (ServerIdentity server : (Set)entry.getValue()) {
                serverNode.add(server.getServerName(), server.getServerGroupName());
            }
            setNode.get("operation").set((ModelNode)entry.getKey());
        }
        return serverOpsNode;
    }
}

