/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.common.Assert;

public class ServerGroupDeploymentReplaceHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "replace-deployment";
    private final HostFileRepository fileRepository;
    private final ContentRepository contentRepository;

    public ServerGroupDeploymentReplaceHandler(HostFileRepository fileRepository, ContentRepository contentRepository) {
        Assert.checkNotNullParam((String)"fileRepository", (Object)fileRepository);
        this.fileRepository = fileRepository;
        this.contentRepository = contentRepository;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        boolean shouldCreateResource;
        Resource domainDeployment;
        String toReplace;
        for (AttributeDefinition def : DeploymentAttributes.SERVER_GROUP_REPLACE_DEPLOYMENT_ATTRIBUTES.values()) {
            def.validateOperation(operation);
        }
        String name = ((AttributeDefinition)DeploymentAttributes.SERVER_GROUP_REPLACE_DEPLOYMENT_ATTRIBUTES.get("name")).resolveModelAttribute(context, operation).asString();
        if (name.equals(toReplace = ((AttributeDefinition)DeploymentAttributes.SERVER_GROUP_REPLACE_DEPLOYMENT_ATTRIBUTES.get("to-replace")).resolveModelAttribute(context, operation).asString())) {
            throw ServerGroupDeploymentReplaceHandler.operationFailed(DomainControllerLogger.ROOT_LOGGER.cannotUseSameValueForParameters(OPERATION_NAME, "name", "to-replace", "redeploy", "full-replace-deployment"));
        }
        PathElement deploymentPath = PathElement.pathElement((String)"deployment", (String)name);
        PathElement replacePath = PathElement.pathElement((String)"deployment", (String)toReplace);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        try {
            domainDeployment = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{deploymentPath}));
        }
        catch (NoSuchElementException e) {
            throw ServerGroupDeploymentReplaceHandler.operationFailed(DomainControllerLogger.ROOT_LOGGER.noDeploymentContentWithName(name));
        }
        ModelNode deployment = domainDeployment.getModel();
        final LinkedList<ContentReference> locallyAddedReferences = new LinkedList<ContentReference>();
        for (ModelNode content : deployment.require("content").asList()) {
            if (!content.hasDefined("hash")) continue;
            ContentReference reference = ModelContentReference.fromModelAddress((PathAddress)address, (byte[])content.require("hash").asBytes());
            this.fileRepository.getDeploymentFiles(reference);
            locallyAddedReferences.add(reference);
        }
        Resource serverGroup = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        if (!serverGroup.hasChild(replacePath)) {
            throw ServerGroupDeploymentReplaceHandler.operationFailed(DomainControllerLogger.ROOT_LOGGER.noDeploymentContentWithName(toReplace));
        }
        Resource replaceResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{replacePath}));
        boolean bl = shouldCreateResource = !serverGroup.hasChild(deploymentPath);
        if (shouldCreateResource) {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{deploymentPath}));
            ModelNode deployNode = resource.getModel();
            deployNode.set(deployment);
            deployNode.remove("content");
            deployNode.get("enabled").set(true);
        } else {
            ModelNode enabled;
            Resource deploymentResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{deploymentPath}));
            ModelNode modelNode = enabled = deploymentResource.getModel().hasDefined("enabled") ? deploymentResource.getModel().get("enabled") : new ModelNode(false);
            if (enabled.getType() == ModelType.BOOLEAN && enabled.asBoolean()) {
                throw ServerGroupDeploymentReplaceHandler.operationFailed(DomainControllerLogger.ROOT_LOGGER.deploymentAlreadyStarted(toReplace));
            }
            deploymentResource.getModel().get("enabled").set(true);
        }
        replaceResource.getModel().get("enabled").set(false);
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                if (resultAction == OperationContext.ResultAction.KEEP && ServerGroupDeploymentReplaceHandler.this.contentRepository != null && shouldCreateResource) {
                    for (ContentReference reference : locallyAddedReferences) {
                        ServerGroupDeploymentReplaceHandler.this.contentRepository.addContentReference(reference);
                    }
                }
            }
        });
    }

    private static OperationFailedException operationFailed(String msg) {
        return new OperationFailedException(msg);
    }
}

