/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.resources;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.NoopOperationStepHandler;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.operations.common.InterfaceRemoveHandler;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.model.jvm.JvmResourceDefinition;
import org.jboss.as.host.controller.operations.ServerAddHandler;
import org.jboss.as.host.controller.operations.ServerProcessHandlers;
import org.jboss.as.host.controller.operations.ServerReloadHandler;
import org.jboss.as.host.controller.operations.ServerRemoveHandler;
import org.jboss.as.host.controller.operations.ServerRestartHandler;
import org.jboss.as.host.controller.operations.ServerRestartRequiredServerConfigWriteAttributeHandler;
import org.jboss.as.host.controller.operations.ServerResumeHandler;
import org.jboss.as.host.controller.operations.ServerStartHandler;
import org.jboss.as.host.controller.operations.ServerStatusHandler;
import org.jboss.as.host.controller.operations.ServerStopHandler;
import org.jboss.as.host.controller.operations.ServerSuspendHandler;
import org.jboss.as.host.controller.resources.SslLoopbackResourceDefinition;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.as.server.services.net.InterfaceAddHandler;
import org.jboss.as.server.services.net.InterfaceResourceDefinition;
import org.jboss.as.server.services.net.SpecifiedInterfaceAddHandler;
import org.jboss.as.server.services.net.SpecifiedInterfaceRemoveHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServerConfigResourceDefinition
extends SimpleResourceDefinition {
    static final String SERVER_CONFIG_CAPABILITY_NAME = "org.wildfly.domain.server-config";
    public static final RuntimeCapability SERVER_CONFIG_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.domain.server-config", (boolean)true).build();
    public static final AttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING).setResourceOnly()).build();
    public static final SimpleAttributeDefinition AUTO_START = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"auto-start", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).build();
    public static final SimpleAttributeDefinition UPDATE_AUTO_START_WITH_SERVER_STATUS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"update-auto-start-with-server-status", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(false)).setDefaultValue(new ModelNode(false))).build();
    public static final SimpleAttributeDefinition SOCKET_BINDING_GROUP = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"socket-binding-group", (ModelType)ModelType.STRING, (boolean)true).setCapabilityReference("org.wildfly.domain.socket-binding-group", "org.wildfly.domain.server-config", true)).build();
    public static final SimpleAttributeDefinition SOCKET_BINDING_DEFAULT_INTERFACE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("socket-binding-default-interface", ModelType.STRING, true).setAllowExpression(false)).setXmlName(Attribute.DEFAULT_INTERFACE.getLocalName())).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).setCapabilityReference("org.wildfly.network.interface", SERVER_CONFIG_CAPABILITY)).build();
    public static final SimpleAttributeDefinition SOCKET_BINDING_PORT_OFFSET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"socket-binding-port-offset", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(0))).setXmlName(Attribute.PORT_OFFSET.getLocalName())).setValidator((ParameterValidator)new IntRangeValidator(-65535, 65535, true, true))).build();
    public static final SimpleAttributeDefinition GROUP = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"group", (ModelType)ModelType.STRING).setCapabilityReference("org.wildfly.domain.server-group", "org.wildfly.domain.server-config", true)).build();
    public static final SimpleAttributeDefinition STATUS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"status", (ModelType)ModelType.STRING).setStorageRuntime()).setRuntimeServiceNotRequired()).setValidator((ParameterValidator)new EnumValidator(ServerStatus.class, false, false))).build();
    public static final AttributeDefinition PRIORITY = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"priority", (ModelType)ModelType.INT, (boolean)true).setDeprecated(ModelVersion.create((int)1, (int)4))).build();
    public static final AttributeDefinition CPU_AFFINITY = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"cpu-affinity", (ModelType)ModelType.STRING, (boolean)true).setDeprecated(ModelVersion.create((int)1, (int)4))).build();
    public static final List<SimpleAttributeDefinition> WRITABLE_ATTRIBUTES = Arrays.asList(AUTO_START, UPDATE_AUTO_START_WITH_SERVER_STATUS, SOCKET_BINDING_GROUP, SOCKET_BINDING_DEFAULT_INTERFACE, SOCKET_BINDING_PORT_OFFSET, GROUP);
    private final ServerInventory serverInventory;
    private final PathManagerService pathManager;

    public ServerConfigResourceDefinition(LocalHostControllerInfo hostControllerInfo, ServerInventory serverInventory, PathManagerService pathManager, ControlledProcessState processState, File domainDataDir) {
        super(PathElement.pathElement((String)"server-config"), HostResolver.getResolver("server-config", false), (OperationStepHandler)ServerAddHandler.create(hostControllerInfo, serverInventory, processState, domainDataDir), (OperationStepHandler)ServerRemoveHandler.INSTANCE);
        assert (pathManager != null) : "pathManager is null";
        this.serverInventory = serverInventory;
        this.pathManager = pathManager;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute(NAME, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)AUTO_START, null, (OperationStepHandler)new ModelOnlyWriteAttributeHandler(new AttributeDefinition[]{AUTO_START}));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)UPDATE_AUTO_START_WITH_SERVER_STATUS, null, (OperationStepHandler)new ModelOnlyWriteAttributeHandler(new AttributeDefinition[]{UPDATE_AUTO_START_WITH_SERVER_STATUS}));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SOCKET_BINDING_GROUP, null, ServerRestartRequiredServerConfigWriteAttributeHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SOCKET_BINDING_DEFAULT_INTERFACE, null, ServerRestartRequiredServerConfigWriteAttributeHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SOCKET_BINDING_PORT_OFFSET, null, ServerRestartRequiredServerConfigWriteAttributeHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)GROUP, null, ServerRestartRequiredServerConfigWriteAttributeHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute(PRIORITY, (OperationStepHandler)NoopOperationStepHandler.WITH_RESULT, (OperationStepHandler)NoopOperationStepHandler.WITHOUT_RESULT);
        resourceRegistration.registerReadWriteAttribute(CPU_AFFINITY, (OperationStepHandler)NoopOperationStepHandler.WITH_RESULT, (OperationStepHandler)NoopOperationStepHandler.WITHOUT_RESULT);
        if (this.serverInventory != null) {
            resourceRegistration.registerMetric((AttributeDefinition)STATUS, (OperationStepHandler)new ServerStatusHandler(this.serverInventory));
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.serverInventory != null) {
            ServerConfigResourceDefinition.registerServerLifecycleOperations(resourceRegistration, this.serverInventory);
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)PathResourceDefinition.createSpecifiedNoServices());
        resourceRegistration.registerSubModel((ResourceDefinition)new InterfaceResourceDefinition((InterfaceAddHandler)SpecifiedInterfaceAddHandler.INSTANCE, (InterfaceRemoveHandler)SpecifiedInterfaceRemoveHandler.INSTANCE, true, false));
        resourceRegistration.registerSubModel((ResourceDefinition)SystemPropertyResourceDefinition.createForDomainOrHost((SystemPropertyResourceDefinition.Location)SystemPropertyResourceDefinition.Location.SERVER_CONFIG));
        resourceRegistration.registerSubModel((ResourceDefinition)JvmResourceDefinition.SERVER);
        resourceRegistration.registerSubModel((ResourceDefinition)new SslLoopbackResourceDefinition());
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(SERVER_CONFIG_CAPABILITY);
    }

    public static void registerServerLifecycleOperations(ManagementResourceRegistration resourceRegistration, ServerInventory serverInventory) {
        ServerStartHandler startHandler = new ServerStartHandler(serverInventory);
        resourceRegistration.registerOperationHandler(ServerStartHandler.DEFINITION, (OperationStepHandler)startHandler);
        ServerRestartHandler restartHandler = new ServerRestartHandler(serverInventory);
        resourceRegistration.registerOperationHandler(ServerRestartHandler.DEFINITION, (OperationStepHandler)restartHandler);
        ServerStopHandler stopHandler = new ServerStopHandler(serverInventory);
        resourceRegistration.registerOperationHandler(ServerStopHandler.DEFINITION, (OperationStepHandler)stopHandler);
        ServerReloadHandler reloadHandler = new ServerReloadHandler(serverInventory);
        resourceRegistration.registerOperationHandler(ServerReloadHandler.DEFINITION, (OperationStepHandler)reloadHandler);
        resourceRegistration.registerOperationHandler(ServerSuspendHandler.DEFINITION, (OperationStepHandler)new ServerSuspendHandler(serverInventory));
        resourceRegistration.registerOperationHandler(ServerResumeHandler.DEFINITION, (OperationStepHandler)new ServerResumeHandler(serverInventory));
        ServerProcessHandlers.ServerDestroyHandler destroyHandler = new ServerProcessHandlers.ServerDestroyHandler(serverInventory);
        resourceRegistration.registerOperationHandler(ServerProcessHandlers.DESTROY_OPERATION, (OperationStepHandler)destroyHandler);
        ServerProcessHandlers.ServerKillHandler killHandler = new ServerProcessHandlers.ServerKillHandler(serverInventory);
        resourceRegistration.registerOperationHandler(ServerProcessHandlers.KILL_OPERATION, (OperationStepHandler)killHandler);
    }
}

