/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.BootErrorCollector;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.access.Authorizer;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.common.ValidateOperationHandler;
import org.jboss.as.controller.operations.global.GlobalNotifications;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.management.security.WhoAmIOperation;
import org.jboss.as.host.controller.HostControllerConfigurationPersister;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.descriptions.HostEnvironmentResourceDefinition;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.model.host.HostResourceDefinition;
import org.jboss.as.host.controller.operations.DomainControllerWriteAttributeHandler;
import org.jboss.as.host.controller.operations.HostModelRegistrationHandler;
import org.jboss.as.host.controller.operations.LocalDomainControllerAddHandler;
import org.jboss.as.host.controller.operations.LocalDomainControllerRemoveHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.host.controller.operations.RemoteDomainControllerAddHandler;
import org.jboss.as.host.controller.operations.RemoteDomainControllerRemoveHandler;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.services.security.AbstractVaultReader;

public class HostModelUtil {
    public static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder("host");
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), HostEnvironmentResourceDefinition.class.getPackage().getName() + ".LocalDescriptions", HostModelUtil.class.getClassLoader(), true, false);
    }

    public static void createRootRegistry(ManagementResourceRegistration root, HostControllerEnvironment environment, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, HostModelRegistrar hostModelRegistrar, ProcessType processType, DelegatingConfigurableAuthorizer authorizer, Resource modelControllerResource) {
        HostModelRegistrationHandler hostModelRegistratorHandler = new HostModelRegistrationHandler(environment, ignoredDomainResourceRegistry, hostModelRegistrar, modelControllerResource);
        root.registerOperationHandler(HostModelRegistrationHandler.DEFINITION, (OperationStepHandler)hostModelRegistratorHandler);
        GlobalOperationHandlers.registerGlobalOperations((ManagementResourceRegistration)root, (ProcessType)processType);
        GlobalNotifications.registerGlobalNotifications((ManagementResourceRegistration)root, (ProcessType)processType);
        if (root.getOperationEntry(PathAddress.EMPTY_ADDRESS, ValidateOperationHandler.DEFINITION.getName()) == null) {
            root.registerOperationHandler(ValidateOperationHandler.DEFINITION, (OperationStepHandler)ValidateOperationHandler.INSTANCE);
        }
        root.registerOperationHandler((OperationDefinition)WhoAmIOperation.DEFINITION, WhoAmIOperation.createOperation((Authorizer)authorizer), true);
        root.registerOperationHandler(CompositeOperationHandler.DEFINITION, (OperationStepHandler)CompositeOperationHandler.INSTANCE);
    }

    public static ManagementResourceRegistration createHostRegistry(String hostName, ManagementResourceRegistration root, HostControllerConfigurationPersister configurationPersister, HostControllerEnvironment environment, HostRunningModeControl runningModeControl, HostFileRepository localFileRepository, LocalHostControllerInfoImpl hostControllerInfo, ServerInventory serverInventory, HostFileRepository remoteFileRepository, ContentRepository contentRepository, DomainController domainController, ExtensionRegistry hostExtensionRegistry, ExtensionRegistry extensionRegistry, AbstractVaultReader vaultReader, IgnoredDomainResourceRegistry ignoredRegistry, ControlledProcessState processState, PathManagerService pathManager, DelegatingConfigurableAuthorizer authorizer, ManagedAuditLogger auditLogger, BootErrorCollector bootErrorCollector) {
        ManagementResourceRegistration hostRegistration = root.registerSubModel((ResourceDefinition)new HostResourceDefinition(hostName, configurationPersister, environment, runningModeControl, localFileRepository, hostControllerInfo, serverInventory, remoteFileRepository, contentRepository, domainController, hostExtensionRegistry, vaultReader, ignoredRegistry, processState, pathManager, authorizer, auditLogger, bootErrorCollector));
        hostRegistration.registerReadWriteAttribute((AttributeDefinition)HostResourceDefinition.DOMAIN_CONTROLLER, null, (OperationStepHandler)DomainControllerWriteAttributeHandler.getInstance(root, hostControllerInfo, configurationPersister, localFileRepository, remoteFileRepository, contentRepository, domainController, extensionRegistry, ignoredRegistry, pathManager));
        LocalDomainControllerAddHandler localDcAddHandler = LocalDomainControllerAddHandler.getInstance(root, hostControllerInfo, configurationPersister, localFileRepository, contentRepository, domainController, extensionRegistry, pathManager);
        hostRegistration.registerOperationHandler(LocalDomainControllerAddHandler.DEFINITION, (OperationStepHandler)localDcAddHandler);
        hostRegistration.registerOperationHandler(LocalDomainControllerRemoveHandler.DEFINITION, (OperationStepHandler)LocalDomainControllerRemoveHandler.INSTANCE);
        RemoteDomainControllerAddHandler remoteDcAddHandler = new RemoteDomainControllerAddHandler(root, hostControllerInfo, domainController, configurationPersister, contentRepository, remoteFileRepository, extensionRegistry, ignoredRegistry, pathManager);
        hostRegistration.registerOperationHandler(RemoteDomainControllerAddHandler.DEFINITION, (OperationStepHandler)remoteDcAddHandler);
        hostRegistration.registerOperationHandler(RemoteDomainControllerRemoveHandler.DEFINITION, (OperationStepHandler)RemoteDomainControllerRemoveHandler.INSTANCE);
        return hostRegistration;
    }

    public static interface HostModelRegistrar {
        public void registerHostModel(String var1, ManagementResourceRegistration var2);
    }
}

