/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.management.BaseNativeInterfaceAddStepHandler;
import org.jboss.as.controller.management.NativeInterfaceCommonPolicy;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.host.controller.operations.NativeManagementServices;
import org.jboss.as.host.controller.resources.NativeManagementResourceDefinition;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.xnio.OptionMap;

public class NativeManagementAddHandler
extends BaseNativeInterfaceAddStepHandler {
    public static final String OPERATION_NAME = "add";
    private final LocalHostControllerInfoImpl hostControllerInfo;

    public NativeManagementAddHandler(LocalHostControllerInfoImpl hostControllerInfo) {
        super(NativeManagementResourceDefinition.ATTRIBUTE_DEFINITIONS);
        this.hostControllerInfo = hostControllerInfo;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return super.requiresRuntime(context) && context.getProcessType() != ProcessType.EMBEDDED_HOST_CONTROLLER;
    }

    protected List<ServiceName> installServices(OperationContext context, NativeInterfaceCommonPolicy commonPolicy, ModelNode model) throws OperationFailedException {
        NativeManagementAddHandler.populateHostControllerInfo(this.hostControllerInfo, context, model);
        ServiceTarget serviceTarget = context.getServiceTarget();
        boolean onDemand = context.isBooting();
        NativeManagementServices.installRemotingServicesIfNotInstalled(serviceTarget, this.hostControllerInfo.getLocalHostName(), context.getServiceRegistry(false), onDemand);
        OptionMap options = NativeManagementAddHandler.createConnectorOptions(commonPolicy);
        ServiceName nativeManagementInterfaceBinding = NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{this.hostControllerInfo.getNativeManagementInterface()});
        String securityRealm = commonPolicy.getSecurityRealm();
        if (securityRealm == null) {
            HostControllerLogger.ROOT_LOGGER.nativeManagementInterfaceIsUnsecured();
        }
        NativeManagementServices.installManagementWorkerService(serviceTarget, context.getServiceRegistry(false));
        ManagementRemotingServices.installDomainConnectorServices((ServiceTarget)serviceTarget, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (ServiceName)nativeManagementInterfaceBinding, (int)this.hostControllerInfo.getNativeManagementPort(), (String)securityRealm, (OptionMap)options);
        return Arrays.asList(RemotingServices.REMOTING_BASE.append(new String[]{"server", "management"}), nativeManagementInterfaceBinding);
    }

    static void populateHostControllerInfo(LocalHostControllerInfoImpl hostControllerInfo, OperationContext context, ModelNode model) throws OperationFailedException {
        hostControllerInfo.setNativeManagementInterface(NativeManagementResourceDefinition.INTERFACE.resolveModelAttribute(context, model).asString());
        ModelNode portNode = NativeManagementResourceDefinition.NATIVE_PORT.resolveModelAttribute(context, model);
        hostControllerInfo.setNativeManagementPort(portNode.isDefined() ? portNode.asInt() : -1);
    }

    private static OptionMap createConnectorOptions(NativeInterfaceCommonPolicy commonPolicy) throws OperationFailedException {
        OptionMap.Builder builder = OptionMap.builder();
        builder.addAll(NativeManagementServices.CONNECTION_OPTIONS);
        builder.addAll(commonPolicy.getConnectorOptions());
        return builder.getMap();
    }
}

