/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.logging;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.security.sasl.SaslException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.model.host.AdminOnlyDomainConfigPolicy;
import org.jboss.as.host.controller.model.jvm.JvmType;
import org.jboss.as.protocol.mgmt.RequestProcessingException;
import org.jboss.as.server.ServerState;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.remoting3.Channel;

@MessageLogger(projectCode="WFLYHC", length=4)
public interface HostControllerLogger
extends BasicLogger {
    public static final HostControllerLogger ROOT_LOGGER = (HostControllerLogger)Logger.getMessageLogger(HostControllerLogger.class, (String)"org.jboss.as.host.controller");
    public static final HostControllerLogger DOMAIN_LOGGER = (HostControllerLogger)Logger.getMessageLogger(HostControllerLogger.class, (String)"org.jboss.as.domain.controller");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="Could not connect to remote domain controller %s -- %s")
    public void cannotConnect(URI var1, Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=2, value="Could not connect to master. Aborting. Error was: %s")
    public void cannotConnectToMaster(Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Creating http management service using network interface (%s) port (%d) securePort (%d)")
    public void creatingHttpManagementService(String var1, int var2, int var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="Error retrieving domain model from remote domain controller %s:%d: %s")
    public void errorRetrievingDomainModel(String var1, int var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="Existing server [%s] with status: %s")
    public void existingServerWithState(String var1, ServerStatus var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=6, value="Failed to create server process %s")
    public void failedToCreateServerProcess(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=7, value="Failed to send reconnect message to server %s")
    public void failedToSendReconnect(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=8, value="Failed to start server (%s)")
    public void failedToStartServer(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=9, value="Failed to stop server (%s)")
    public void failedToStopServer(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10, value="Graceful shutdown of server %s was requested but is not presently supported. Falling back to rapid shutdown.")
    public void gracefulShutdownNotSupported(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11, value="Ignoring <permgen> for jvm '%s' type jvm: %s")
    public void ignoringPermGen(JvmType var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=12, value="No <domain-controller> configuration was provided and the current running mode ('%s') requires access to the Domain Controller host. Startup will be aborted. Use the %s command line argument to start in %s mode if you need to start without a domain controller connection and then use the management tools to configure one.")
    public void noDomainControllerConfigurationProvided(RunningMode var1, String var2, RunningMode var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13, value="No security realm defined for http management service, all access will be unrestricted.")
    public void noSecurityRealmDefined();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14, value="No server called %s available")
    public void noServerAvailable(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15, value="Connection to remote host-controller closed. Trying to reconnect.")
    public void lostRemoteDomainConnection();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=16, value="Ignoring <option value=\"%s\" for jvm '%s' since '%s' was set")
    public void optionAlreadySet(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18, value="Reconnecting server %s")
    public void reconnectingServer(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=19, value="Registered remote slave host \"%s\", %s")
    public void registeredRemoteSlaveHost(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20, value="Registering server %s")
    public void registeringServer(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=21, value="Server [%s] connected using connection [%s]")
    public void serverConnected(String var1, Channel var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22, value="Graceful shutdown of the handler used for messages from other Host Controllers did not cleanly complete but shutdown of the underlying communication channel is proceeding")
    public void serviceShutdownIncomplete(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=23, value="Starting server %s")
    public void startingServer(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=24, value="Stopping server %s")
    public void stoppingServer(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=25, value="Server %s is not in the expected %s state: %s")
    public void unexpectedServerState(String var1, ServerState var2, ServerState var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=26, value="Unregistered remote slave host \"%s\"")
    public void unregisteredRemoteSlaveHost(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=27, value="Unregistering server %s")
    public void unregisteringServer(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=28, value="Registered at domain controller")
    public void registeredAtRemoteHostController();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=29, value="Unregistered at domain controller")
    public void unregisteredAtRemoteHostController();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=30, value="Connection to remote host \"%s\" closed unexpectedly")
    public void lostConnectionToRemoteHost(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=31, value="Cannot load the domain model using --backup")
    public void invalidRemoteBackupPersisterState();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=32, value="Cannot store the domain model using --cached-dc")
    public void invalidCachedPersisterState();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=33, value="Caught exception during boot")
    public void caughtExceptionDuringBoot(@Cause Exception var1);

    @Message(id=34, value="Host Controller boot has failed in an unrecoverable manner; exiting. See previous messages for details.")
    public String unsuccessfulBoot();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=35, value="Installation of the domain-wide configuration has failed. Because the running mode of this Host Controller is ADMIN_ONLY boot has been allowed to proceed. If ADMIN_ONLY mode were not in effect the process would be terminated due to a critical boot failure.")
    public void reportAdminOnlyDomainXmlFailure();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=36, value="Graceful shutdown of the handler used for messages from other Host Controllers did not complete within [%d] ms but shutdown of the underlying communication channel is proceeding")
    public void gracefulManagementChannelHandlerShutdownTimedOut(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=37, value="The master host controller has been restarted. Re-registering this slave host controller with the new master.")
    public void masterHostControllerChanged();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=38, value="The master host controller could not be reached in the last [%d] milliseconds. Re-connecting.")
    public void masterHostControllerUnreachable(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=39, value="The slave host controller \"%s\" has been restarted or is attempting to reconnect. Unregistering the current connection to this slave.")
    public void slaveHostControllerChanged(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=40, value="The slave host controller \"%s\"  could not be reached in the last [%d] milliseconds. Unregistering.")
    public void slaveHostControllerUnreachable(String var1, long var2);

    @Message(id=41, value="Argument expected for option %s. %s")
    public String argumentExpected(String var1, String var2);

    @Message(id=42, value="Attempting to set '%s' when '%s' was already set")
    public IllegalArgumentException attemptingToSet(String var1, String var2);

    @Message(id=43, value="Unable to connect due to authentication failure.")
    public IllegalStateException authenticationFailureUnableToConnect(@Cause Throwable var1);

    @Message(id=44, value="Cannot access a remote file repository from the master domain controller")
    public IllegalStateException cannotAccessRemoteFileRepository();

    @Message(id=45, value="Unable to create local directory: %s")
    public IOException cannotCreateLocalDirectory(File var1);

    @Message(id=46, value="Cannot obtain a valid default address for communicating with the ProcessController using either %s or InetAddress.getLocalHost(). Please check your system's network configuration or use the %s command line switch to configure a valid address")
    public RuntimeException cannotObtainValidDefaultAddress(@Cause Throwable var1, String var2, String var3);

    @Message(id=47, value="Cannot restart server %s as it is not currently started; it is %s")
    public String cannotRestartServer(String var1, ServerStatus var2);

    @Message(id=48, value="Cannot start servers when the Host Controller running mode is %s")
    public String cannotStartServersInvalidMode(RunningMode var1);

    @Message(id=49, value="Close should be managed by the service")
    public UnsupportedOperationException closeShouldBeManagedByService();

    @Message(id=50, value="Configuration persister for domain model is already initialized")
    public IllegalStateException configurationPersisterAlreadyInitialized();

    @Message(id=51, value="Interrupted while trying to connect to master")
    public IllegalStateException connectionToMasterInterrupted();

    @Message(id=52, value="Could not connect to master in %d attempts within %s ms")
    public IllegalStateException connectionToMasterTimeout(@Cause Throwable var1, int var2, long var3);

    @Message(id=53, value="Could not get the server inventory in %d %s")
    public RuntimeException couldNotGetServerInventory(long var1, String var3);

    @Message(id=54, value="Did not read the entire file. Missing: %d")
    public IOException didNotReadEntireFile(long var1);

    @Message(id=55, value="Error closing down host")
    public RuntimeException errorClosingDownHost(@Cause Throwable var1);

    @Message(id=56, value="Failed to retrieve profile operations from domain controller")
    public String failedProfileOperationsRetrieval();

    @Message(id=57, value="Failed to get file from remote repository")
    public RuntimeException failedToGetFileFromRemoteRepository(@Cause Throwable var1);

    @Message(id=58, value="Failed to get server status")
    public String failedToGetServerStatus();

    @Message(id=59, value="Failed to read authentication key: %s")
    public String failedToReadAuthenticationKey(Throwable var1);

    @Message(id=60, value="Already have a connection for host %s")
    public IllegalArgumentException hostNameAlreadyConnected(String var1);

    @Message(id=61, value="Insufficient information to generate hash.")
    public SaslException insufficientInformationToGenerateHash();

    @Message(id=62, value="Invalid option '%s'. %s")
    public String invalidOption(String var1, String var2);

    @Message(id=63, value="Invalid root id [%d]")
    public RequestProcessingException invalidRootId(int var1);

    @Message(id=64, value="Value for %s is not an %s -- %s. %s")
    public String invalidValue(String var1, String var2, Object var3, String var4);

    @Message(id=65, value="Invocations of %s after HostController boot are not allowed")
    public IllegalStateException invocationNotAllowedAfterBoot(String var1);

    public String invocationNotAllowedAfterBoot(ModelNode var1);

    @Message(id=66, value="Malformed URL provided for option %s. %s")
    public String malformedUrl(String var1, String var2);

    @Message(id=67, value="Must call %s before checking for slave status")
    public IllegalStateException mustInvokeBeforeCheckingSlaveStatus(String var1);

    @Message(id=68, value="Must call %s before persisting the domain model")
    public IllegalStateException mustInvokeBeforePersisting(String var1);

    @Message(id=69, value="No channel for host %s")
    public IllegalArgumentException noChannelForHost(String var1);

    @Message(id=70, value="A host connecting to a remote domain controller must have its name attribute set")
    public IllegalArgumentException noNameAttributeOnHost();

    @Message(id=71, value="No server inventory")
    public IllegalStateException noServerInventory();

    @Message(id=72, value="Property %s already exists")
    public IllegalArgumentException propertyAlreadyExists(String var1);

    @Message(id=73, value="Property %s does not exist")
    public IllegalArgumentException propertyNotFound(String var1);

    @Message(id=74, value="Value for property %s is null")
    public IllegalArgumentException propertyValueNull(String var1);

    @Message(id=75, value="Property %s has a null value")
    public IllegalStateException propertyValueHasNullValue(String var1);

    @Message(id=76, value="%s is null")
    public IllegalArgumentException nullVar(String var1);

    @Message(id=77, value="There is already a registered server named '%s'")
    public IllegalArgumentException serverNameAlreadyRegistered(String var1);

    @Message(id=78, value="Server (%s) still running")
    public String serverStillRunning(String var1);

    @Message(id=79, value="Unable to generate hash")
    public SaslException unableToGenerateHash(@Cause Throwable var1);

    @Message(id=80, value="Unable to load properties from URL %s. %s")
    public String unableToLoadProperties(URL var1, String var2);

    @Message(id=81, value="Undefined socket binding group for server %s")
    public IllegalArgumentException undefinedSocketBinding(String var1);

    @Message(id=82, value="Included socket binding group %s is not defined")
    public IllegalStateException undefinedSocketBindingGroup(String var1);

    @Message(id=83, value="Unexpected state %s")
    public IllegalStateException unexpectedState(ServerState var1);

    @Message(id=84, value="Unknown %s %s")
    public IllegalArgumentException unknown(String var1, Object var2);

    @Message(id=85, value="Value for %s is not a known host -- %s. %s")
    public String unknownHostValue(String var1, Object var2, String var3);

    @Message(id=86, value="unrecognized type %s")
    public IOException unrecognizedType(byte var1);

    @Message(id=87, value="Host-Controller is already shutdown.")
    public IllegalStateException hostAlreadyShutdown();

    @Message(id=88, value="No server-group called: %s")
    public OperationFailedException noServerGroupCalled(String var1);

    @Message(id=89, value="No socket-binding-group called: %s")
    public OperationFailedException noSocketBindingGroupCalled(String var1);

    @Message(id=90, value="HostControllerEnvironment does not support system property updates")
    public UnsupportedOperationException hostControllerSystemPropertyUpdateNotSupported();

    @Message(id=91, value="Resources of type %s cannot be ignored")
    public OperationFailedException cannotIgnoreTypeHost(String var1);

    @Message(id=92, value="An '%s' element whose 'type' attribute is '%s' has already been found")
    public XMLStreamException duplicateIgnoredResourceType(String var1, String var2, @Param Location var3);

    @Message(id=93, value="The JVM input arguments cannot be accessed so system properties passed directly to this Host Controller JVM will not be passed through to server processes. Cause of the problem: %s")
    public String cannotAccessJvmInputArgument(Exception var1);

    @Message(id=94, value="Missing configuration value for: %s")
    public IllegalStateException missingHomeDirConfiguration(String var1);

    @Message(id=95, value="Home directory does not exist: %s")
    public IllegalStateException homeDirectoryDoesNotExist(File var1);

    @Message(id=96, value="Determined modules directory does not exist: %s")
    public IllegalStateException modulesDirectoryDoesNotExist(File var1);

    @Message(id=97, value="Domain base directory does not exist: %s")
    public IllegalStateException domainBaseDirectoryDoesNotExist(File var1);

    @Message(id=98, value="Domain base directory is not a directory: %s")
    public IllegalStateException domainBaseDirectoryIsNotADirectory(File var1);

    @Message(id=99, value="Configuration directory does not exist: %s")
    public IllegalStateException configDirectoryDoesNotExist(File var1);

    @Message(id=100, value="Domain data directory is not a directory: %s")
    public IllegalStateException domainDataDirectoryIsNotDirectory(File var1);

    @Message(id=101, value="Could not create domain data directory: %s")
    public IllegalStateException couldNotCreateDomainDataDirectory(File var1);

    @Message(id=102, value="Domain content directory is not a directory: %s")
    public IllegalStateException domainContentDirectoryIsNotDirectory(File var1);

    @Message(id=103, value="Could not create domain content directory: %s")
    public IllegalStateException couldNotCreateDomainContentDirectory(File var1);

    @Message(id=104, value="Log directory is not a directory: %s")
    public IllegalStateException logDirectoryIsNotADirectory(File var1);

    @Message(id=105, value="Could not create log directory: %s")
    public IllegalStateException couldNotCreateLogDirectory(File var1);

    @Message(id=106, value="Servers directory is not a directory: %s")
    public IllegalStateException serversDirectoryIsNotADirectory(File var1);

    @Message(id=107, value="Could not create servers directory: %s")
    public IllegalStateException couldNotCreateServersDirectory(File var1);

    @Message(id=108, value="Domain temp directory does not exist: %s")
    public IllegalStateException domainTempDirectoryIsNotADirectory(File var1);

    @Message(id=109, value="Could not create domain temp directory: %s")
    public IllegalStateException couldNotCreateDomainTempDirectory(File var1);

    @Message(id=110, value="Unable to connect due to SSL failure.")
    public IllegalStateException sslFailureUnableToConnect(@Cause Throwable var1);

    @Message(id=111, value="Option '%s' already exists")
    public IllegalStateException jvmOptionAlreadyExists(String var1);

    @Message(id=112, value="Environment variable '%s' already exists")
    public IllegalStateException envVariableAlreadyExists(String var1);

    @Message(id=113, value="Host controller management version %s.%s is too old, Only %s.%s or higher are supported")
    public OperationFailedException unsupportedManagementVersionForHost(int var1, int var2, int var3, int var4);

    @Message(id=114, value="Failed to add extensions used by the domain. Failure description: %s")
    public IllegalStateException failedToAddExtensions(ModelNode var1);

    @Message(id=115, value="Argument %s has no value. %s")
    public String argumentHasNoValue(String var1, String var2);

    @Message(id=0, value="Use %s --help for information on valid command line arguments and their syntax.")
    public String usageNote(String var1);

    @Message(id=116, value="Cannot access S3 file: %s")
    public IllegalStateException cannotAccessS3File(String var1);

    @Message(id=117, value="Failed to obtain domain controller data from S3 file")
    public IllegalStateException failedMarshallingDomainControllerData();

    @Message(id=118, value="Cannot write domain controller data to S3 file: %s")
    public IOException cannotWriteToS3File(String var1);

    @Message(id=119, value="Cannot access S3 bucket '%s': %s")
    public IllegalStateException cannotAccessS3Bucket(String var1, String var2);

    @Message(id=120, value="Tried all domain controller discovery option(s) but unable to connect")
    public IllegalStateException discoveryOptionsFailureUnableToConnect(@Cause Throwable var1);

    @Message(id=121, value="pre_signed_put_url and pre_signed_delete_url must have the same path")
    public IllegalStateException preSignedUrlsMustHaveSamePath();

    @Message(id=122, value="pre_signed_put_url and pre_signed_delete_url must both be set or both unset")
    public IllegalStateException preSignedUrlsMustBeSetOrUnset();

    @Message(id=123, value="pre-signed url %s must point to a file within a bucket")
    public IllegalStateException preSignedUrlMustPointToFile(String var1);

    @Message(id=124, value="pre-signed url %s is not a valid url")
    public IllegalStateException invalidPreSignedUrl(String var1);

    @Message(id=125, value="pre-signed url %s may only have a subdirectory under a bucket")
    public IllegalStateException invalidPreSignedUrlLength(String var1);

    @Message(id=126, value="Creating location-constrained bucket with unsupported calling-format")
    public IllegalArgumentException creatingBucketWithUnsupportedCallingFormat();

    @Message(id=127, value="Invalid location: %s")
    public IllegalArgumentException invalidS3Location(String var1);

    @Message(id=128, value="Invalid bucket name: %s")
    public IllegalArgumentException invalidS3Bucket(String var1);

    @Message(id=129, value="bucket '%s' could not be accessed (rsp=%d (%s)). Maybe the bucket is owned by somebody else or the authentication failed")
    public IOException bucketAuthenticationFailure(String var1, int var2, String var3);

    @Message(id=130, value="Unexpected response: %s")
    public IOException unexpectedResponse(String var1);

    @Message(id=131, value="HTTP redirect support required")
    public RuntimeException httpRedirectSupportRequired();

    @Message(id=132, value="Unexpected error parsing bucket listing(s)")
    public RuntimeException errorParsingBucketListings(@Cause Throwable var1);

    @Message(id=133, value="Couldn't initialize a SAX driver for the XMLReader")
    public RuntimeException cannotInitializeSaxDriver();

    @Message(id=134, value="Cannot instantiate discovery option class '%s': %s")
    public IllegalStateException cannotInstantiateDiscoveryOptionClass(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=137, value="Could not write domain controller data to S3 file. Error was: %s")
    public void cannotWriteDomainControllerData(Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=138, value="Could not remove S3 file. Error was: %s")
    public void cannotRemoveS3File(Exception var1);

    @Message(id=139, value="Invalid value for %s. Must only contain all of the existing discovery options")
    public OperationFailedException invalidDiscoveryOptionsOrdering(String var1);

    @Message(id=140, value="Can't execute transactional operation '%s' from slave controller")
    public IllegalStateException cannotExecuteTransactionalOperationFromSlave(String var1);

    @Message(id=141, value="There is no resource called %s")
    public OperationFailedException noResourceFor(PathAddress var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=142, value="Failed to apply domain-wide configuration from master host controller")
    public void failedToApplyDomainConfig(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=143, value="Failed to apply domain-wide configuration from master host controller. Operation outcome: %s. Failure description %s")
    public void failedToApplyDomainConfig(String var1, ModelNode var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=144, value="The host cannot start because it was started in running mode '%s' with no access to a local copy of the domain wide configuration policy, the '%s' attribute was set to '%s' and the domain wide configuration policy could not be obtained from the Domain Controller host. Startup will be aborted. Use the '%s' command line argument to start if you need to start without connecting to a domain controller connection.")
    public void fetchConfigFromDomainMasterFailed(RunningMode var1, String var2, AdminOnlyDomainConfigPolicy var3, String var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=145, value="The host cannot start because it was started in running mode '%s' with no access to a local copy of the domain wide configuration policy, and the '%s' attribute was set to '%s'. Startup will be aborted. Use the '%s' command line argument to start in running mode '%s'.")
    public void noAccessControlConfigurationAvailable(RunningMode var1, String var2, AdminOnlyDomainConfigPolicy var3, String var4, RunningMode var5);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=146, value="Could not discover master using discovery option %s. Error was: %s")
    public void failedDiscoveringMaster(DiscoveryOption var1, Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=147, value="No domain controller discovery options remain.")
    public void noDiscoveryOptionsLeft();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=148, value="Connected to master host controller at %s")
    public void connectedToMaster(URI var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=149, value="Option %s was set; obtaining domain-wide configuration from %s")
    public void usingCachedDC(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=150, value="Trying to reconnect to master host controller.")
    public void reconnectingToMaster();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=151, value="No domain controller discovery configuration was provided and the '%s' attribute was set to '%s'. Startup will be aborted. Use the %s command line argument to start in %s mode if you need to start without a domain controller connection and then use the management tools to configure one.")
    public void noDomainControllerConfigurationProvidedForAdminOnly(String var1, AdminOnlyDomainConfigPolicy var2, String var3, RunningMode var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=152, value="Server %s will be started with JVM launch command prefix '%s'")
    public void serverLaunchCommandPrefix(String var1, String var2);

    @Message(id=153, value="Channel closed")
    public IOException channelClosed();

    @Message(id=154, value="For a secure port to be enabled for the HTTP management interface a security realm to supply the SSLContext must be specified.")
    public OperationFailedException noSecurityRealmForSsl();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=155, value="JVM version '%s' unknown, unpredicted behavior may occur")
    public void jvmVersionUnknown(String var1);

    @Message(id=156, value="failed to resolve interface %s")
    public OperationFailedException failedToResolveInterface(String var1);

    @Message(id=157, value="Could not create domain auto-start directory: %s")
    public IllegalStateException couldNotCreateDomainAutoStartDirectory(Path var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=158, value="Error persisting server autostart status")
    public void couldNotPersistAutoStartServerStatus(@Cause Throwable var1);

    @Message(id=159, value="Invalid discovery type %s")
    public String invalidDiscoveryType(String var1);

    @Message(id=160, value="Could not read or create the domain UUID in file: %s")
    public IllegalStateException couldNotObtainDomainUuid(@Cause Throwable var1, Path var2);

    @Message(id=161, value="Model references of type '%s' are missing: %s")
    public OperationFailedException missingReferences(String var1, Set<String> var2);

    @Message(id=162, value="The binding name '%s' in socket binding group '%s' is not unique. Names must be unique across socket-binding, local-destination-outbound-socket-binding and remote-destination-outbound-socket-binding")
    public OperationFailedException bindingNameNotUnique(String var1, String var2);

    @Message(id=163, value="Profile '%s' is involved in a cycle")
    public OperationFailedException profileInvolvedInACycle(String var1);

    @Message(id=164, value="Profile '%s' defines subsystem '%s' which is also defined in its ancestor profile '%s'. Overriding subsystems is not supported")
    public OperationFailedException profileAttemptingToOverrideSubsystem(String var1, String var2, String var3);

    @Message(id=165, value="Socket binding group '%s' is involved in a cycle")
    public OperationFailedException socketBindingGroupInvolvedInACycle(String var1);

    @Message(id=166, value="Socket binding group '%s' defines socket binding '%s' which is also defined in its ancestor socket binding group '%s'. Overriding socket bindings is not supported")
    public OperationFailedException socketBindingGroupAttemptingToOverrideSocketBinding(String var1, String var2, String var3);

    @Message(id=167, value="Profile '%s' includes profile '%s' and profile '%s'. Both these profiles define subsystem '%s', which is not supported")
    public OperationFailedException profileIncludesSameSubsystem(String var1, String var2, String var3, String var4);

    @Message(id=168, value="Socket binding group '%s' includes socket binding group '%s' and socket binding group '%s'. Both these socket binding groups define socket binding '%s', which is not supported")
    public OperationFailedException socketBindingGroupIncludesSameSocketBinding(String var1, String var2, String var3, String var4);

    @Message(id=169, value="Reload into running mode is not supported with embedded host controller, admin-only=true must be specified.")
    public OperationFailedException embeddedHostControllerRestartMustProvideAdminOnlyTrue();

    @Message(id=170, value="Error releasing shared lock after host registration for operationID: %s")
    public String hostRegistrationCannotReleaseSharedLock(int var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=171, value="Failed getting the response from the suspend listener for server: %s")
    public void suspendListenerFailed(@Cause ExecutionException var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=172, value="Failed executing the suspend operation for server: %s")
    public void suspendExecutionFailed(@Cause IOException var1, String var2);

    @Message(id=173, value="It is not possible to use use-current-host-config=false while specifying a host-config")
    public OperationFailedException cannotBothHaveFalseUseCurrentHostConfigAndHostConfig();

    @Message(id=174, value="It is not possible to use use-current-domain-config=false while specifying a domain-config")
    public OperationFailedException cannotBothHaveFalseUseCurrentDomainConfigAndDomainConfig();

    @Message(id=175, value="domain-config '%s' specified for reload could not be found")
    public OperationFailedException domainConfigForReloadNotFound(String var1);

    @Message(id=176, value="The deprecated parameter %s has been set in addition to the current parameter %s but with different values")
    public OperationFailedException deprecatedAndCurrentParameterMismatch(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=177, value="No security realm defined for native management service; all access will be unrestricted.")
    public void nativeManagementInterfaceIsUnsecured();

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=178, value="Aborting with exit code %d")
    public void aborting(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=179, value="ProcessController has signalled to shut down; shutting down")
    public void shuttingDownInResponseToProcessControllerSignal();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=180, value="Shutting down in response to management operation '%s'")
    public void shuttingDownInResponseToManagementRequest(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=181, value="Host Controller shutdown has been requested via an OS signal")
    public void shutdownHookInvoked();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=182, value="Timed out after %d ms awaiting server suspend response(s) for server: %s")
    public void timedOutAwaitingSuspendResponse(int var1, String var2);

    @Message(id=183, value="Timed out after %d ms awaiting server suspend response(s) for server: %s")
    public String timedOutAwaitingSuspendResponseMsg(int var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=184, value="%s interrupted awaiting server suspend response(s)")
    public void interruptedAwaitingSuspendResponse(@Cause InterruptedException var1, String var2);

    @Message(id=185, value="%s interrupted awaiting server suspend response(s)")
    public String interruptedAwaitingSuspendResponseMsg(String var1);

    @Message(id=186, value="Failed executing the suspend operation for server: %s")
    public String suspendExecutionFailedMsg(String var1);

    @Message(id=187, value="Failed getting the response from the suspend listener for server: %s")
    public String suspendListenerFailedMsg(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=188, value="Timed out after %d ms awaiting server resume response(s) for server: %s")
    public void timedOutAwaitingResumeResponse(int var1, String var2);

    @Message(id=189, value="Timed out after %d ms awaiting server resume response(s) for server: %s")
    public String timedOutAwaitingResumeResponseMsg(int var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=190, value="%s interrupted awaiting server resume response(s)")
    public void interruptedAwaitingResumeResponse(@Cause InterruptedException var1, String var2);

    @Message(id=191, value="%s interrupted awaiting server resume response(s)")
    public String interruptedAwaitingResumeResponseMsg(String var1);

    @Message(id=192, value="Failed executing the resume operation for server: %s")
    public String resumeExecutionFailedMsg(String var1);

    @Message(id=193, value="Failed getting the response from the resume listener for server: %s")
    public String resumeListenerFailedMsg(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=194, value="Failed executing the resume operation for server: %s")
    public void resumeExecutionFailed(@Cause IOException var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=195, value="Failed getting the response from the resume listener for server: %s")
    public void resumeListenerFailed(@Cause ExecutionException var1, String var2);
}

