/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLHandshakeException;
import javax.security.sasl.SaslException;
import org.jboss.as.controller.Cancellable;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.client.impl.ExistingChannelModelControllerClient;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.remote.ResponseAttachmentInputStreamSupport;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.remote.TransactionalProtocolHandlers;
import org.jboss.as.controller.remote.TransactionalProtocolOperationHandler;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.SlaveRegistrationException;
import org.jboss.as.domain.controller.operations.FetchMissingConfigurationHandler;
import org.jboss.as.domain.controller.operations.SyncDomainModelOperationHandler;
import org.jboss.as.domain.controller.operations.SyncServerGroupOperationHandler;
import org.jboss.as.domain.controller.operations.coordination.DomainControllerLockIdUtils;
import org.jboss.as.domain.controller.operations.deployment.SyncModelParameters;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.IgnoredNonAffectedServerGroupsUtil;
import org.jboss.as.host.controller.MasterDomainControllerClient;
import org.jboss.as.host.controller.ReconnectPolicy;
import org.jboss.as.host.controller.RemoteDomainConnection;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.ServerInventoryService;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.discovery.RemoteDomainControllerConnectionConfiguration;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.mgmt.DomainRemoteFileRequestAndHandler;
import org.jboss.as.host.controller.mgmt.HostControllerRegistrationHandler;
import org.jboss.as.host.controller.mgmt.HostInfo;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.repository.RemoteFileRequestAndHandler;
import org.jboss.as.version.ProductConfig;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.OptionMap;
import org.xnio.Options;

public class RemoteDomainConnectionService
implements MasterDomainControllerClient,
Service<MasterDomainControllerClient> {
    public static final String DOMAIN_CONNECTION_ID = "domain-connection-id";
    private static final int CONNECTION_TIMEOUT_DEFAULT = 30000;
    private static final String CONNECTION_TIMEOUT_PROPERTY = "jboss.host.domain.connection.timeout";
    private static final int CONNECTION_TIMEOUT = RemoteDomainConnectionService.getSystemProperty("jboss.host.domain.connection.timeout", 30000);
    private static final ModelNode APPLY_DOMAIN_MODEL = new ModelNode();
    private static final Operation GRAB_DOMAIN_RESOURCE;
    private final ExtensionRegistry extensionRegistry;
    private final ModelController controller;
    private final ProductConfig productConfig;
    private final LocalHostControllerInfo localHostInfo;
    private final RemoteFileRepository remoteFileRepository;
    private final ContentRepository contentRepository;
    private final IgnoredDomainResourceRegistry ignoredDomainResourceRegistry;
    private final HostControllerRegistrationHandler.OperationExecutor operationExecutor;
    private final DomainController domainController;
    private final HostControllerEnvironment hostControllerEnvironment;
    private final RunningMode runningMode;
    private final File tempDir;
    private final Map<String, ProxyController> serverProxies;
    private volatile ModelControllerClient masterProxy;
    private volatile TransactionalProtocolClient txMasterProxy;
    private final FutureClient futureClient = new FutureClient();
    private final InjectedValue<Endpoint> endpointInjector = new InjectedValue();
    private final InjectedValue<SecurityRealm> securityRealmInjector = new InjectedValue();
    private final InjectedValue<ServerInventory> serverInventoryInjector = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> scheduledExecutorInjector = new InjectedValue();
    private final ExecutorService executor;
    private final AtomicBoolean domainModelComplete;
    private ManagementChannelHandler handler;
    private volatile ResponseAttachmentInputStreamSupport responseAttachmentSupport;
    private volatile RemoteDomainConnection connection;
    private final RemoteFileRepositoryExecutor remoteFileRepositoryExecutor = new RemoteFileRepositoryExecutor(){

        @Override
        public File getFile(String relativePath, byte repoId, HostFileRepository localFileRepository) {
            if (RemoteDomainConnectionService.this.connection.isConnected()) {
                try {
                    return (File)RemoteDomainConnectionService.this.handler.executeRequest((ManagementRequest)new GetFileRequest(repoId, relativePath, localFileRepository), null).getResult().get();
                }
                catch (Exception e) {
                    throw HostControllerLogger.ROOT_LOGGER.failedToGetFileFromRemoteRepository(e);
                }
            }
            return localFileRepository.getFile(relativePath);
        }
    };

    private RemoteDomainConnectionService(ModelController controller, ExtensionRegistry extensionRegistry, LocalHostControllerInfo localHostControllerInfo, RemoteFileRepository remoteFileRepository, ContentRepository contentRepository, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, HostControllerRegistrationHandler.OperationExecutor operationExecutor, DomainController domainController, HostControllerEnvironment hostControllerEnvironment, ExecutorService executor, RunningMode runningMode, Map<String, ProxyController> serverProxies, AtomicBoolean domainModelComplete) {
        this.controller = controller;
        this.extensionRegistry = extensionRegistry;
        this.productConfig = hostControllerEnvironment.getProductConfig();
        this.localHostInfo = localHostControllerInfo;
        this.remoteFileRepository = remoteFileRepository;
        this.contentRepository = contentRepository;
        remoteFileRepository.setRemoteFileRepositoryExecutor(this.remoteFileRepositoryExecutor);
        this.ignoredDomainResourceRegistry = ignoredDomainResourceRegistry;
        this.operationExecutor = operationExecutor;
        this.domainController = domainController;
        this.hostControllerEnvironment = hostControllerEnvironment;
        this.executor = executor;
        this.runningMode = runningMode;
        this.tempDir = hostControllerEnvironment.getDomainTempDir();
        this.serverProxies = serverProxies;
        this.domainModelComplete = domainModelComplete;
    }

    static Future<MasterDomainControllerClient> install(ServiceTarget serviceTarget, ModelController controller, ExtensionRegistry extensionRegistry, LocalHostControllerInfo localHostControllerInfo, String securityRealm, RemoteFileRepository remoteFileRepository, ContentRepository contentRepository, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, HostControllerRegistrationHandler.OperationExecutor operationExecutor, DomainController domainController, HostControllerEnvironment hostControllerEnvironment, ExecutorService executor, RunningMode currentRunningMode, Map<String, ProxyController> serverProxies, AtomicBoolean domainModelComplete) {
        RemoteDomainConnectionService service = new RemoteDomainConnectionService(controller, extensionRegistry, localHostControllerInfo, remoteFileRepository, contentRepository, ignoredDomainResourceRegistry, operationExecutor, domainController, hostControllerEnvironment, executor, currentRunningMode, serverProxies, domainModelComplete);
        ServiceBuilder builder = serviceTarget.addService(MasterDomainControllerClient.SERVICE_NAME, (Service)service).addDependency(ManagementRemotingServices.MANAGEMENT_ENDPOINT, Endpoint.class, service.endpointInjector).addDependency(ServerInventoryService.SERVICE_NAME, ServerInventory.class, service.serverInventoryInjector).addDependency(HostControllerService.HC_SCHEDULED_EXECUTOR_SERVICE_NAME, ScheduledExecutorService.class, service.scheduledExecutorInjector).setInitialMode(ServiceController.Mode.ACTIVE);
        if (securityRealm != null) {
            SecurityRealm.ServiceUtil.addDependency((ServiceBuilder)builder, service.securityRealmInjector, (String)securityRealm, (boolean)false);
        }
        builder.install();
        return service.futureClient;
    }

    @Override
    public synchronized void register() throws IOException {
        boolean connected = false;
        List<DiscoveryOption> discoveryOptions = this.localHostInfo.getRemoteDomainControllerDiscoveryOptions();
        Iterator<DiscoveryOption> i = discoveryOptions.iterator();
        while (i.hasNext()) {
            DiscoveryOption discoveryOption = i.next();
            long timeout = CONNECTION_TIMEOUT;
            long endTime = System.currentTimeMillis() + timeout;
            int retries = 0;
            URI masterURI = null;
            try {
                List<RemoteDomainControllerConnectionConfiguration> remoteDcConfigs = discoveryOption.discover();
                while (!connected) {
                    IOException ex = null;
                    for (RemoteDomainControllerConnectionConfiguration remoteDcConfig : remoteDcConfigs) {
                        try {
                            masterURI = new URI(remoteDcConfig.getProtocol(), null, remoteDcConfig.getHost(), remoteDcConfig.getPort(), null, null, null);
                            this.connection.setUri(masterURI);
                            this.connection.connect();
                            connected = true;
                            break;
                        }
                        catch (IOException e) {
                            RemoteDomainConnectionService.rethrowIrrecoverableConnectionFailures(e);
                            HostControllerLogger.ROOT_LOGGER.cannotConnect(masterURI, e);
                            if (this.hostControllerEnvironment.isUseCachedDc()) {
                                throw e;
                            }
                            ex = e;
                        }
                    }
                    if (ex == null) continue;
                    if (System.currentTimeMillis() > endTime) {
                        throw HostControllerLogger.ROOT_LOGGER.connectionToMasterTimeout(ex, retries, timeout);
                    }
                    try {
                        ReconnectPolicy.CONNECT.wait(retries);
                        ++retries;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw HostControllerLogger.ROOT_LOGGER.connectionToMasterInterrupted();
                    }
                }
                HostControllerLogger.ROOT_LOGGER.connectedToMaster(masterURI);
                this.setupHandler();
                break;
            }
            catch (Exception e) {
                boolean moreOptions = i.hasNext();
                RemoteDomainConnectionService.logConnectionException(masterURI, discoveryOption, moreOptions, e);
                if (moreOptions) continue;
                throw HostControllerLogger.ROOT_LOGGER.discoveryOptionsFailureUnableToConnect(e);
            }
        }
    }

    @Override
    public synchronized void unregister() {
        StreamUtils.safeClose((Closeable)((Object)this.connection));
    }

    @Override
    public synchronized Cancellable pollForConnect() {
        final Future<Connection> future = this.connection.reconnect();
        this.setupHandler();
        return new Cancellable(){

            public boolean cancel() {
                return future.cancel(true);
            }
        };
    }

    @Override
    public synchronized HostFileRepository getRemoteFileRepository() {
        return this.remoteFileRepository;
    }

    public ModelNode execute(ModelNode operation) throws IOException {
        return this.execute(operation, OperationMessageHandler.logging);
    }

    public ModelNode execute(Operation operation) throws IOException {
        return this.masterProxy.execute(operation, OperationMessageHandler.logging);
    }

    public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
        return this.masterProxy.execute(operation, messageHandler);
    }

    public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        return this.masterProxy.execute(operation, messageHandler);
    }

    public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
        return this.masterProxy.executeAsync(operation, messageHandler);
    }

    public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
        return this.masterProxy.executeAsync(operation, messageHandler);
    }

    public OperationResponse executeOperation(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        return this.masterProxy.executeOperation(operation, messageHandler);
    }

    public AsyncFuture<OperationResponse> executeOperationAsync(Operation operation, OperationMessageHandler messageHandler) {
        return this.masterProxy.executeOperationAsync(operation, messageHandler);
    }

    @Override
    public void fetchAndSyncMissingConfiguration(OperationContext context, final Resource original) throws OperationFailedException {
        final TransactionalProtocolClient client = this.txMasterProxy;
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                TransactionalProtocolClient.PreparedOperation preparedOperation;
                Integer domainControllerLock;
                ModelNode fetchContentOp = new ModelNode();
                fetchContentOp.get("operation").set(FetchMissingConfigurationHandler.OPERATION_NAME);
                fetchContentOp.get("address").setEmptyList();
                PathElement hostElement = PathElement.pathElement((String)"host", (String)RemoteDomainConnectionService.this.localHostInfo.getLocalHostName());
                Resource hostModel = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{hostElement}));
                IgnoredNonAffectedServerGroupsUtil.addServerGroupsToModel(hostModel, fetchContentOp);
                ModelNode ignoredModel = RemoteDomainConnectionService.this.ignoredDomainResourceRegistry.getIgnoredResourcesAsModel();
                if (ignoredModel.hasDefined("ignored-resource-type")) {
                    fetchContentOp.get("ignored-resources").set(ignoredModel.require("ignored-resource-type"));
                }
                if ((domainControllerLock = (Integer)context.getAttachment(DomainControllerLockIdUtils.DOMAIN_CONTROLLER_LOCK_ID_ATTACHMENT)) != null) {
                    fetchContentOp.get(new String[]{"operation-headers", "domain-controller-lock-id"}).set(domainControllerLock.intValue());
                }
                try {
                    preparedOperation = TransactionalProtocolHandlers.executeBlocking((ModelNode)fetchContentOp, (TransactionalProtocolClient)client);
                }
                catch (IOException e) {
                    throw new OperationFailedException((Throwable)e);
                }
                catch (InterruptedException e) {
                    throw ControllerLogger.ROOT_LOGGER.operationCancelledAsynchronously();
                }
                ModelNode result = preparedOperation.getPreparedResult();
                if (preparedOperation.isFailed()) {
                    ModelNode prepared = preparedOperation.getPreparedResult();
                    if (prepared.hasDefined("failure-description")) {
                        throw new OperationFailedException(prepared.get("failure-description").asString());
                    }
                    throw new OperationFailedException(prepared);
                }
                if (result.get("failure-description").isDefined()) {
                    preparedOperation.rollback();
                    throw new OperationFailedException(result.get("failure-description").asString());
                }
                ModelNode syncOperation = new ModelNode();
                syncOperation.get("operation").set("calculate-diff-and-sync");
                syncOperation.get("address").setEmptyList();
                syncOperation.get("domain-model").set(result.get("result"));
                SyncModelParameters parameters = new SyncModelParameters(RemoteDomainConnectionService.this.domainController, RemoteDomainConnectionService.this.ignoredDomainResourceRegistry, RemoteDomainConnectionService.this.hostControllerEnvironment, RemoteDomainConnectionService.this.extensionRegistry, RemoteDomainConnectionService.this.operationExecutor, false, RemoteDomainConnectionService.this.serverProxies, RemoteDomainConnectionService.this.remoteFileRepository, RemoteDomainConnectionService.this.contentRepository);
                SyncServerGroupOperationHandler handler = new SyncServerGroupOperationHandler(RemoteDomainConnectionService.this.localHostInfo.getLocalHostName(), original, parameters);
                context.addStep(syncOperation, (OperationStepHandler)handler, OperationContext.Stage.MODEL, true);
                context.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        if (resultAction == OperationContext.ResultAction.KEEP) {
                            preparedOperation.commit();
                        } else {
                            preparedOperation.rollback();
                        }
                    }
                });
            }
        }, OperationContext.Stage.MODEL, true);
    }

    public void close() throws IOException {
        throw HostControllerLogger.ROOT_LOGGER.closeShouldBeManagedByService();
    }

    public synchronized void start(StartContext context) throws StartException {
        ManagementChannelHandler handler;
        RemoteDomainConnection connection;
        try {
            ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)this.scheduledExecutorInjector.getValue();
            this.responseAttachmentSupport = new ResponseAttachmentInputStreamSupport(scheduledExecutorService);
            OptionMap options = OptionMap.builder().set(RemotingOptions.HEARTBEAT_INTERVAL, 15000).set(Options.READ_TIMEOUT, 45000).getMap();
            ProtocolConnectionConfiguration configuration = ProtocolConnectionConfiguration.create((Endpoint)((Endpoint)this.endpointInjector.getValue()), (OptionMap)options);
            SecurityRealm realm = (SecurityRealm)this.securityRealmInjector.getOptionalValue();
            connection = new RemoteDomainConnection(this.localHostInfo.getLocalHostName(), configuration, realm, this.localHostInfo.getRemoteDomainControllerUsername(), this.localHostInfo.getRemoteDomainControllerDiscoveryOptions(), this.executor, scheduledExecutorService, new RemoteDomainConnection.HostRegistrationCallback(){

                @Override
                public ModelNode createLocalHostInfo() {
                    return HostInfo.createLocalHostHostInfo(RemoteDomainConnectionService.this.localHostInfo, RemoteDomainConnectionService.this.productConfig, RemoteDomainConnectionService.this.ignoredDomainResourceRegistry, (Resource)ReadRootResourceHandler.grabDomainResource(RemoteDomainConnectionService.this.operationExecutor).getChildren("host").iterator().next());
                }

                @Override
                public ModelNode resolveSubsystemVersions(ModelNode extensions) {
                    return RemoteDomainConnectionService.this.resolveSubsystems(extensions.asList());
                }

                @Override
                public boolean applyDomainModel(List<ModelNode> bootOperations) {
                    HostInfo info = HostInfo.fromModelNode(this.createLocalHostInfo());
                    return RemoteDomainConnectionService.this.applyRemoteDomainModel(bootOperations, info);
                }

                @Override
                public void registrationComplete(ManagementChannelHandler handler) {
                    RemoteDomainConnectionService.this.domainModelComplete.set(true);
                }
            }, this.runningMode);
            handler = connection.getChannelHandler();
            handler.getAttachments().attach(ManagementChannelHandler.TEMP_DIR, (Object)this.tempDir);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        finally {
            this.futureClient.setClient(this);
        }
        this.connection = connection;
        this.handler = handler;
    }

    private ModelNode resolveSubsystems(List<ModelNode> extensions) {
        HostControllerLogger.ROOT_LOGGER.debug("Applying extensions provided by master");
        ModelNode result = this.operationExecutor.installSlaveExtensions(extensions);
        if (!"success".equals(result.get("outcome").asString())) {
            throw HostControllerLogger.ROOT_LOGGER.failedToAddExtensions(result.get("failure-description"));
        }
        ModelNode subsystems = new ModelNode();
        for (ModelNode extension : extensions) {
            this.extensionRegistry.recordSubsystemVersions(extension.asString(), subsystems);
        }
        return subsystems;
    }

    private boolean applyRemoteDomainModel(List<ModelNode> bootOperations, HostInfo hostInfo) {
        try {
            HostControllerLogger.ROOT_LOGGER.debug("Applying domain level boot operations provided by master");
            SyncModelParameters parameters = new SyncModelParameters(this.domainController, this.ignoredDomainResourceRegistry, this.hostControllerEnvironment, this.extensionRegistry, this.operationExecutor, true, this.serverProxies, this.remoteFileRepository, this.contentRepository);
            SyncDomainModelOperationHandler handler = new SyncDomainModelOperationHandler(hostInfo, parameters);
            ModelNode operation = APPLY_DOMAIN_MODEL.clone();
            operation.get("domain-model").set(bootOperations);
            ModelNode result = this.operationExecutor.execute(OperationBuilder.create((ModelNode)operation).build(), OperationMessageHandler.DISCARD, ModelController.OperationTransactionControl.COMMIT, handler);
            String outcome = result.get("outcome").asString();
            boolean success = "success".equals(outcome);
            if (!success) {
                ModelNode failureDesc = result.hasDefined("failure-description") ? result.get("failure-description") : new ModelNode();
                HostControllerLogger.ROOT_LOGGER.failedToApplyDomainConfig(outcome, failureDesc);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            HostControllerLogger.ROOT_LOGGER.failedToApplyDomainConfig(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(final StopContext context) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    StreamUtils.safeClose((Closeable)((Object)RemoteDomainConnectionService.this.connection));
                    RemoteDomainConnectionService.this.responseAttachmentSupport.shutdown();
                }
                finally {
                    context.complete();
                }
            }
        };
        try {
            this.executor.execute(r);
        }
        catch (RejectedExecutionException e) {
            r.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public synchronized MasterDomainControllerClient getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    static void rethrowIrrecoverableConnectionFailures(IOException e) throws SlaveRegistrationException {
        Throwable cause = e;
        while ((cause = cause.getCause()) != null) {
            if (cause instanceof SaslException) {
                throw HostControllerLogger.ROOT_LOGGER.authenticationFailureUnableToConnect(cause);
            }
            if (cause instanceof SSLHandshakeException) {
                throw HostControllerLogger.ROOT_LOGGER.sslFailureUnableToConnect(cause);
            }
            if (!(cause instanceof SlaveRegistrationException)) continue;
            throw (SlaveRegistrationException)cause;
        }
    }

    static void logConnectionException(URI uri, DiscoveryOption discoveryOption, boolean moreOptions, Exception e) {
        if (uri == null) {
            HostControllerLogger.ROOT_LOGGER.failedDiscoveringMaster(discoveryOption, e);
        } else {
            HostControllerLogger.ROOT_LOGGER.cannotConnect(uri, e);
        }
        if (!moreOptions) {
            HostControllerLogger.ROOT_LOGGER.noDiscoveryOptionsLeft();
        }
    }

    private void setupHandler() {
        this.handler.addHandlerFactory((ManagementRequestHandlerFactory)new TransactionalProtocolOperationHandler(this.controller, (ManagementChannelAssociation)this.handler, this.responseAttachmentSupport));
        this.masterProxy = ExistingChannelModelControllerClient.createAndAdd((ManagementChannelHandler)this.handler);
        this.txMasterProxy = TransactionalProtocolHandlers.createClient((ManagementChannelHandler)this.handler);
    }

    private static int getSystemProperty(String name, int defaultValue) {
        String value = WildFlySecurityManager.getPropertyPrivileged((String)name, null);
        try {
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    static {
        APPLY_DOMAIN_MODEL.get("operation").set("apply-remote-domain-model");
        APPLY_DOMAIN_MODEL.get(new String[]{"operation-headers", "execute-for-coordinator"}).set(true);
        APPLY_DOMAIN_MODEL.get("address").setEmptyList();
        APPLY_DOMAIN_MODEL.protect();
        ModelNode mn = new ModelNode();
        mn.get("operation").set("grab-domain-resource");
        mn.get("address").setEmptyList();
        mn.protect();
        GRAB_DOMAIN_RESOURCE = OperationBuilder.create((ModelNode)mn).build();
    }

    private static class ReadRootResourceHandler
    implements OperationStepHandler {
        private Resource resource;

        private ReadRootResourceHandler() {
        }

        static Resource grabDomainResource(HostControllerRegistrationHandler.OperationExecutor executor) {
            ReadRootResourceHandler handler = new ReadRootResourceHandler();
            executor.execute(GRAB_DOMAIN_RESOURCE, OperationMessageHandler.DISCARD, ModelController.OperationTransactionControl.COMMIT, handler);
            return handler.resource;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            this.resource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
        }
    }

    private class FutureClient
    extends AsyncFutureTask<MasterDomainControllerClient> {
        protected FutureClient() {
            super(null);
        }

        private void setClient(MasterDomainControllerClient client) {
            super.setResult((Object)client);
        }
    }

    static interface RemoteFileRepositoryExecutor {
        public File getFile(String var1, byte var2, HostFileRepository var3);
    }

    static class RemoteFileRepository
    implements HostFileRepository {
        private final HostFileRepository localFileRepository;
        private volatile RemoteFileRepositoryExecutor remoteFileRepositoryExecutor;

        RemoteFileRepository(HostFileRepository localFileRepository) {
            this.localFileRepository = localFileRepository;
        }

        public final File getFile(String relativePath) {
            return this.getFile(relativePath, (byte)38);
        }

        public final File getConfigurationFile(String relativePath) {
            return this.getFile(relativePath, (byte)39);
        }

        public final File[] getDeploymentFiles(ContentReference reference) {
            File root = this.getDeploymentRoot(reference);
            return root.listFiles();
        }

        public File getDeploymentRoot(ContentReference reference) {
            File file = this.localFileRepository.getDeploymentRoot(reference);
            if (!file.exists()) {
                return this.getFile(reference.getHexHash(), (byte)40);
            }
            return file;
        }

        private File getFile(String relativePath, byte repoId) {
            return this.remoteFileRepositoryExecutor.getFile(relativePath, repoId, this.localFileRepository);
        }

        void setRemoteFileRepositoryExecutor(RemoteFileRepositoryExecutor remoteFileRepositoryExecutor) {
            this.remoteFileRepositoryExecutor = remoteFileRepositoryExecutor;
        }

        public void deleteDeployment(ContentReference reference) {
            this.localFileRepository.deleteDeployment(reference);
        }
    }

    private class GetFileRequest
    extends AbstractManagementRequest<File, Void> {
        private final byte rootId;
        private final String filePath;
        private final HostFileRepository localFileRepository;

        private GetFileRequest(byte rootId, String filePath, HostFileRepository localFileRepository) {
            this.rootId = rootId;
            this.filePath = filePath;
            this.localFileRepository = localFileRepository;
        }

        public byte getOperationType() {
            return 85;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<File> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
            output.write(32);
            output.writeUTF(RemoteDomainConnectionService.this.localHostInfo.getLocalHostName());
            DomainRemoteFileRequestAndHandler.INSTANCE.sendRequest(output, this.rootId, this.filePath);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<File> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            File localPath;
            switch (this.rootId) {
                case 38: {
                    localPath = this.localFileRepository.getFile(this.filePath);
                    break;
                }
                case 39: {
                    localPath = this.localFileRepository.getConfigurationFile(this.filePath);
                    break;
                }
                case 40: {
                    byte[] hash = HashUtil.hexStringToByteArray((String)this.filePath);
                    localPath = this.localFileRepository.getDeploymentRoot(new ContentReference(this.filePath, hash));
                    break;
                }
                default: {
                    localPath = null;
                }
            }
            try {
                DomainRemoteFileRequestAndHandler.INSTANCE.handleResponse(input, localPath, HostControllerLogger.ROOT_LOGGER, resultHandler, context);
            }
            catch (RemoteFileRequestAndHandler.CannotCreateLocalDirectoryException e) {
                throw HostControllerLogger.ROOT_LOGGER.cannotCreateLocalDirectory(e.getDir());
            }
            catch (RemoteFileRequestAndHandler.DidNotReadEntireFileException e) {
                throw HostControllerLogger.ROOT_LOGGER.didNotReadEntireFile(e.getMissing());
            }
        }
    }
}

