/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import java.security.PrivilegedAction;
import java.util.List;
import javax.security.auth.Subject;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.BlockingTimeout;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.remote.BlockingQueueOperationListener;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.plan.ServerTaskExecutor;
import org.jboss.as.domain.controller.plan.ServerUpdatePolicy;
import org.jboss.as.domain.controller.plan.ServerUpdateTask;
import org.jboss.dmr.ModelNode;

abstract class AbstractServerGroupRolloutTask
implements Runnable {
    protected final List<ServerUpdateTask> tasks;
    protected final ServerUpdatePolicy updatePolicy;
    protected final ServerTaskExecutor executor;
    protected final Subject subject;
    protected final BlockingTimeout blockingTimeout;

    public AbstractServerGroupRolloutTask(List<ServerUpdateTask> tasks, ServerUpdatePolicy updatePolicy, ServerTaskExecutor executor, Subject subject, BlockingTimeout blockingTimeout) {
        this.tasks = tasks;
        this.updatePolicy = updatePolicy;
        this.executor = executor;
        this.subject = subject;
        this.blockingTimeout = blockingTimeout;
    }

    @Override
    public void run() {
        try {
            AccessAuditContext.doAs(null, null, (PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    AbstractServerGroupRolloutTask.this.execute();
                    return null;
                }
            });
        }
        catch (Throwable t) {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.debugf(t, "failed to process task %s", this.tasks.iterator().next().getOperation());
        }
    }

    protected abstract void execute();

    protected void recordPreparedOperation(ServerIdentity identity, TransactionalProtocolClient.PreparedOperation<ServerTaskExecutor.ServerOperation> prepared) {
        ModelNode preparedResult = prepared.getPreparedResult();
        this.updatePolicy.recordServerResult(identity, preparedResult);
        this.executor.recordPreparedOperation(prepared);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{server-group=" + this.updatePolicy.getServerGroupName() + "}";
    }

    void handlePreparePhaseTimeout(ServerIdentity identity, ServerUpdateTask task, long timeout) {
        this.blockingTimeout.proxyTimeoutDetected(identity.toPathAddress());
        ServerTaskExecutor.ServerOperation serverOperation = new ServerTaskExecutor.ServerOperation(identity, task.getOperation(), null, null, OperationResultTransformer.ORIGINAL_RESULT);
        String failureMsg = ControllerLogger.ROOT_LOGGER.proxiedOperationTimedOut(task.getOperation().get("operation").asString(), identity.toPathAddress(), timeout);
        ModelNode failureNode = new ModelNode();
        failureNode.get("outcome").set("failed");
        failureNode.get("failure-description").set(failureMsg);
        BlockingQueueOperationListener.FailedOperation prepared = new BlockingQueueOperationListener.FailedOperation((TransactionalProtocolClient.Operation)serverOperation, failureNode, true);
        ModelNode preparedResult = prepared.getPreparedResult();
        this.updatePolicy.recordServerResult(identity, preparedResult);
        this.executor.recordOperationPrepareTimeout((BlockingQueueOperationListener.FailedOperation<ServerTaskExecutor.ServerOperation>)prepared);
    }
}

