/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.logging;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleLoadException;

public class DomainControllerLogger_$logger
extends DelegatingBasicLogger
implements DomainControllerLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = DomainControllerLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public DomainControllerLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void warnIgnoringSocketBindingGroupInclude(Location location) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnIgnoringSocketBindingGroupInclude$str(), (Object)location);
    }

    protected String warnIgnoringSocketBindingGroupInclude$str() {
        return "WFLYDC0001: Ignoring 'include' child of 'socket-binding-group' %s";
    }

    @Override
    public final void interruptedAwaitingFinalResponse(String serverName, String hostName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.interruptedAwaitingFinalResponse2$str(), (Object)serverName, (Object)hostName);
    }

    protected String interruptedAwaitingFinalResponse2$str() {
        return "WFLYDC0003: Interrupted awaiting final response from server %s on host %s; remote process has been notified to cancel operation";
    }

    @Override
    public final void caughtExceptionAwaitingFinalResponse(Throwable cause, String serverName, String hostName) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.caughtExceptionAwaitingFinalResponse2$str(), (Object)serverName, (Object)hostName);
    }

    protected String caughtExceptionAwaitingFinalResponse2$str() {
        return "WFLYDC0004: Caught exception awaiting final response from server %s on host %s";
    }

    @Override
    public final void interruptedAwaitingFinalResponse(String hostName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.interruptedAwaitingFinalResponse1$str(), (Object)hostName);
    }

    protected String interruptedAwaitingFinalResponse1$str() {
        return "WFLYDC0005: Interrupted awaiting final response from host %s; remote process has been notified to cancel operation";
    }

    @Override
    public final void caughtExceptionAwaitingFinalResponse(Throwable cause, String hostName) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.caughtExceptionAwaitingFinalResponse1$str(), (Object)hostName);
    }

    protected String caughtExceptionAwaitingFinalResponse1$str() {
        return "WFLYDC0006: Caught exception awaiting final response from host %s";
    }

    @Override
    public final void caughtExceptionClosingInputStream(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.caughtExceptionClosingInputStream$str(), new Object[0]);
    }

    protected String caughtExceptionClosingInputStream$str() {
        return "WFLYDC0007: Caught exception closing input stream";
    }

    @Override
    public final void domainModelChangedOnReConnect(Set<ServerIdentity> servers) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.domainModelChangedOnReConnect$str(), servers);
    }

    protected String domainModelChangedOnReConnect$str() {
        return "WFLYDC0008: Domain model has changed on re-connect. The following servers will need to be restarted for changes to take affect: %s";
    }

    @Override
    public final void caughtExceptionWaitingForTask(String className, String exceptionName, String task) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.caughtExceptionWaitingForTask$str(), (Object)className, (Object)exceptionName, (Object)task);
    }

    protected String caughtExceptionWaitingForTask$str() {
        return "WFLYDC0009: %s caught %s waiting for task %s. Cancelling task";
    }

    @Override
    public final void reportAdminOnlyMissingDeploymentContent(String contentHash, String deploymentName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.reportAdminOnlyMissingDeploymentContent$str(), (Object)contentHash, (Object)deploymentName);
    }

    protected String reportAdminOnlyMissingDeploymentContent$str() {
        return "WFLYDC0011: No deployment content with hash %s is available in the deployment content repository for deployment %s. Because this Host Controller is booting in ADMIN-ONLY mode, boot will be allowed to proceed to provide administrators an opportunity to correct this problem. If this Host Controller were not in ADMIN-ONLY mode this would be a fatal boot failure.";
    }

    @Override
    public final void failedToSetServerInRestartRequireState(String serverName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedToSetServerInRestartRequireState$str(), (Object)serverName);
    }

    protected String failedToSetServerInRestartRequireState$str() {
        return "WFLYDC0012: failed to set server (%s) into a restart required state";
    }

    protected String slaveControllerCannotAcceptOtherSlaves$str() {
        return "WFLYDC0013: Registration of remote hosts is not supported on secondary host controllers";
    }

    @Override
    public final String slaveControllerCannotAcceptOtherSlaves() {
        return String.format(this.getLoggingLocale(), this.slaveControllerCannotAcceptOtherSlaves$str(), new Object[0]);
    }

    protected String adminOnlyModeCannotAcceptSlaves$str() {
        return "WFLYDC0014: The primary host controller cannot register secondary host controllers as its current running mode is '%s'";
    }

    @Override
    public final String adminOnlyModeCannotAcceptSlaves(RunningMode runningMode) {
        return String.format(this.getLoggingLocale(), this.adminOnlyModeCannotAcceptSlaves$str(), runningMode);
    }

    protected String slaveAlreadyRegistered$str() {
        return "WFLYDC0015: There is already a registered host named '%s'";
    }

    @Override
    public final String slaveAlreadyRegistered(String secondaryName) {
        return String.format(this.getLoggingLocale(), this.slaveAlreadyRegistered$str(), secondaryName);
    }

    protected String requiredChildIsMissing$str() {
        return "WFLYDC0016: %s is missing %s: %s";
    }

    @Override
    public final String requiredChildIsMissing(String parent, String child, String parentSpec) {
        return String.format(this.getLoggingLocale(), this.requiredChildIsMissing$str(), parent, child, parentSpec);
    }

    protected String unrecognizedChildren$str() {
        return "WFLYDC0017: %s recognizes only %s as children: %s";
    }

    @Override
    public final String unrecognizedChildren(String parent, String children, String parentSpec) {
        return String.format(this.getLoggingLocale(), this.unrecognizedChildren$str(), parent, children, parentSpec);
    }

    protected String inSeriesIsMissingGroups$str() {
        return "WFLYDC0018: in-series is missing groups: %s";
    }

    @Override
    public final String inSeriesIsMissingGroups(String rolloutPlan) {
        return String.format(this.getLoggingLocale(), this.inSeriesIsMissingGroups$str(), rolloutPlan);
    }

    protected String serverGroupExpectsSingleChild$str() {
        return "WFLYDC0019: server-group expects one and only one child: %s";
    }

    @Override
    public final String serverGroupExpectsSingleChild(String rolloutPlan) {
        return String.format(this.getLoggingLocale(), this.serverGroupExpectsSingleChild$str(), rolloutPlan);
    }

    protected String unexpectedInSeriesGroup$str() {
        return "WFLYDC0020: One of the groups does not define neither server-group nor concurrent-groups: %s";
    }

    @Override
    public final String unexpectedInSeriesGroup(String rolloutPlan) {
        return String.format(this.getLoggingLocale(), this.unexpectedInSeriesGroup$str(), rolloutPlan);
    }

    protected String unexplainedFailure$str() {
        return "WFLYDC0021: Unexplained failure";
    }

    @Override
    public final String unexplainedFailure() {
        return String.format(this.getLoggingLocale(), this.unexplainedFailure$str(), new Object[0]);
    }

    protected String operationFailedOrRolledBack$str() {
        return "WFLYDC0022: Operation failed or was rolled back on all servers.";
    }

    @Override
    public final String operationFailedOrRolledBack() {
        return String.format(this.getLoggingLocale(), this.operationFailedOrRolledBack$str(), new Object[0]);
    }

    protected String interruptedAwaitingResultFromServer$str() {
        return "WFLYDC0023: Interrupted waiting for result from server %s";
    }

    @Override
    public final String interruptedAwaitingResultFromServer(ServerIdentity server) {
        return String.format(this.getLoggingLocale(), this.interruptedAwaitingResultFromServer$str(), server);
    }

    protected String exceptionAwaitingResultFromServer$str() {
        return "WFLYDC0024: Exception getting result from server %s: %s";
    }

    @Override
    public final String exceptionAwaitingResultFromServer(ServerIdentity server, String message) {
        return String.format(this.getLoggingLocale(), this.exceptionAwaitingResultFromServer$str(), server, message);
    }

    protected String invalidRolloutPlan2$str() {
        return "WFLYDC0025: Invalid rollout plan. %s is not a valid child of node %s";
    }

    @Override
    public final String invalidRolloutPlan(ModelNode modelNode, String nodeName) {
        return String.format(this.getLoggingLocale(), this.invalidRolloutPlan2$str(), modelNode, nodeName);
    }

    protected String invalidRolloutPlan1$str() {
        return "WFLYDC0026: Invalid rollout plan. Plan operations affect server groups %s that are not reflected in the rollout plan";
    }

    @Override
    public final String invalidRolloutPlan(Set<String> groups) {
        return String.format(this.getLoggingLocale(), this.invalidRolloutPlan1$str(), groups);
    }

    protected String invalidRolloutPlanGroupAlreadyExists$str() {
        return "WFLYDC0027: Invalid rollout plan. Server group %s appears more than once in the plan.";
    }

    @Override
    public final String invalidRolloutPlanGroupAlreadyExists(String group) {
        return String.format(this.getLoggingLocale(), this.invalidRolloutPlanGroupAlreadyExists$str(), group);
    }

    protected String invalidRolloutPlanRange$str() {
        return "WFLYDC0028: Invalid rollout plan. Server group %s has a %s value of %s; must be between 0 and 100.";
    }

    @Override
    public final String invalidRolloutPlanRange(String name, String propertyName, int value) {
        return String.format(this.getLoggingLocale(), this.invalidRolloutPlanRange$str(), name, propertyName, value);
    }

    protected String invalidRolloutPlanLess$str() {
        return "WFLYDC0029: Invalid rollout plan. Server group %s has a %s value of %s; cannot be less than 0.";
    }

    @Override
    public final String invalidRolloutPlanLess(String name, String propertyName, int value) {
        return String.format(this.getLoggingLocale(), this.invalidRolloutPlanLess$str(), name, propertyName, value);
    }

    protected String interruptedAwaitingResultFromHost$str() {
        return "WFLYDC0030: Interrupted waiting for result from host %s";
    }

    @Override
    public final String interruptedAwaitingResultFromHost(String name) {
        return String.format(this.getLoggingLocale(), this.interruptedAwaitingResultFromHost$str(), name);
    }

    protected String masterDomainControllerOnlyOperation$str() {
        return "WFLYDC0032: Operation %s for address %s can only be handled by the Domain Controller; this host is not the Domain Controller";
    }

    @Override
    public final String masterDomainControllerOnlyOperation(String operation, PathAddress address) {
        return String.format(this.getLoggingLocale(), this.masterDomainControllerOnlyOperation$str(), operation, address);
    }

    protected String invalidOperationTargetHost$str() {
        return "WFLYDC0033: Operation targets host %s but that host is not registered";
    }

    @Override
    public final OperationFailedException invalidOperationTargetHost(String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidOperationTargetHost$str(), name));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String caughtExceptionStoringDeploymentContent$str() {
        return "WFLYDC0034: Caught %s storing deployment content -- %s";
    }

    @Override
    public final OperationFailedException caughtExceptionStoringDeploymentContent(String exceptionName, Throwable exception) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.caughtExceptionStoringDeploymentContent$str(), exceptionName, exception));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedInitialPathKey$str() {
        return "WFLYDC0035: Unexpected initial path key %s";
    }

    @Override
    public final IllegalStateException unexpectedInitialPathKey(String key) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unexpectedInitialPathKey$str(), key));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullStream$str() {
        return "WFLYDC0036: Null stream at index %d";
    }

    @Override
    public final String nullStream(int index) {
        return String.format(this.getLoggingLocale(), this.nullStream$str(), index);
    }

    protected String invalidByteStream$str() {
        return "WFLYDC0037: Invalid byte stream.";
    }

    @Override
    public final String invalidByteStream() {
        return String.format(this.getLoggingLocale(), this.invalidByteStream$str(), new Object[0]);
    }

    protected String invalidUrlStream$str() {
        return "WFLYDC0038: Invalid url stream.";
    }

    @Override
    public final String invalidUrlStream() {
        return String.format(this.getLoggingLocale(), this.invalidUrlStream$str(), new Object[0]);
    }

    protected String as7431$str() {
        return "WFLYDC0039: Only 1 piece of content is currently supported (AS7-431)";
    }

    @Override
    public final String as7431() {
        return String.format(this.getLoggingLocale(), this.as7431$str(), new Object[0]);
    }

    protected String noDeploymentContentWithHash$str() {
        return "WFLYDC0040: No deployment content with hash %s is available in the deployment content repository.";
    }

    @Override
    public final String noDeploymentContentWithHash(String hash) {
        return String.format(this.getLoggingLocale(), this.noDeploymentContentWithHash$str(), hash);
    }

    protected String slaveCannotAcceptUploads$str() {
        return "WFLYDC0041: A secondary Host Controller cannot accept deployment content uploads";
    }

    @Override
    public final String slaveCannotAcceptUploads() {
        return String.format(this.getLoggingLocale(), this.slaveCannotAcceptUploads$str(), new Object[0]);
    }

    protected String noDeploymentContentWithName$str() {
        return "WFLYDC0042: No deployment with name %s found";
    }

    @Override
    public final String noDeploymentContentWithName(String name) {
        return String.format(this.getLoggingLocale(), this.noDeploymentContentWithName$str(), name);
    }

    protected String cannotRemoveDeploymentInUse$str() {
        return "WFLYDC0043: Cannot remove deployment %s from the domain as it is still used by server groups %s";
    }

    @Override
    public final String cannotRemoveDeploymentInUse(String name, List<String> groups) {
        return String.format(this.getLoggingLocale(), this.cannotRemoveDeploymentInUse$str(), name, groups);
    }

    protected String invalidValue$str() {
        return "WFLYDC0044: Invalid '%s' value: %d, the maximum index is %d";
    }

    @Override
    public final String invalidValue(String name, int value, int maxIndex) {
        return String.format(this.getLoggingLocale(), this.invalidValue$str(), name, value, maxIndex);
    }

    protected String invalidUrl$str() {
        return "WFLYDC0045: %s is not a valid URL -- %s";
    }

    @Override
    public final String invalidUrl(String url, String message) {
        return String.format(this.getLoggingLocale(), this.invalidUrl$str(), url, message);
    }

    protected String errorObtainingUrlStream$str() {
        return "WFLYDC0046: Error obtaining input stream from URL %s -- %s";
    }

    @Override
    public final String errorObtainingUrlStream(String url, String message) {
        return String.format(this.getLoggingLocale(), this.errorObtainingUrlStream$str(), url, message);
    }

    protected String invalidContentDeclaration$str() {
        return "WFLYDC0047: Invalid content declaration";
    }

    @Override
    public final String invalidContentDeclaration() {
        return String.format(this.getLoggingLocale(), this.invalidContentDeclaration$str(), new Object[0]);
    }

    protected String cannotUseSameValueForParameters$str() {
        return "WFLYDC0049: Cannot use %s with the same value for parameters %s and %s. Use %s to redeploy the same content or %s to replace content with a new version with the same name.";
    }

    @Override
    public final String cannotUseSameValueForParameters(String opName, String param1, String param2, String redeployOpName, String replaceOpName) {
        return String.format(this.getLoggingLocale(), this.cannotUseSameValueForParameters$str(), opName, param1, param2, redeployOpName, replaceOpName);
    }

    protected String deploymentAlreadyStarted$str() {
        return "WFLYDC0050: Deployment %s is already started";
    }

    @Override
    public final String deploymentAlreadyStarted(String name) {
        return String.format(this.getLoggingLocale(), this.deploymentAlreadyStarted$str(), name);
    }

    protected String unknown$str() {
        return "WFLYDC0051: Unknown %s %s";
    }

    @Override
    public final String unknown(String name, String value) {
        return String.format(this.getLoggingLocale(), this.unknown$str(), name, value);
    }

    protected String unknownServerGroup$str() {
        return "WFLYDC0052: Unknown server group %s";
    }

    @Override
    public final IllegalStateException unknownServerGroup(String serverGroup) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownServerGroup$str(), serverGroup));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownServer$str() {
        return "WFLYDC0053: Unknown server %s";
    }

    @Override
    public final IllegalStateException unknownServer(ServerIdentity server) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownServer$str(), server));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCode$str() {
        return "WFLYDC0054: Invalid code %d";
    }

    @Override
    public final IllegalArgumentException invalidCode(int code) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidCode$str(), code));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String deploymentHashNotFoundInRepository$str() {
        return "WFLYDC0055: Repository does not contain any deployment with hash %s";
    }

    @Override
    public final IllegalStateException deploymentHashNotFoundInRepository(String hash) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.deploymentHashNotFoundInRepository$str(), hash));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String expectedOnlyOneDeployment$str() {
        return "WFLYDC0056: Expected only one deployment, found %d";
    }

    @Override
    public final IllegalStateException expectedOnlyOneDeployment(int i) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.expectedOnlyOneDeployment$str(), i));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noProfileCalled$str() {
        return "WFLYDC0057: No profile called: %s";
    }

    @Override
    public final OperationFailedException noProfileCalled(String profile) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noProfileCalled$str(), profile));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDeploymentContentWithHashAtBoot$str() {
        return "WFLYDC0058: No deployment content with hash %s is available in the deployment content repository for deployment '%s'. This is a fatal boot error. To correct the problem, either restart with the --admin-only switch set and use the CLI to install the missing content or remove it from the configuration, or remove the deployment from the xml configuraiton file and restart.";
    }

    @Override
    public final String noDeploymentContentWithHashAtBoot(String contentHash, String deploymentName) {
        return String.format(this.getLoggingLocale(), this.noDeploymentContentWithHashAtBoot$str(), contentHash, deploymentName);
    }

    protected String failedToLoadModule$str() {
        return "WFLYDC0059: Failed to load module '%s'.";
    }

    @Override
    public final OperationFailedException failedToLoadModule(ModuleLoadException e, String module) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.failedToLoadModule$str(), module), (Throwable)e);
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidJSFSlotValue$str() {
        return "WFLYDC0060: Invalid Jakarta Server Faces slot value: '%s'. The host controller is not able to use a Jakarta Server Faces slot value different from its default. This resource will be ignored on that host";
    }

    @Override
    public final String invalidJSFSlotValue(String slot) {
        return String.format(this.getLoggingLocale(), this.invalidJSFSlotValue$str(), slot);
    }

    protected String unknownAttributesFromSubsystemVersion$str() {
        return "WFLYDC0061: Operation '%s' fails because the attributes are not known from the subsytem '%s' model version '%s': %s";
    }

    @Override
    public final String unknownAttributesFromSubsystemVersion(String operationName, String subsystemName, ModelVersion version, Collection<String> attributes) {
        return String.format(this.getLoggingLocale(), this.unknownAttributesFromSubsystemVersion$str(), operationName, subsystemName, version, attributes);
    }

    protected String noSocketBindingGroupCalled$str() {
        return "WFLYDC0062: No socket-binding-group named: %s";
    }

    @Override
    public final OperationFailedException noSocketBindingGroupCalled(String socketBindingGroup) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noSocketBindingGroupCalled$str(), socketBindingGroup));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String runtimeNameMustBeUnique$str() {
        return "WFLYDC0063: There is already a deployment called %s with the same runtime name %s on server group %s";
    }

    @Override
    public final OperationFailedException runtimeNameMustBeUnique(String existingDeployment, String runtimeName, String serverGroup) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.runtimeNameMustBeUnique$str(), existingDeployment, runtimeName, serverGroup));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRemoveUsedServerGroup$str() {
        return "WFLYDC0064: Cannot remove server-group '%s' since it's still in use by servers %s";
    }

    @Override
    public final OperationFailedException cannotRemoveUsedServerGroup(String group, Set<String> servers) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotRemoveUsedServerGroup$str(), group, servers));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedWildcardOperation$str() {
        return "WFLYDC0065: Wildcard operations are not supported as part of composite operations";
    }

    @Override
    public final OperationFailedException unsupportedWildcardOperation() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unsupportedWildcardOperation$str(), new Object[0]));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToSendMessage$str() {
        return "WFLYDC0066: Failed to send message: %s";
    }

    @Override
    public final String failedToSendMessage(String cause) {
        return String.format(this.getLoggingLocale(), this.failedToSendMessage$str(), cause);
    }

    protected String failedToSendResponseHeader$str() {
        return "WFLYDC0067: Failed to send response header: %s";
    }

    @Override
    public final String failedToSendResponseHeader(String cause) {
        return String.format(this.getLoggingLocale(), this.failedToSendResponseHeader$str(), cause);
    }

    protected String registrationTaskGotInterrupted$str() {
        return "WFLYDC0068: Host registration task got interrupted";
    }

    @Override
    public final String registrationTaskGotInterrupted() {
        return String.format(this.getLoggingLocale(), this.registrationTaskGotInterrupted$str(), new Object[0]);
    }

    protected String registrationTaskFailed$str() {
        return "WFLYDC0069: Host registration task failed: %s";
    }

    @Override
    public final String registrationTaskFailed(String cause) {
        return String.format(this.getLoggingLocale(), this.registrationTaskFailed$str(), cause);
    }

    @Override
    public final void interruptedAwaitingPreparedResponse(String callerClass, Set<ServerIdentity> servers) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.interruptedAwaitingPreparedResponse$str(), (Object)callerClass, servers);
    }

    protected String interruptedAwaitingPreparedResponse$str() {
        return "WFLYDC0070: %s interrupted awaiting server prepared response(s) -- cancelling updates for servers %s";
    }

    @Override
    public final void interruptedAwaitingHostPreparedResponse(Set<String> hosts) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.interruptedAwaitingHostPreparedResponse$str(), hosts);
    }

    protected String interruptedAwaitingHostPreparedResponse$str() {
        return "WFLYDC0071: Interrupted awaiting host prepared response(s) -- cancelling updates for hosts %s";
    }

    protected String caughtIOExceptionUploadingContent$str() {
        return "WFLYDC0072: Caught IOException reading uploaded deployment content";
    }

    @Override
    public final OperationFailedException caughtIOExceptionUploadingContent(IOException cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.caughtIOExceptionUploadingContent$str(), new Object[0]), (Throwable)cause);
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void undeployingDeploymentHasBeenRedeployed(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.undeployingDeploymentHasBeenRedeployed$str(), (Object)deploymentName);
    }

    protected String undeployingDeploymentHasBeenRedeployed$str() {
        return "WFLYDC0073: %s deployment has been re-deployed, its content will not be removed. You will need to restart it.";
    }

    protected String operationFailedOrRolledBackWithCause$str() {
        return "WFLYDC0074: Operation failed or was rolled back on all servers. Server failures:";
    }

    @Override
    public final String operationFailedOrRolledBackWithCause() {
        return String.format(this.getLoggingLocale(), this.operationFailedOrRolledBackWithCause$str(), new Object[0]);
    }

    protected String missingExtensions$str() {
        return "WFLYDC0075: Cannot synchronize the model due to missing extensions: %s";
    }

    @Override
    public final OperationFailedException missingExtensions(Set<String> missingExtensions) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.missingExtensions$str(), missingExtensions));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateProfileInclude$str() {
        return "WFLYDC0076: Duplicate included profile '%s'";
    }

    @Override
    public final XMLStreamException duplicateProfileInclude(String name) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.duplicateProfileInclude$str(), name));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateSocketBindingGroupInclude$str() {
        return "WFLYDC0077: Duplicate included socket binding group '%s'";
    }

    @Override
    public final XMLStreamException duplicateSocketBindingGroupInclude(String s) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.duplicateSocketBindingGroupInclude$str(), s));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cloneOperationNotSupportedOnHost$str() {
        return "WFLYDC0078: The profile clone operation is not available on the host '%s'. To be able to use it in a domain containing older secondary hosts which do not support the profile clone operation, you need to either: a) Make sure that all older secondary hosts with a model version smaller than 4.0.0 ignore the cloned profile and the profile specified in the 'to-profile' parameter. b) Reload the domain controller into admin-only mode, perform the clone, then reload the domain controller into normal mode again, and check whether the secondary hosts need reloading.";
    }

    @Override
    public final String cloneOperationNotSupportedOnHost(String hostName) {
        return String.format(this.getLoggingLocale(), this.cloneOperationNotSupportedOnHost$str(), hostName);
    }

    @Override
    public final void timedOutAwaitingHostPreparedResponses(long timeout, Set<String> timeoutHosts, Set<String> allHosts) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.timedOutAwaitingHostPreparedResponses$str(), (Object)timeout, timeoutHosts, allHosts);
    }

    protected String timedOutAwaitingHostPreparedResponses$str() {
        return "WFLYDC0079: Timed out after %d ms awaiting host prepared response(s) from hosts %s -- cancelling updates for hosts %s";
    }

    protected String timedOutAwaitingHostPreparedResponse$str() {
        return "WFLYDC0080: Timed out after %d ms awaiting host prepared response(s) -- remote host %s has been notified to cancel operation";
    }

    @Override
    public final String timedOutAwaitingHostPreparedResponse(long timeout, String host) {
        return String.format(this.getLoggingLocale(), this.timedOutAwaitingHostPreparedResponse$str(), timeout, host);
    }

    @Override
    public final void timedOutAwaitingFinalResponse(long timeout, String hostName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.timedOutAwaitingFinalResponse2$str(), (Object)timeout, (Object)hostName);
    }

    protected String timedOutAwaitingFinalResponse2$str() {
        return "WFLYDC0081: Timed out after %d ms awaiting final response from host %s; remote process has been notified to cancel operation";
    }

    @Override
    public final void timedOutAwaitingPreparedResponse(String callerClass, long timeout, Set<ServerIdentity> servers) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.timedOutAwaitingPreparedResponse$str(), (Object)callerClass, (Object)timeout, servers);
    }

    protected String timedOutAwaitingPreparedResponse$str() {
        return "WFLYDC0082: %s timed out after %d ms awaiting server prepared response(s) -- cancelling updates for servers %s";
    }

    @Override
    public final void timedOutAwaitingFinalResponse(int patient, String serverName, String hostName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.timedOutAwaitingFinalResponse3$str(), (Object)patient, (Object)serverName, (Object)hostName);
    }

    protected String timedOutAwaitingFinalResponse3$str() {
        return "WFLYDC0083: Timed out after %d ms awaiting final response from server %s on host %s; remote process has been notified to cancel operation";
    }

    protected String cannotExplodeDeploymentOfSelfContainedServer$str() {
        return "WFLYDC0084: Cannot explode a deployment in a self-contained server";
    }

    @Override
    public final OperationFailedException cannotExplodeDeploymentOfSelfContainedServer() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotExplodeDeploymentOfSelfContainedServer$str(), new Object[0]));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotExplodeUnmanagedDeployment$str() {
        return "WFLYDC0085: Cannot explode an unmanaged deployment";
    }

    @Override
    public final OperationFailedException cannotExplodeUnmanagedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotExplodeUnmanagedDeployment$str(), new Object[0]));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotExplodeAlreadyExplodedDeployment$str() {
        return "WFLYDC0086: Cannot explode an already exploded deployment";
    }

    @Override
    public final OperationFailedException cannotExplodeAlreadyExplodedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotExplodeAlreadyExplodedDeployment$str(), new Object[0]));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotExplodeEnabledDeployment$str() {
        return "WFLYDC0087: Cannot explode an already deployed deployment";
    }

    @Override
    public final OperationFailedException cannotExplodeEnabledDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotExplodeEnabledDeployment$str(), new Object[0]));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAddContentToSelfContainedServer$str() {
        return "WFLYDC0088: Cannot add content to a deployment in a self-contained server";
    }

    @Override
    public final OperationFailedException cannotAddContentToSelfContainedServer() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotAddContentToSelfContainedServer$str(), new Object[0]));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAddContentToUnmanagedDeployment$str() {
        return "WFLYDC0089: Cannot add content to an unmanaged deployment";
    }

    @Override
    public final OperationFailedException cannotAddContentToUnmanagedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotAddContentToUnmanagedDeployment$str(), new Object[0]));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAddContentToUnexplodedDeployment$str() {
        return "WFLYDC0090: Cannot add content to an unexploded deployment";
    }

    @Override
    public final OperationFailedException cannotAddContentToUnexplodedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotAddContentToUnexplodedDeployment$str(), new Object[0]));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRemoveContentFromSelfContainedServer$str() {
        return "WFLYDC0091: Cannot remove content from a deployment in a self-contained server";
    }

    @Override
    public final OperationFailedException cannotRemoveContentFromSelfContainedServer() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotRemoveContentFromSelfContainedServer$str(), new Object[0]));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRemoveContentFromUnmanagedDeployment$str() {
        return "WFLYDC0092: Cannot remove content from an unmanaged deployment";
    }

    @Override
    public final OperationFailedException cannotRemoveContentFromUnmanagedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotRemoveContentFromUnmanagedDeployment$str(), new Object[0]));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRemoveContentFromUnexplodedDeployment$str() {
        return "WFLYDC0093: Cannot remove content from an unexploded deployment";
    }

    @Override
    public final OperationFailedException cannotRemoveContentFromUnexplodedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotRemoveContentFromUnexplodedDeployment$str(), new Object[0]));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotReadContentFromSelfContainedServer$str() {
        return "WFLYDC0094: Cannot read content from a deployment in a self-contained server";
    }

    @Override
    public final OperationFailedException cannotReadContentFromSelfContainedServer() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotReadContentFromSelfContainedServer$str(), new Object[0]));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotReadContentFromUnmanagedDeployment$str() {
        return "WFLYDC0095: Cannot read content from an unmanaged deployment";
    }

    @Override
    public final OperationFailedException cannotReadContentFromUnmanagedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotReadContentFromUnmanagedDeployment$str(), new Object[0]));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotReadContentFromUnexplodedDeployment$str() {
        return "WFLYDC0096: Cannot read content from an unexploded deployment";
    }

    @Override
    public final OperationFailedException cannotReadContentFromUnexplodedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotReadContentFromUnexplodedDeployment$str(), new Object[0]));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotExplodeSubDeploymentOfUnexplodedDeployment$str() {
        return "WFLYDC0097: Cannot explode a subdeployment of an unexploded deployment";
    }

    @Override
    public final OperationFailedException cannotExplodeSubDeploymentOfUnexplodedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotExplodeSubDeploymentOfUnexplodedDeployment$str(), new Object[0]));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serverManagementUnavailableDuringBoot$str() {
        return "WFLYDC0098: The following servers %s are starting; execution of remote management operations is not currently available";
    }

    @Override
    public final OperationFailedException serverManagementUnavailableDuringBoot(String serverNames) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.serverManagementUnavailableDuringBoot$str(), serverNames));
        DomainControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

