/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.resources;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SslLoopbackResourceDefinition
extends SimpleResourceDefinition {
    private static final String DESCRIPTION_PREFIX = "server-config.ssl.loopback";
    public static final SimpleAttributeDefinition SSL_PROTOCOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-protocol", ModelType.STRING, true).setDefaultValue(new ModelNode("TLS"))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition TRUST_MANAGER_ALGORITHM = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("trust-manager-algorithm", ModelType.STRING, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition TRUSTSTORE_TYPE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("truststore-type", ModelType.STRING, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition TRUSTSTORE_PATH = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("truststore-path", ModelType.STRING, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition TRUSTSTORE_PASSWORD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("truststore-password", ModelType.STRING, true).setAllowExpression(true)).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{SSL_PROTOCOCOL, TRUST_MANAGER_ALGORITHM, TRUSTSTORE_TYPE, TRUSTSTORE_PATH, TRUSTSTORE_PASSWORD};
    private final List<AccessConstraintDefinition> sensitivity = SensitiveTargetAccessConstraintDefinition.SERVER_SSL.wrapAsList();

    public SslLoopbackResourceDefinition() {
        super(PathElement.pathElement((String)"ssl", (String)"loopback"), HostResolver.getResolver(DESCRIPTION_PREFIX, false), (OperationStepHandler)new SslLoopbackAddHandler(), (OperationStepHandler)new SslLoopbackRemoveHandler());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, ModelOnlyWriteAttributeHandler.INSTANCE);
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.sensitivity;
    }

    static class SslLoopbackRemoveHandler
    extends AbstractRemoveStepHandler {
        SslLoopbackRemoveHandler() {
        }

        protected boolean requiresRuntime(OperationContext context) {
            return false;
        }
    }

    static class SslLoopbackAddHandler
    extends AbstractAddStepHandler {
        SslLoopbackAddHandler() {
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attr : ATTRIBUTES) {
                attr.validateAndSet(operation, model);
            }
        }

        protected boolean requiresRuntime(OperationContext context) {
            return false;
        }
    }
}

