/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.discovery;

import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.discovery.DomainControllerManagementInterface;
import org.jboss.as.host.controller.discovery.RemoteDomainControllerConnectionConfiguration;
import org.jboss.as.host.controller.discovery.StaticDiscoveryResourceDefinition;
import org.jboss.dmr.ModelNode;

public class StaticDiscovery
implements DiscoveryOption {
    private final RemoteDomainControllerConnectionConfiguration parameters;

    public StaticDiscovery(String protocol, String host, int port) {
        this.parameters = new RemoteDomainControllerConnectionConfiguration(protocol, host, port);
    }

    @Override
    public void allowDiscovery(List<DomainControllerManagementInterface> interfaces) {
    }

    @Override
    public List<RemoteDomainControllerConnectionConfiguration> discover() {
        try {
            StaticDiscoveryResourceDefinition.HOST.getValidator().validateParameter(StaticDiscoveryResourceDefinition.HOST.getName(), new ModelNode(this.parameters.getHost()));
            StaticDiscoveryResourceDefinition.PORT.getValidator().validateParameter(StaticDiscoveryResourceDefinition.PORT.getName(), new ModelNode(this.parameters.getPort()));
            StaticDiscoveryResourceDefinition.PROTOCOL.getValidator().validateParameter(StaticDiscoveryResourceDefinition.PROTOCOL.getName(), new ModelNode(this.parameters.getProtocol()));
        }
        catch (OperationFailedException e) {
            throw new IllegalStateException(e.getFailureDescription().asString());
        }
        return Collections.singletonList(this.parameters);
    }

    @Override
    public void cleanUp() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{protocol=" + this.parameters.getProtocol() + ",host=" + this.parameters.getHost() + ",port=" + this.parameters.getPort() + "}";
    }
}

