/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ExpressionResolverImpl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.domain.controller.resources.ServerGroupResourceDefinition;
import org.jboss.as.host.controller.DirectoryGrouping;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.ManagedServer;
import org.jboss.as.host.controller.ManagedServerBootConfiguration;
import org.jboss.as.host.controller.jvm.JvmType;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.model.host.HostResourceDefinition;
import org.jboss.as.host.controller.model.jvm.JvmElement;
import org.jboss.as.host.controller.model.jvm.JvmOptionsBuilderFactory;
import org.jboss.as.host.controller.resources.SslLoopbackResourceDefinition;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.as.server.mgmt.domain.HostControllerConnectionService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ManagedServerBootCmdFactory
implements ManagedServerBootConfiguration {
    private static final String HOST_CONTROLLER_PROCESS_NAME_PROP = "[Host Controller]";
    private static final Set<String> SERVER_CONFIGURATION_PROPERTIES = new HashSet<String>(Arrays.asList("jboss.server.log.dir", "jboss.server.config.dir", "jboss.server.base.dir", "jboss.server.config.user.dir", "jboss.server.config.group.dir", "jboss.server.temp.dir", "jboss.server.content.dir", "jboss.server.data.dir", "jboss.server.deploy.dir", "jboss.server.controller.base.dir", "jboss.server.default.config", "jboss.server.management.uuid", "jboss.server.persist.config"));
    private static final Random random = new Random();
    private static final ModelNode EMPTY = new ModelNode();
    private static final String EXCLUDED_PROPERTIES_PROP = "jboss.host.server-excluded-properties";
    private final String serverName;
    private final int processId = Math.abs(random.nextInt());
    private final ModelNode domainModel;
    private final ModelNode hostModel;
    private final ModelNode serverModel;
    private final ModelNode serverGroup;
    private final JvmElement jvmElement;
    private final HostControllerEnvironment environment;
    private final boolean managementSubsystemEndpoint;
    private final ModelNode endpointConfig = new ModelNode();
    private final ManagedServerExprResolver expressionResolver;
    private final DirectoryGrouping directoryGrouping;
    private final Supplier<SSLContext> sslContextSupplier;
    private final boolean suspend;
    private final boolean gracefulStartup;
    private JvmType jvmType;
    private final String logDir;
    private final String tmpDir;
    private final String dataDir;

    private static Set<String> getExcludedHostProperties() {
        String excluded = System.getProperty(EXCLUDED_PROPERTIES_PROP);
        if (excluded == null || excluded.length() == 0) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(excluded.split(",")));
    }

    public ManagedServerBootCmdFactory(String serverName, ModelNode domainModel, ModelNode hostModel, HostControllerEnvironment environment, ExpressionResolver expressionResolver, boolean suspend) {
        Map<String, String> bootTimeProperties;
        String serverDirProp;
        String profileName;
        ModelNode profile;
        Iterator iterator;
        Iterator iterator2;
        this.serverName = serverName;
        this.domainModel = domainModel;
        this.hostModel = hostModel;
        this.environment = environment;
        this.expressionResolver = new ManagedServerExprResolver(expressionResolver, this.serverName);
        this.suspend = suspend;
        this.serverModel = ManagedServerBootCmdFactory.resolveExpressions(hostModel.require("server-config").require(serverName), (ExpressionResolver)this.expressionResolver, true);
        this.directoryGrouping = ManagedServerBootCmdFactory.resolveDirectoryGrouping(hostModel, (ExpressionResolver)this.expressionResolver);
        String serverGroupName = this.serverModel.require("group").asString();
        this.serverGroup = ManagedServerBootCmdFactory.resolveExpressions(domainModel.require("server-group").require(serverGroupName), (ExpressionResolver)this.expressionResolver, true);
        String serverVMName = null;
        ModelNode serverVM = null;
        if (this.serverModel.hasDefined("jvm") && (iterator2 = this.serverModel.get("jvm").keys().iterator()).hasNext()) {
            String jvm;
            serverVMName = jvm = (String)iterator2.next();
            serverVM = this.serverModel.get(new String[]{"jvm", jvm});
        }
        String groupVMName = null;
        ModelNode groupVM = null;
        if (this.serverGroup.hasDefined("jvm") && (iterator = this.serverGroup.get("jvm").keys().iterator()).hasNext()) {
            String jvm;
            groupVMName = jvm = (String)iterator.next();
            groupVM = this.serverGroup.get(new String[]{"jvm", jvm});
        }
        this.managementSubsystemEndpoint = this.serverGroup.get(ServerGroupResourceDefinition.MANAGEMENT_SUBSYSTEM_ENDPOINT.getName()).asBoolean(false);
        if (this.managementSubsystemEndpoint && (profile = domainModel.get(new String[]{"profile", profileName = this.serverGroup.get("profile").asString()})).hasDefined("subsystem") && profile.hasDefined("remoting")) {
            this.endpointConfig.set(profile.get(new String[]{"subsystem", "remoting"}));
        }
        File serverDir = (serverDirProp = (bootTimeProperties = this.getAllSystemProperties(true)).get("jboss.server.base.dir")) == null ? new File(environment.getDomainServersDir(), serverName) : new File(serverDirProp);
        this.logDir = this.addPathProperty("log", "jboss.server.log.dir", bootTimeProperties, this.directoryGrouping, environment.getDomainLogDir(), serverDir);
        this.tmpDir = this.addPathProperty("tmp", "jboss.server.temp.dir", bootTimeProperties, this.directoryGrouping, environment.getDomainTempDir(), serverDir);
        this.dataDir = this.addPathProperty("data", "jboss.server.data.dir", bootTimeProperties, this.directoryGrouping, environment.getDomainDataDir(), serverDir);
        new File(this.logDir).mkdirs();
        this.expressionResolver.addResolvableValue("jboss.server.base.dir", serverDir.getAbsolutePath());
        this.expressionResolver.addResolvableValue("jboss.server.log.dir", this.logDir);
        this.expressionResolver.addResolvableValue("jboss.server.temp.dir", this.tmpDir);
        this.expressionResolver.addResolvableValue("jboss.server.data.dir", this.dataDir);
        String jvmName = serverVMName != null ? serverVMName : groupVMName;
        ModelNode hostVM = jvmName != null ? hostModel.get(new String[]{"jvm", jvmName}) : null;
        this.jvmElement = new JvmElement(jvmName, ManagedServerBootCmdFactory.resolveNilableExpressions(hostVM, (ExpressionResolver)this.expressionResolver, false), ManagedServerBootCmdFactory.resolveNilableExpressions(groupVM, (ExpressionResolver)this.expressionResolver, false), ManagedServerBootCmdFactory.resolveNilableExpressions(serverVM, (ExpressionResolver)this.expressionResolver, false));
        this.sslContextSupplier = this.createSSLContextSupplier(this.serverModel, (ExpressionResolver)this.expressionResolver);
        try {
            this.gracefulStartup = ServerGroupResourceDefinition.GRACEFUL_STARTUP.resolveModelAttribute((ExpressionResolver)this.expressionResolver, this.serverGroup).asBoolean();
        }
        catch (OperationFailedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static ModelNode resolveNilableExpressions(ModelNode unresolved, ExpressionResolver expressionResolver, boolean excludePostBootSystemProps) {
        return unresolved == null ? null : ManagedServerBootCmdFactory.resolveExpressions(unresolved, expressionResolver, excludePostBootSystemProps);
    }

    static ModelNode resolveExpressions(ModelNode unresolved, ExpressionResolver expressionResolver, boolean excludePostBootSystemProps) {
        ModelNode toResolve = unresolved.clone();
        ModelNode sysProps = null;
        if (excludePostBootSystemProps && toResolve.hasDefined("system-property")) {
            sysProps = toResolve.remove("system-property");
        }
        try {
            ModelNode result = expressionResolver.resolveExpressions(toResolve);
            if (sysProps != null) {
                ModelNode resolvedSysProps = new ModelNode().setEmptyObject();
                for (Property property : sysProps.asPropertyList()) {
                    ModelNode val = property.getValue();
                    boolean bootTime = SystemPropertyResourceDefinition.BOOT_TIME.resolveModelAttribute(expressionResolver, val).asBoolean();
                    if (bootTime) {
                        val.get("value").set(SystemPropertyResourceDefinition.VALUE.resolveModelAttribute(expressionResolver, val));
                    }
                    val.get("boot-time").set(bootTime);
                    resolvedSysProps.get(property.getName()).set(val);
                }
                result.get("system-property").set(resolvedSysProps);
            }
            return result;
        }
        catch (OperationFailedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static DirectoryGrouping resolveDirectoryGrouping(ModelNode model, ExpressionResolver expressionResolver) {
        try {
            return DirectoryGrouping.forName(HostResourceDefinition.DIRECTORY_GROUPING.resolveModelAttribute(expressionResolver, model).asString());
        }
        catch (OperationFailedException e) {
            throw new IllegalStateException(e);
        }
    }

    public ManagedServerBootConfiguration createConfiguration() {
        return this;
    }

    @Override
    public HostControllerEnvironment getHostControllerEnvironment() {
        return this.environment;
    }

    @Override
    public List<String> getServerLaunchCommand() {
        return this.getServerLaunchCommand(true, true);
    }

    @Override
    public boolean compareServerLaunchCommand(ManagedServerBootConfiguration other) {
        boolean comparable = other instanceof ManagedServerBootCmdFactory;
        if (comparable) {
            ManagedServerBootCmdFactory otherImpl = (ManagedServerBootCmdFactory)other;
            comparable = this.getJvmType(false).equals(otherImpl.getJvmType(false)) && this.getServerLaunchCommand(false, false).equals(otherImpl.getServerLaunchCommand(false, false));
        }
        return comparable;
    }

    @Override
    public Map<String, String> getServerLaunchProperties() {
        List<String> launchCommand = this.getServerLaunchCommand(true, false);
        return ManagedServerBootCmdFactory.parseLaunchProperties(launchCommand);
    }

    private List<String> getServerLaunchCommand(boolean includeProcessId, boolean forLaunch) {
        File path;
        ArrayList<String> commandPrefix;
        ArrayList<String> command = new ArrayList<String>();
        if (this.jvmElement.getLaunchCommand() != null && (commandPrefix = this.getLaunchPrefixCommands()) != null) {
            command.addAll(commandPrefix);
        }
        String jbossModulesJar = ManagedServerBootCmdFactory.getAbsolutePath(this.environment.getHomeDir(), "jboss-modules.jar");
        JvmType localJvmType = this.getJvmType(forLaunch);
        command.add(localJvmType.getJavaExecutable());
        command.add("-D[" + ManagedServer.getServerProcessName(this.serverName) + "]");
        if (includeProcessId) {
            command.add("-D[" + ManagedServer.getServerProcessId(this.processId) + "]");
        }
        if (this.jvmElement.getModuleOptions().contains("\\-javaagent:.+")) {
            command.add("-javaagent:" + jbossModulesJar);
        }
        JvmOptionsBuilderFactory.getInstance(localJvmType).addOptions(this.jvmElement, command);
        Map<String, String> bootTimeProperties = this.getAllSystemProperties(true);
        Set<String> excludedHostProperties = ManagedServerBootCmdFactory.getExcludedHostProperties();
        for (Map.Entry<String, String> hostProp : this.environment.getHostSystemProperties().entrySet()) {
            String propName = hostProp.getKey();
            if (bootTimeProperties.containsKey(propName) || SERVER_CONFIGURATION_PROPERTIES.contains(propName) || excludedHostProperties.contains(propName)) continue;
            bootTimeProperties.put(propName, hostProp.getValue());
        }
        for (Map.Entry<String, String> entry : bootTimeProperties.entrySet()) {
            String property = entry.getKey();
            String value = entry.getValue();
            if ("org.jboss.boot.log.file".equals(property) || "logging.configuration".equals(property) || HOST_CONTROLLER_PROCESS_NAME_PROP.equals(property)) continue;
            StringBuilder sb = new StringBuilder("-D");
            sb.append(property);
            if (value != null) {
                sb.append('=');
                sb.append(value);
            }
            command.add(sb.toString());
        }
        command.addAll(localJvmType.getDefaultArguments());
        command.add(String.format("-D%s=%s", "jboss.server.log.dir", this.logDir));
        command.add(String.format("-D%s=%s", "jboss.server.temp.dir", this.tmpDir));
        command.add(String.format("-D%s=%s", "jboss.server.data.dir", this.dataDir));
        File loggingConfig = new File(this.dataDir, "logging.properties");
        if (loggingConfig.exists()) {
            path = loggingConfig;
        } else {
            command.add("-Dorg.jboss.boot.log.file=" + ManagedServerBootCmdFactory.getAbsolutePath(new File(this.logDir), "server.log"));
            File domainConfigFile = ManagedServerBootCmdFactory.getAbsoluteFile(this.environment.getDomainConfigurationDir(), "logging.properties");
            File defaultConfigFile = ManagedServerBootCmdFactory.getAbsoluteFile(this.environment.getDomainConfigurationDir(), "default-server-logging.properties");
            path = defaultConfigFile.exists() ? defaultConfigFile : domainConfigFile;
        }
        if (path.exists()) {
            try {
                command.add(String.format("-Dlogging.configuration=%s", path.toURI().toURL().toExternalForm()));
            }
            catch (MalformedURLException e) {
                HostControllerLogger.ROOT_LOGGER.failedToSetLoggingConfiguration(e, this.serverName, path);
            }
        } else {
            HostControllerLogger.ROOT_LOGGER.serverLoggingConfigurationFileNotFound(this.serverName);
        }
        command.add("-jar");
        command.add(jbossModulesJar);
        command.add("-mp");
        command.add(this.environment.getModulePath());
        if (this.environment.isSecurityManagerEnabled()) {
            command.add("-secmgr");
        }
        command.addAll(this.jvmElement.getModuleOptions().getOptions());
        command.add("org.jboss.as.server");
        if (!this.isGracefulStartup()) {
            command.add("--graceful-startup=false");
        }
        if (this.suspend) {
            command.add("--start-mode=suspend");
        }
        return command;
    }

    @Override
    public boolean isManagementSubsystemEndpoint() {
        return this.managementSubsystemEndpoint;
    }

    @Override
    public ModelNode getSubsystemEndpointConfiguration() {
        return this.endpointConfig;
    }

    private Supplier<SSLContext> createSSLContextSupplier(ModelNode serverModel, ExpressionResolver resolver) {
        if (!serverModel.hasDefined(new String[]{"ssl", "loopback"})) {
            return null;
        }
        ModelNode ssl = serverModel.get(new String[]{"ssl", "loopback"});
        try {
            String sslProtocol = SslLoopbackResourceDefinition.SSL_PROTOCOCOL.resolveModelAttribute(resolver, ssl).asString();
            String trustManagerAlgorithm = this.asStringIfDefined(ssl, (AttributeDefinition)SslLoopbackResourceDefinition.TRUST_MANAGER_ALGORITHM, resolver);
            String trustStoreType = this.asStringIfDefined(ssl, (AttributeDefinition)SslLoopbackResourceDefinition.TRUSTSTORE_TYPE, resolver);
            String trustStorePath = this.asStringIfDefined(ssl, (AttributeDefinition)SslLoopbackResourceDefinition.TRUSTSTORE_PATH, resolver);
            ModelNode trustStorePasswordModel = SslLoopbackResourceDefinition.TRUSTSTORE_PASSWORD.resolveModelAttribute(resolver, ssl);
            char[] trustStorePassword = trustStorePasswordModel.isDefined() ? trustStorePasswordModel.asString().toCharArray() : null;
            return new HostControllerConnectionService.SSLContextSupplier(sslProtocol, trustManagerAlgorithm, trustStoreType, trustStorePath, trustStorePassword);
        }
        catch (OperationFailedException e) {
            throw new IllegalStateException(e);
        }
    }

    private String asStringIfDefined(ModelNode model, AttributeDefinition attribute, ExpressionResolver resolver) throws OperationFailedException {
        ModelNode value = attribute.resolveModelAttribute(resolver, model);
        if (value.isDefined()) {
            return value.asString();
        }
        return null;
    }

    @Override
    public Supplier<SSLContext> getSSLContextSupplier() {
        return this.sslContextSupplier;
    }

    @Override
    public boolean isSuspended() {
        return this.suspend;
    }

    @Override
    public boolean isGracefulStartup() {
        return this.gracefulStartup;
    }

    @Override
    public int getServerProcessId() {
        return this.processId;
    }

    private synchronized JvmType getJvmType(boolean forLaunch) {
        JvmType result = this.jvmType;
        if (result == null) {
            String javaHome = this.jvmElement.getJavaHome();
            if (javaHome == null) {
                if (this.environment.getDefaultJVM() != null) {
                    String javaExecutable = this.environment.getDefaultJVM().getAbsolutePath();
                    result = JvmType.createFromJavaExecutable(javaExecutable, forLaunch);
                } else {
                    result = JvmType.createFromSystemProperty(forLaunch);
                }
            } else {
                result = JvmType.createFromJavaHome(javaHome, forLaunch);
            }
            if (forLaunch) {
                this.jvmType = result;
            }
        }
        return result;
    }

    private ArrayList<String> getLaunchPrefixCommands() {
        String launchCommand = this.jvmElement.getLaunchCommand();
        ArrayList<String> commands = null;
        if (launchCommand.length() > 0) {
            commands = new ArrayList<String>(Arrays.asList(launchCommand.split("\\s* \\s*")));
        }
        HostControllerLogger.ROOT_LOGGER.serverLaunchCommandPrefix(this.serverName, launchCommand);
        return commands;
    }

    @Override
    public Map<String, String> getServerLaunchEnvironment() {
        HashMap<String, String> env = new HashMap<String, String>();
        for (Map.Entry<String, String> property : this.jvmElement.getEnvironmentVariables().entrySet()) {
            env.put(property.getKey(), property.getValue());
        }
        return env;
    }

    private Map<String, String> getAllSystemProperties(boolean boottimeOnly) {
        TreeMap<String, String> props = new TreeMap<String, String>();
        this.addSystemProperties(this.domainModel, props, boottimeOnly);
        this.addSystemProperties(this.serverGroup, props, boottimeOnly);
        this.addSystemProperties(this.hostModel, props, boottimeOnly);
        this.addSystemProperties(this.serverModel, props, boottimeOnly);
        return props;
    }

    private void addSystemProperties(ModelNode source, Map<String, String> props, boolean boottimeOnly) {
        if (source.hasDefined("system-property")) {
            for (Property prop : source.get("system-property").asPropertyList()) {
                ModelNode propResource = prop.getValue();
                try {
                    if (boottimeOnly && !SystemPropertyResourceDefinition.BOOT_TIME.resolveModelAttribute((ExpressionResolver)this.expressionResolver, propResource).asBoolean()) {
                        continue;
                    }
                }
                catch (OperationFailedException e) {
                    throw new IllegalStateException(e);
                }
                String val = propResource.hasDefined("value") ? propResource.get("value").asString() : null;
                props.put(prop.getName(), val);
            }
        }
    }

    private String addPathProperty(String typeName, String propertyName, Map<String, String> properties, DirectoryGrouping directoryGrouping, File typeDir, File serverDir) {
        String result;
        String value = properties.get(propertyName);
        if (value == null) {
            switch (directoryGrouping) {
                case BY_TYPE: {
                    result = ManagedServerBootCmdFactory.getAbsolutePath(typeDir, "servers", this.serverName);
                    break;
                }
                default: {
                    result = ManagedServerBootCmdFactory.getAbsolutePath(serverDir, typeName);
                }
            }
            properties.put(propertyName, result);
        } else {
            File dir = new File(value);
            switch (directoryGrouping) {
                case BY_TYPE: {
                    result = ManagedServerBootCmdFactory.getAbsolutePath(dir, "servers", this.serverName);
                    break;
                }
                default: {
                    result = ManagedServerBootCmdFactory.getAbsolutePath(dir, this.serverName);
                }
            }
        }
        return result;
    }

    static String getAbsolutePath(File root, String ... paths) {
        return ManagedServerBootCmdFactory.getAbsoluteFile(root, paths).getAbsolutePath();
    }

    static File getAbsoluteFile(File root, String ... paths) {
        File path = root;
        for (String segment : paths) {
            path = new File(path, segment);
        }
        return path.getAbsoluteFile();
    }

    private static Map<String, String> parseLaunchProperties(List<String> commands) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String cmd : commands) {
            if (!cmd.startsWith("-D")) continue;
            String[] parts = cmd.substring(2).split("=");
            if (parts.length == 2) {
                result.put(parts[0], parts[1]);
                continue;
            }
            if (parts.length != 1) continue;
            result.put(parts[0], "true");
        }
        return result;
    }

    static {
        EMPTY.setEmptyList();
        EMPTY.protect();
    }

    static class ManagedServerExprResolver
    extends ExpressionResolverImpl {
        final ExpressionResolver delegate;
        final String serverName;
        final Map<String, String> resolvableData;

        public ManagedServerExprResolver(ExpressionResolver delegate, String serverName) {
            super(true);
            this.delegate = delegate;
            this.serverName = serverName;
            this.resolvableData = new HashMap<String, String>(){
                {
                    this.put("jboss.server.base.dir", null);
                    this.put("jboss.server.data.dir", null);
                    this.put("jboss.server.log.dir", null);
                    this.put("jboss.server.temp.dir", null);
                }
            };
        }

        protected void resolvePluggableExpression(ModelNode node, OperationContext context) throws OperationFailedException {
            String expression = node.asString();
            if (expression.length() > 3) {
                String expressionValue = expression.substring(2, expression.length() - 1);
                if (this.resolvableData.containsKey(expressionValue)) {
                    String resolved = this.resolvableData.get(expressionValue);
                    if (resolved == null) {
                        return;
                    }
                    node.set(resolved);
                } else {
                    node.set(this.delegate.resolveExpressions(node, context));
                }
            }
        }

        public void addResolvableValue(String property, String value) {
            if (!this.resolvableData.containsKey(property)) {
                throw new IllegalStateException();
            }
            this.resolvableData.put(property, value);
        }
    }
}

