/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.CapabilityRegistry;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.registry.CapabilityScope;
import org.jboss.as.controller.capability.registry.RegistrationPoint;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistration;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistry;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class HostPathManagerService
extends PathManagerService {
    private final CapabilityRegistry localCapRegRef;

    public static ServiceController<?> addService(ServiceTarget serviceTarget, HostPathManagerService service, HostControllerEnvironment hostEnvironment) {
        ServiceBuilder serviceBuilder = serviceTarget.addService(AbstractControllerService.PATH_MANAGER_CAPABILITY.getCapabilityServiceName(), (Service)service).addAliases(new ServiceName[]{SERVICE_NAME});
        service.addHardcodedAbsolutePath(serviceTarget, "jboss.home.dir", hostEnvironment.getHomeDir().getAbsolutePath());
        service.addHardcodedAbsolutePath(serviceTarget, "jboss.domain.base.dir", hostEnvironment.getDomainBaseDir().getAbsolutePath());
        service.addHardcodedAbsolutePath(serviceTarget, "jboss.domain.config.dir", hostEnvironment.getDomainConfigurationDir().getAbsolutePath());
        service.addHardcodedAbsolutePath(serviceTarget, "jboss.domain.data.dir", hostEnvironment.getDomainDataDir().getAbsolutePath());
        service.addHardcodedAbsolutePath(serviceTarget, "jboss.domain.log.dir", hostEnvironment.getDomainLogDir().getAbsolutePath());
        service.addHardcodedAbsolutePath(serviceTarget, "jboss.domain.temp.dir", hostEnvironment.getDomainTempDir().getAbsolutePath());
        service.addHardcodedAbsolutePath(serviceTarget, "jboss.controller.temp.dir", hostEnvironment.getDomainTempDir().getAbsolutePath());
        HostPathManagerService.registerServerPathCapability(service.localCapRegRef, "jboss.server.base.dir");
        HostPathManagerService.registerServerPathCapability(service.localCapRegRef, "jboss.server.config.dir");
        HostPathManagerService.registerServerPathCapability(service.localCapRegRef, "jboss.server.data.dir");
        HostPathManagerService.registerServerPathCapability(service.localCapRegRef, "jboss.server.log.dir");
        HostPathManagerService.registerServerPathCapability(service.localCapRegRef, "jboss.server.temp.dir");
        return serviceBuilder.install();
    }

    private static void registerServerPathCapability(CapabilityRegistry capabilityRegistry, String path) {
        capabilityRegistry.registerCapability(new RuntimeCapabilityRegistration(PathResourceDefinition.PATH_CAPABILITY.fromBaseCapability(path), CapabilityScope.GLOBAL, new RegistrationPoint(PathAddress.EMPTY_ADDRESS, null)));
    }

    public HostPathManagerService(CapabilityRegistry capabilityRegistry) {
        super((RuntimeCapabilityRegistry)capabilityRegistry);
        this.localCapRegRef = capabilityRegistry;
    }
}

