/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.discovery.DomainControllerManagementInterface;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class DiscoveryService
implements Service<Void> {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "discovery"});
    private final Map<String, InjectedValue<NetworkInterfaceBinding>> interfaceBindings = new HashMap<String, InjectedValue<NetworkInterfaceBinding>>();
    private final InjectedValue<ExecutorService> executorService = new InjectedValue();
    private final List<DiscoveryOption> discoveryOptions;
    private final List<DomainControllerManagementInterface> managementInterfaces;
    private final boolean isMasterDomainController;

    private DiscoveryService(List<DiscoveryOption> discoveryOptions, List<DomainControllerManagementInterface> managementInterfaces, boolean isMasterDomainController) {
        this.discoveryOptions = discoveryOptions;
        this.managementInterfaces = managementInterfaces;
        for (DomainControllerManagementInterface managementInterface : managementInterfaces) {
            this.interfaceBindings.put(managementInterface.getHost(), (InjectedValue<NetworkInterfaceBinding>)new InjectedValue());
        }
        this.isMasterDomainController = isMasterDomainController;
    }

    static void install(ServiceTarget serviceTarget, List<DiscoveryOption> discoveryOptions, List<DomainControllerManagementInterface> managementInterfaces, boolean isMasterDomainController) {
        DiscoveryService discovery = new DiscoveryService(discoveryOptions, managementInterfaces, isMasterDomainController);
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME, (Service)discovery).addDependency(HostControllerService.HC_EXECUTOR_SERVICE_NAME, ExecutorService.class, discovery.executorService);
        HashSet<String> alreadyDefinedInterfaces = new HashSet<String>();
        for (DomainControllerManagementInterface managementInterface : managementInterfaces) {
            if (alreadyDefinedInterfaces.contains(managementInterface.getAddress())) continue;
            builder.addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{managementInterface.getAddress()}), NetworkInterfaceBinding.class, (Injector)discovery.interfaceBindings.get(managementInterface.getAddress()));
            alreadyDefinedInterfaces.add(managementInterface.getAddress());
        }
        builder.install();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(final StartContext context) throws StartException {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    if (DiscoveryService.this.isMasterDomainController && DiscoveryService.this.discoveryOptions != null) {
                        for (DomainControllerManagementInterface managementInterface : DiscoveryService.this.managementInterfaces) {
                            String host = ((NetworkInterfaceBinding)((InjectedValue)DiscoveryService.this.interfaceBindings.get(managementInterface.getAddress())).getValue()).getAddress().getHostAddress();
                            managementInterface.setHost(host);
                        }
                        for (DiscoveryOption discoveryOption : DiscoveryService.this.discoveryOptions) {
                            discoveryOption.allowDiscovery(DiscoveryService.this.managementInterfaces);
                        }
                    }
                    context.complete();
                }
                catch (Exception e) {
                    context.failed(new StartException((Throwable)e));
                }
            }
        };
        try {
            ((ExecutorService)this.executorService.getValue()).execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(final StopContext context) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    if (DiscoveryService.this.isMasterDomainController && DiscoveryService.this.discoveryOptions != null) {
                        for (DiscoveryOption discoveryOption : DiscoveryService.this.discoveryOptions) {
                            discoveryOption.cleanUp();
                        }
                    }
                }
                finally {
                    context.complete();
                }
            }
        };
        try {
            ((ExecutorService)this.executorService.getValue()).execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public synchronized Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }
}

