/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.operations.ReadDomainModelHandler;
import org.jboss.as.domain.controller.operations.ReadMasterDomainModelUtil;
import org.jboss.as.host.controller.IgnoredNonAffectedServerGroupsUtil;
import org.jboss.as.host.controller.mgmt.HostInfo;
import org.jboss.dmr.ModelNode;

public class FetchMissingConfigurationHandler
implements OperationStepHandler {
    public static String OPERATION_NAME = "slave-server-config-change";
    private final Transformers transformers;
    private final ExtensionRegistry extensionRegistry;

    public FetchMissingConfigurationHandler(String hostName, Transformers transformers, ExtensionRegistry extensionRegistry) {
        this.transformers = transformers;
        this.extensionRegistry = extensionRegistry;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.acquireControllerLock();
        Set<IgnoredNonAffectedServerGroupsUtil.ServerConfigInfo> serverConfigs = IgnoredNonAffectedServerGroupsUtil.createConfigsFromModel(operation);
        ReadMasterDomainModelUtil.RequiredConfigurationHolder rc = new ReadMasterDomainModelUtil.RequiredConfigurationHolder();
        for (IgnoredNonAffectedServerGroupsUtil.ServerConfigInfo serverConfig : serverConfigs) {
            ReadMasterDomainModelUtil.processServerConfig(context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS), rc, serverConfig, this.extensionRegistry);
        }
        Transformers.ResourceIgnoredTransformationRegistry manualExcludes = HostInfo.createIgnoredRegistry(operation);
        Transformers.ResourceIgnoredTransformationRegistry ignoredTransformationRegistry = ReadMasterDomainModelUtil.createServerIgnoredRegistry(rc, manualExcludes);
        ReadDomainModelHandler handler = new ReadDomainModelHandler(ignoredTransformationRegistry, this.transformers);
        context.addStep((OperationStepHandler)handler, OperationContext.Stage.MODEL);
    }
}

