/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.dmr.ModelNode;

public class DomainModelIncludesValidator
implements OperationStepHandler {
    private static DomainModelIncludesValidator INSTANCE = new DomainModelIncludesValidator();
    private static final OperationContext.AttachmentKey<DomainModelIncludesValidator> KEY = OperationContext.AttachmentKey.create(DomainModelIncludesValidator.class);

    private DomainModelIncludesValidator() {
    }

    public static void addValidationStep(OperationContext context, ModelNode operation) {
        assert (context.getProcessType() == ProcessType.HOST_CONTROLLER) : "Not a host controller";
        if (!context.isBooting() && context.attachIfAbsent(KEY, (Object)INSTANCE) == null) {
            context.addStep((OperationStepHandler)INSTANCE, OperationContext.Stage.MODEL);
        }
    }

    public static void validateAtBoot(OperationContext context, ModelNode operation) {
        assert (context.getProcessType() == ProcessType.HOST_CONTROLLER) : "Not a host controller";
        assert (context.isBooting()) : "Should only be called at boot";
        assert (operation.require("operation").asString().equals("validate"));
        if (context.attachIfAbsent(KEY, (Object)INSTANCE) == null) {
            context.addStep((OperationStepHandler)INSTANCE, OperationContext.Stage.MODEL);
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validate(context);
    }

    public void validate(OperationContext context) throws OperationFailedException {
        Resource domain = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
        HashSet<String> missingProfiles = new HashSet<String>();
        HashSet<String> missingSocketBindingGroups = new HashSet<String>();
        this.checkProfileIncludes(domain, missingProfiles);
        this.checkSocketBindingGroupIncludes(domain, missingSocketBindingGroups);
    }

    private Set<String> checkProfileIncludes(Resource domain, Set<String> missingProfiles) throws OperationFailedException {
        ProfileIncludeValidator validator = new ProfileIncludeValidator();
        for (Resource.ResourceEntry entry : domain.getChildren("profile")) {
            validator.processResource(entry);
        }
        validator.validate(missingProfiles);
        return validator.resourceIncludes.keySet();
    }

    private Set<String> checkSocketBindingGroupIncludes(Resource domain, Set<String> missingSocketBindingGroups) throws OperationFailedException {
        SocketBindingGroupIncludeValidator validator = new SocketBindingGroupIncludeValidator();
        for (Resource.ResourceEntry entry : domain.getChildren("socket-binding-group")) {
            validator.processResource(entry);
        }
        validator.validate(missingSocketBindingGroups);
        return new HashSet<String>(validator.resourceIncludes.keySet());
    }

    private static class SocketBindingGroupIncludeValidator
    extends AbstractIncludeValidator {
        private SocketBindingGroupIncludeValidator() {
        }

        @Override
        void processResource(Resource.ResourceEntry groupEntry) throws OperationFailedException {
            Set<String> bindings;
            super.processResource(groupEntry);
            if (groupEntry.hasChildren("socket-binding") || groupEntry.hasChildren("local-destination-outbound-socket-binding") || groupEntry.hasChildren("remote-destination-outbound-socket-binding")) {
                bindings = new HashSet<String>();
                this.addBindings(groupEntry, bindings, "socket-binding");
                this.addBindings(groupEntry, bindings, "local-destination-outbound-socket-binding");
                this.addBindings(groupEntry, bindings, "remote-destination-outbound-socket-binding");
                bindings.addAll(groupEntry.getChildrenNames("subsystem"));
            } else {
                bindings = Collections.emptySet();
            }
            this.resourceChildren.put(groupEntry.getName(), bindings);
        }

        private void addBindings(Resource.ResourceEntry groupEntry, Set<String> bindings, String bindingType) throws OperationFailedException {
            if (groupEntry.hasChildren(bindingType)) {
                for (String name : groupEntry.getChildrenNames(bindingType)) {
                    if (bindings.add(name)) continue;
                    throw HostControllerLogger.ROOT_LOGGER.bindingNameNotUnique(name, groupEntry.getName());
                }
            }
        }

        @Override
        OperationFailedException attemptingToOverride(String parentOfExistingChild, String child, String resourceName) {
            return HostControllerLogger.ROOT_LOGGER.socketBindingGroupAttemptingToOverrideSocketBinding(parentOfExistingChild, child, resourceName);
        }

        @Override
        OperationFailedException involvedInACycle(String include) {
            return HostControllerLogger.ROOT_LOGGER.socketBindingGroupInvolvedInACycle(include);
        }

        @Override
        protected OperationFailedException twoParentsWithSameChild(String commonParent, String include1, String include2, String child) {
            return HostControllerLogger.ROOT_LOGGER.socketBindingGroupIncludesSameSocketBinding(commonParent, include1, include2, child);
        }
    }

    private static class ProfileIncludeValidator
    extends AbstractIncludeValidator {
        private ProfileIncludeValidator() {
        }

        @Override
        void processResource(Resource.ResourceEntry profileEntry) throws OperationFailedException {
            Set subsystems;
            super.processResource(profileEntry);
            if (profileEntry.hasChildren("subsystem")) {
                subsystems = new HashSet();
                subsystems.addAll(profileEntry.getChildrenNames("subsystem"));
            } else {
                subsystems = Collections.emptySet();
            }
            this.resourceChildren.put(profileEntry.getName(), subsystems);
        }

        @Override
        OperationFailedException attemptingToOverride(String parentOfExistingChild, String child, String resourceName) {
            return HostControllerLogger.ROOT_LOGGER.profileAttemptingToOverrideSubsystem(parentOfExistingChild, child, resourceName);
        }

        @Override
        OperationFailedException involvedInACycle(String include) {
            return HostControllerLogger.ROOT_LOGGER.profileInvolvedInACycle(include);
        }

        @Override
        protected OperationFailedException twoParentsWithSameChild(String commonParent, String include1, String include2, String child) {
            return HostControllerLogger.ROOT_LOGGER.profileIncludesSameSubsystem(commonParent, include1, include2, child);
        }
    }

    private static abstract class AbstractIncludeValidator {
        protected final Set<String> seen = new HashSet<String>();
        protected final Set<String> onStack = new HashSet<String>();
        protected final Map<String, String> linkTo = new HashMap<String, String>();
        protected final Map<String, Set<String>> resourceIncludes = new HashMap<String, Set<String>>();
        protected final Map<String, Set<String>> resourceChildren = new HashMap<String, Set<String>>();
        protected final List<String> post = new ArrayList<String>();

        private AbstractIncludeValidator() {
        }

        void processResource(Resource.ResourceEntry resourceEntry) throws OperationFailedException {
            Set includes;
            ModelNode model = resourceEntry.getModel();
            if (model.hasDefined("includes")) {
                includes = new HashSet();
                for (ModelNode include : model.get("includes").asList()) {
                    includes.add(include.asString());
                }
            } else {
                includes = Collections.emptySet();
            }
            this.resourceIncludes.put(resourceEntry.getName(), includes);
        }

        void validate(Set<String> missingEntries) throws OperationFailedException {
            for (String resourceName : this.resourceIncludes.keySet()) {
                if (this.seen.contains(resourceName)) continue;
                this.dfsForMissingOrCyclicIncludes(resourceName, missingEntries);
            }
            if (missingEntries.size() > 0) {
                return;
            }
            this.seen.clear();
            ListIterator<String> it = this.post.listIterator(this.post.size());
            while (it.hasPrevious()) {
                String resourceName;
                resourceName = it.previous();
                if (this.seen.contains(resourceName)) continue;
                ArrayList<String> stack = new ArrayList<String>();
                HashMap<String, List<String>> reachableChildren = new HashMap<String, List<String>>();
                this.validateChildrenNotOverridden(resourceName, reachableChildren, stack);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void validateChildrenNotOverridden(String resourceName, Map<String, List<String>> reachableChildren, List<String> stack) throws OperationFailedException {
            stack.add(resourceName);
            try {
                this.seen.add(resourceName);
                Set<String> includes = this.resourceIncludes.get(resourceName);
                Set<String> children = this.resourceChildren.get(resourceName);
                if (includes.size() == 0 && children.size() == 0) {
                    return;
                }
                for (String child : this.resourceChildren.get(resourceName)) {
                    List<String> existingChildParentStack = reachableChildren.get(child);
                    if (existingChildParentStack != null) {
                        this.logError(resourceName, stack, child, existingChildParentStack);
                    }
                    reachableChildren.put(child, new ArrayList<String>(stack));
                }
                for (String include : includes) {
                    this.validateChildrenNotOverridden(include, reachableChildren, stack);
                }
            }
            finally {
                stack.remove(stack.size() - 1);
            }
        }

        private void logError(String resourceName, List<String> stack, String child, List<String> existingChildParentStack) throws OperationFailedException {
            ListIterator<String> it = stack.listIterator(stack.size());
            while (it.hasPrevious()) {
                String commonParent = it.previous();
                if (!existingChildParentStack.contains(commonParent) || this.getLastElement(existingChildParentStack).equals(commonParent)) continue;
                throw this.twoParentsWithSameChild(commonParent, this.getLastElement(stack), this.getLastElement(existingChildParentStack), child);
            }
            throw this.attemptingToOverride(this.getLastElement(existingChildParentStack), child, resourceName);
        }

        private String getLastElement(List<String> list) {
            return list.get(list.size() - 1);
        }

        protected abstract OperationFailedException twoParentsWithSameChild(String var1, String var2, String var3, String var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dfsForMissingOrCyclicIncludes(String resourceName, Set<String> missingEntries) throws OperationFailedException {
            this.onStack.add(resourceName);
            try {
                this.seen.add(resourceName);
                Set<String> includes = this.resourceIncludes.get(resourceName);
                if (includes == null) {
                    missingEntries.add(resourceName);
                    return;
                }
                for (String include : includes) {
                    if (!this.seen.contains(include)) {
                        this.linkTo.put(include, resourceName);
                        this.dfsForMissingOrCyclicIncludes(include, missingEntries);
                        continue;
                    }
                    if (!this.onStack.contains(include)) continue;
                    throw this.involvedInACycle(include);
                }
            }
            finally {
                this.onStack.remove(resourceName);
            }
            this.post.add(resourceName);
        }

        abstract OperationFailedException attemptingToOverride(String var1, String var2, String var3);

        abstract OperationFailedException involvedInACycle(String var1);
    }
}

