/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.coordination.OperationCoordinatorStepHandler;
import org.jboss.as.domain.controller.operations.coordination.OperationSlaveStepHandler;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.dmr.ModelNode;

public class PrepareStepHandler
implements OperationStepHandler {
    private final LocalHostControllerInfo localHostControllerInfo;
    private final OperationCoordinatorStepHandler coordinatorHandler;
    private final OperationSlaveStepHandler slaveHandler;

    public PrepareStepHandler(LocalHostControllerInfo localHostControllerInfo, Map<String, ProxyController> hostProxies, Map<String, ProxyController> serverProxies, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, ExtensionRegistry extensionRegistry) {
        this.localHostControllerInfo = localHostControllerInfo;
        this.slaveHandler = new OperationSlaveStepHandler(localHostControllerInfo, serverProxies, ignoredDomainResourceRegistry, extensionRegistry);
        this.coordinatorHandler = new OperationCoordinatorStepHandler(localHostControllerInfo, hostProxies, serverProxies, this.slaveHandler);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isBooting()) {
            this.executeDirect(context, operation);
        } else if (operation.hasDefined("operation-headers") && operation.get("operation-headers").hasDefined("execute-for-coordinator") && operation.get("operation-headers").get("execute-for-coordinator").asBoolean()) {
            this.slaveHandler.execute(context, operation);
        } else if (this.isServerOperation(operation)) {
            OperationCoordinatorStepHandler.configureDomainUUID(operation);
            this.executeDirect(context, operation);
        } else {
            this.coordinatorHandler.execute(context, operation);
        }
    }

    public void setExecutorService(ExecutorService executorService) {
        this.coordinatorHandler.setExecutorService(executorService);
    }

    private boolean isServerOperation(ModelNode operation) {
        PathAddress addr = PathAddress.pathAddress((ModelNode)operation.get("address"));
        return addr.size() > 1 && "host".equals(addr.getElement(0).getKey()) && this.localHostControllerInfo.getLocalHostName().equals(addr.getElement(0).getValue()) && "server".equals(addr.getElement(1).getKey());
    }

    private void executeDirect(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("%s executing direct", this.getClass().getSimpleName());
        }
        PrepareStepHandler.executeDirectOperation(context, operation);
    }

    static void executeDirectOperation(OperationContext context, ModelNode operation) throws OperationFailedException {
        String operationName = operation.require("operation").asString();
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        OperationStepHandler stepHandler = context.getRootResourceRegistration().getOperationHandler(PathAddress.pathAddress((ModelNode)operation.get("address")), operationName);
        if (stepHandler != null) {
            context.addStep(stepHandler, OperationContext.Stage.MODEL);
        } else {
            PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
            if (registration == null) {
                context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.noSuchResourceType(pathAddress));
            } else {
                context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(operationName, pathAddress));
            }
        }
    }
}

