/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.operations.ReadMasterDomainModelUtil;
import org.jboss.as.domain.controller.operations.SyncModelHandlerBase;
import org.jboss.as.domain.controller.operations.deployment.SyncModelParameters;

public class SyncServerGroupOperationHandler
extends SyncModelHandlerBase {
    private final String localHostName;
    private final Resource originalModel;
    private final SyncModelParameters parameters;

    public SyncServerGroupOperationHandler(String localHostName, Resource originalDomainModel, SyncModelParameters parameters) {
        super(parameters);
        this.localHostName = localHostName;
        this.originalModel = originalDomainModel;
        this.parameters = parameters;
    }

    @Override
    Transformers.ResourceIgnoredTransformationRegistry createRegistry(OperationContext context, Resource remote, Set<String> remoteExtensions) {
        ReadMasterDomainModelUtil.RequiredConfigurationHolder rc = new ReadMasterDomainModelUtil.RequiredConfigurationHolder();
        PathElement host = PathElement.pathElement((String)"host", (String)this.localHostName);
        Resource hostModel = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{host}));
        Resource original = this.originalModel;
        ReadMasterDomainModelUtil.processHostModel(rc, remote, hostModel, this.parameters.getExtensionRegistry());
        ReadMasterDomainModelUtil.processHostModel(rc, original, original.getChild(host), this.parameters.getExtensionRegistry());
        Transformers.ResourceIgnoredTransformationRegistry delegate = new Transformers.ResourceIgnoredTransformationRegistry(){

            public boolean isResourceTransformationIgnored(PathAddress address) {
                return SyncServerGroupOperationHandler.this.parameters.getIgnoredResourceRegistry().isResourceExcluded(address);
            }
        };
        return ReadMasterDomainModelUtil.createServerIgnoredRegistry(rc, true, delegate);
    }
}

