/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostControllerConfigurationPersister;
import org.jboss.as.host.controller.discovery.StaticDiscovery;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.model.host.AdminOnlyDomainConfigPolicy;
import org.jboss.as.host.controller.model.host.HostResourceDefinition;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.remoting.Protocol;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.security.auth.client.AuthenticationContext;

public abstract class DomainControllerWriteAttributeHandler
extends ReloadRequiredWriteAttributeHandler {
    public static final SimpleAttributeDefinition AUTHENTICATION_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-context", ModelType.STRING, true).setCapabilityReference("org.wildfly.security.authentication-context", "org.wildfly.host.controller")).setAlternatives(new String[]{"security-realm", "username"})).build();
    public static final SimpleAttributeDefinition PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("port", ModelType.INT).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1, 65535, true, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setRequires(new String[]{"host"})).build();
    public static final SimpleAttributeDefinition USERNAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("username", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM})).setAlternatives(new String[]{"authentication-context"})).setDeprecated(ModelVersion.create((int)5))).build();
    public static final SimpleAttributeDefinition ADMIN_ONLY_POLICY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("admin-only-policy", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM})).setValidator((ParameterValidator)new EnumValidator(AdminOnlyDomainConfigPolicy.class, true, true))).setDefaultValue(new ModelNode(AdminOnlyDomainConfigPolicy.ALLOW_NO_CONFIG.toString()))).build();
    public static final SimpleAttributeDefinition IGNORE_UNUSED_CONFIG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ignore-unused-configuration", ModelType.BOOLEAN, true).setRequired(false)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM})).build();
    public static final SimpleAttributeDefinition HOST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("host", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setRequires(new String[]{"port"})).build();
    public static final SimpleAttributeDefinition PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("protocol", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new EnumValidator(Protocol.class, true, true))).setDefaultValue(Protocol.REMOTE.toModelNode())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setRequires(new String[]{"host", "port"})).build();

    public static DomainControllerWriteAttributeHandler getInstance(ManagementResourceRegistration rootRegistration, LocalHostControllerInfoImpl hostControllerInfo, HostControllerConfigurationPersister overallConfigPersister, HostFileRepository localFileRepository, HostFileRepository remoteFileRepository, ContentRepository contentRepository, DomainController domainController, ExtensionRegistry extensionRegistry, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, PathManagerService pathManager) {
        return new RealLocalDomainControllerAddHandler(rootRegistration, hostControllerInfo, overallConfigPersister, localFileRepository, remoteFileRepository, contentRepository, domainController, extensionRegistry, ignoredDomainResourceRegistry, pathManager);
    }

    public static DomainControllerWriteAttributeHandler getTestInstance() {
        return new TestLocalDomainControllerAddHandler();
    }

    private DomainControllerWriteAttributeHandler() {
        super(new AttributeDefinition[]{HostResourceDefinition.DOMAIN_CONTROLLER});
    }

    protected boolean requiresRuntime(OperationContext context) {
        return !context.isBooting();
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        super.execute(context, operation);
        ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        ModelNode dc = model.get("domain-controller");
        if (operation.hasDefined(new String[]{"value", "local"})) {
            dc.get("local").setEmptyObject();
            if (dc.has("remote")) {
                dc.remove("remote");
            }
            if (context.isBooting()) {
                this.initializeLocalDomain(null);
            }
        } else if (operation.hasDefined(new String[]{"value", "remote"})) {
            if (dc.has("local")) {
                dc.remove("local");
            }
            ModelNode remoteDC = dc.get("remote");
            this.secureRemoteDomain(context, operation, remoteDC);
            if (context.isBooting()) {
                this.initializeRemoteDomain(context, remoteDC);
            }
        }
    }

    abstract void initializeLocalDomain(String var1);

    abstract void secureRemoteDomain(OperationContext var1, ModelNode var2, ModelNode var3) throws OperationFailedException;

    abstract void initializeRemoteDomain(OperationContext var1, ModelNode var2) throws OperationFailedException;

    private static class TestLocalDomainControllerAddHandler
    extends DomainControllerWriteAttributeHandler {
        private TestLocalDomainControllerAddHandler() {
        }

        @Override
        void initializeLocalDomain(String hostName) {
        }

        @Override
        void initializeRemoteDomain(OperationContext context, ModelNode remoteDC) throws OperationFailedException {
        }

        @Override
        void secureRemoteDomain(OperationContext context, ModelNode operation, ModelNode remoteDC) throws OperationFailedException {
        }
    }

    private static class RealLocalDomainControllerAddHandler
    extends DomainControllerWriteAttributeHandler {
        private final ManagementResourceRegistration rootRegistration;
        private final HostControllerConfigurationPersister overallConfigPersister;
        private final LocalHostControllerInfoImpl hostControllerInfo;
        private final ContentRepository contentRepository;
        private final DomainController domainController;
        private final ExtensionRegistry extensionRegistry;
        private final PathManagerService pathManager;
        private final IgnoredDomainResourceRegistry ignoredDomainResourceRegistry;
        private final HostFileRepository localFileRepository;
        private final HostFileRepository remoteFileRepository;

        private RealLocalDomainControllerAddHandler(ManagementResourceRegistration rootRegistration, LocalHostControllerInfoImpl hostControllerInfo, HostControllerConfigurationPersister overallConfigPersister, HostFileRepository localFileRepository, HostFileRepository remoteFileRepository, ContentRepository contentRepository, DomainController domainController, ExtensionRegistry extensionRegistry, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, PathManagerService pathManager) {
            this.rootRegistration = rootRegistration;
            this.overallConfigPersister = overallConfigPersister;
            this.localFileRepository = localFileRepository;
            this.remoteFileRepository = remoteFileRepository;
            this.hostControllerInfo = hostControllerInfo;
            this.contentRepository = contentRepository;
            this.domainController = domainController;
            this.extensionRegistry = extensionRegistry;
            this.ignoredDomainResourceRegistry = ignoredDomainResourceRegistry;
            this.pathManager = pathManager;
        }

        @Override
        void initializeLocalDomain(String localHostNameOverride) {
            this.hostControllerInfo.setMasterDomainController(true);
            if (localHostNameOverride != null) {
                this.hostControllerInfo.setLocalHostName(localHostNameOverride);
            }
            if (localHostNameOverride == null) {
                this.overallConfigPersister.initializeDomainConfigurationPersister(false);
            }
            this.domainController.initializeMasterDomainRegistry(this.rootRegistration, localHostNameOverride == null ? this.overallConfigPersister.getDomainPersister() : null, this.contentRepository, this.localFileRepository, this.extensionRegistry, this.pathManager);
        }

        @Override
        void initializeRemoteDomain(OperationContext context, ModelNode remoteDC) throws OperationFailedException {
            ModelNode ignoreUnusedConfiguration;
            ModelNode usernameNode;
            this.hostControllerInfo.setMasterDomainController(false);
            ModelNode protocolNode = PROTOCOL.resolveModelAttribute(context, remoteDC);
            ModelNode hostNode = HOST.resolveModelAttribute(context, remoteDC);
            ModelNode portNode = PORT.resolveModelAttribute(context, remoteDC);
            if (hostNode.isDefined() && portNode.isDefined()) {
                String host = hostNode.asString();
                int port = portNode.asInt();
                String protocol = protocolNode.asString();
                StaticDiscovery staticDiscoveryOption = new StaticDiscovery(protocol, host, port);
                this.hostControllerInfo.addRemoteDomainControllerDiscoveryOption(staticDiscoveryOption);
            }
            if ((usernameNode = USERNAME.resolveModelAttribute(context, remoteDC)).isDefined()) {
                this.hostControllerInfo.setRemoteDomainControllerUsername(usernameNode.asString());
            }
            if (!(ignoreUnusedConfiguration = IGNORE_UNUSED_CONFIG.resolveModelAttribute(context, remoteDC)).isDefined()) {
                if (this.hostControllerInfo.isBackupDc()) {
                    this.hostControllerInfo.setRemoteDomainControllerIgnoreUnaffectedConfiguration(false);
                } else {
                    this.hostControllerInfo.setRemoteDomainControllerIgnoreUnaffectedConfiguration(true);
                }
            } else {
                this.hostControllerInfo.setRemoteDomainControllerIgnoreUnaffectedConfiguration(ignoreUnusedConfiguration.asBoolean());
            }
            AdminOnlyDomainConfigPolicy domainConfigPolicy = AdminOnlyDomainConfigPolicy.getPolicy(ADMIN_ONLY_POLICY.resolveModelAttribute(context, remoteDC).asString());
            this.hostControllerInfo.setAdminOnlyDomainConfigPolicy(domainConfigPolicy);
            this.overallConfigPersister.initializeDomainConfigurationPersister(true);
            this.domainController.initializeSlaveDomainRegistry(this.rootRegistration, this.overallConfigPersister.getDomainPersister(), this.contentRepository, this.remoteFileRepository, this.hostControllerInfo, this.extensionRegistry, this.ignoredDomainResourceRegistry, this.pathManager);
        }

        @Override
        void secureRemoteDomain(OperationContext context, ModelNode operation, ModelNode remoteDC) throws OperationFailedException {
            ModelNode parameters = operation.get(new String[]{"value", "remote"});
            if (parameters.has(AUTHENTICATION_CONTEXT.getName())) {
                AUTHENTICATION_CONTEXT.validateAndSet(parameters, remoteDC);
                final String authenticationContext = AUTHENTICATION_CONTEXT.resolveModelAttribute(context, parameters).asString();
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        hostControllerInfo.setAuthenticationContext(context.getCapabilityServiceName("org.wildfly.security.authentication-context", authenticationContext, AuthenticationContext.class));
                    }
                }, OperationContext.Stage.RUNTIME);
            } else {
                remoteDC.get(AUTHENTICATION_CONTEXT.getName()).clear();
            }
        }
    }
}

