/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.model.jvm;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.model.jvm.JvmType;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JvmAttributes {
    public static final String JVM_AGENT_LIB = "agent-lib";
    public static final String JVM_AGENT_PATH = "agent-path";
    public static final String JVM_DEBUG_ENABLED = "debug-enabled";
    public static final String JVM_DEBUG_OPTIONS = "debug-options";
    public static final String JVM_ENV_CLASSPATH_IGNORED = "env-classpath-ignored";
    public static final String JVM_ENV_VARIABLES = "environment-variables";
    public static final String JVM_HEAP = "heap-size";
    public static final String JVM_MAX_HEAP = "max-heap-size";
    public static final String JVM_JAVA_AGENT = "java-agent";
    public static final String JVM_JAVA_HOME = "java-home";
    public static final String JVM_LAUNCH_COMMAND = "launch-command";
    public static final String JVM_OPTIONS = "jvm-options";
    public static final String JVM_OPTION = "jvm-option";
    public static final String JVM_PERMGEN = "permgen-size";
    public static final String LAUNUCH_PREFIX = "prefix";
    public static final String JVM_MAX_PERMGEN = "max-permgen-size";
    public static final String JVM_STACK = "stack-size";
    public static final String JVM_TYPE = "type";
    public static final String SIZE = "size";
    public static final String VALUE = "value";
    public static final String MAX_SIZE = "max-size";
    public static final SimpleAttributeDefinition AGENT_LIB = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"agent-lib", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setXmlName("value")).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.JVM)).build();
    public static final SimpleAttributeDefinition AGENT_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"agent-path", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setXmlName("value")).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.JVM)).build();
    public static final SimpleAttributeDefinition ENV_CLASSPATH_IGNORED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"env-classpath-ignored", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.JVM)).build();
    public static final PropertiesAttributeDefinition ENVIRONMENT_VARIABLES = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("environment-variables", true).setXmlName(Element.VARIABLE.getLocalName()).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, true, true))).setWrapperElement("environment-variables").addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.JVM)).build();
    public static final SimpleAttributeDefinition JAVA_AGENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"java-agent", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setXmlName("value")).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.JVM)).build();
    public static final SimpleAttributeDefinition JAVA_HOME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"java-home", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.JVM)).build();
    public static final SimpleAttributeDefinition LAUNCH_COMMAND = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"launch-command", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setXmlName("launch-command")).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.JVM)).build();
    public static final AttributeDefinition MODULE_OPTIONS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("module-options").setElementValidator((ParameterValidator)new ModuleOptionsValidator())).setRequired(false)).setAllowExpression(true)).setAttributeMarshaller(new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            List list;
            if (resourceModel.hasDefined(attribute.getName()) && !(list = resourceModel.get(attribute.getName()).asList()).isEmpty()) {
                writer.writeStartElement(attribute.getName());
                for (ModelNode child : list) {
                    writer.writeEmptyElement(Element.OPTION.getLocalName());
                    writer.writeAttribute(JvmAttributes.VALUE, child.asString());
                }
                writer.writeEndElement();
            }
        }
    })).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.JVM)).build();
    public static final AttributeDefinition OPTIONS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("jvm-options").setElementValidator((ParameterValidator)new StringLengthValidator(1, true, true))).setRequired(false)).setAllowExpression(true)).setAttributeMarshaller(new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            List list;
            if (resourceModel.hasDefined(attribute.getName()) && (list = resourceModel.get(attribute.getName()).asList()).size() > 0) {
                writer.writeStartElement(attribute.getName());
                for (ModelNode child : list) {
                    writer.writeEmptyElement(Element.OPTION.getLocalName());
                    writer.writeAttribute(JvmAttributes.VALUE, child.asString());
                }
                writer.writeEndElement();
            }
        }
    })).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.JVM)).build();
    public static final SimpleAttributeDefinition STACK_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"stack-size", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setXmlName("size")).build();
    public static final SimpleAttributeDefinition TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"type", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setValidator((ParameterValidator)new EnumValidator(JvmType.class, EnumSet.allOf(JvmType.class)))).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.JVM)).build();
    public static final SimpleAttributeDefinition HEAP_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"heap-size", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setXmlName("size")).build();
    public static final SimpleAttributeDefinition MAX_HEAP_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-heap-size", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setXmlName("max-size")).build();
    public static final SimpleAttributeDefinition PERMGEN_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"permgen-size", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setXmlName("size")).setDeprecated(ModelVersion.create((int)4))).build();
    public static final SimpleAttributeDefinition MAX_PERMGEN_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-permgen-size", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setXmlName("max-size")).setDeprecated(ModelVersion.create((int)4))).build();
    public static final SimpleAttributeDefinition DEBUG_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"debug-enabled", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(false)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.JVM)).build();
    public static final SimpleAttributeDefinition DEBUG_OPTIONS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"debug-options", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.JVM)).build();
    public static final SimpleAttributeDefinition PREFIX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"launch-command", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setXmlName("prefix")).build();
    private static final AttributeDefinition[] GLOBAL_ATTRIBUTES = new AttributeDefinition[]{AGENT_LIB, AGENT_PATH, ENV_CLASSPATH_IGNORED, ENVIRONMENT_VARIABLES, JAVA_AGENT, JAVA_HOME, LAUNCH_COMMAND, MODULE_OPTIONS, OPTIONS, STACK_SIZE, TYPE, HEAP_SIZE, MAX_HEAP_SIZE, PERMGEN_SIZE, MAX_PERMGEN_SIZE};
    private static final AttributeDefinition[] SERVER_ATTRIBUTES = new AttributeDefinition[]{AGENT_LIB, AGENT_PATH, ENV_CLASSPATH_IGNORED, ENVIRONMENT_VARIABLES, JAVA_AGENT, JAVA_HOME, LAUNCH_COMMAND, MODULE_OPTIONS, OPTIONS, STACK_SIZE, TYPE, HEAP_SIZE, MAX_HEAP_SIZE, PERMGEN_SIZE, MAX_PERMGEN_SIZE, DEBUG_ENABLED, DEBUG_OPTIONS};

    static AttributeDefinition[] getAttributes(boolean server) {
        return server ? SERVER_ATTRIBUTES : GLOBAL_ATTRIBUTES;
    }

    private static class ModuleOptionsValidator
    extends StringLengthValidator {
        private final List<String> valuesNotAllowed = Arrays.asList("-mp", "--modulepath", "-secmgr");

        public ModuleOptionsValidator() {
            super(1, true, true);
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            String option = value.asString();
            if (this.valuesNotAllowed.contains(option)) {
                throw HostControllerLogger.ROOT_LOGGER.moduleOptionNotAllowed(option);
            }
        }
    }
}

