/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.nio.file.Path;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.operations.common.ProcessEnvironment;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.GlobalInstallationReportHandler;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.server.operations.AbstractInstallationReporter;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class InstallationReportHandler
extends AbstractInstallationReporter {
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("report", HostResolver.getResolver("host")).setRuntimeOnly().setReadOnly().addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG).withFlags(new OperationEntry.Flag[]{OperationEntry.Flag.DOMAIN_PUSH_TO_SERVERS, OperationEntry.Flag.HIDDEN}).setReplyType(ModelType.OBJECT).setReplyParameters(new AttributeDefinition[]{GlobalInstallationReportHandler.SUMMARY_DEFINITION}).build();
    private final HostControllerEnvironment environment;

    public static InstallationReportHandler createOperation(HostControllerEnvironment environment) {
        return new InstallationReportHandler(environment);
    }

    private InstallationReportHandler(HostControllerEnvironment environment) {
        this.environment = environment;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final ModelNode patchingInfo = new ModelNode();
        PathAddress patchingAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)this.environment.getHostControllerName()), PathElement.pathElement((String)"core-service", (String)"patching")});
        OperationEntry opEntry = context.getRootResourceRegistration().getOperationEntry(patchingAddress, "show-history");
        if (opEntry != null) {
            context.addStep(patchingInfo, Util.createOperation((String)"show-history", (PathAddress)patchingAddress), opEntry.getOperationHandler(), OperationContext.Stage.RUNTIME);
        }
        final Path installationDir = this.environment.getHomeDir().toPath();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode result = context.getResult();
                result.get(GlobalInstallationReportHandler.SUMMARY_DEFINITION.getName()).set(InstallationReportHandler.this.createProductNode(context, new AbstractInstallationReporter.InstallationConfiguration((ProcessEnvironment)InstallationReportHandler.this.environment, InstallationReportHandler.this.environment.getProductConfig(), patchingInfo, installationDir)));
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

