/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.plan.AbstractServerGroupRolloutTask;
import org.jboss.as.domain.controller.plan.ServerTaskExecutor;
import org.jboss.as.domain.controller.plan.ServerUpdatePolicy;
import org.jboss.as.domain.controller.plan.ServerUpdateTask;

class RollingServerGroupUpdateTask
extends AbstractServerGroupRolloutTask
implements Runnable {
    public RollingServerGroupUpdateTask(List<ServerUpdateTask> tasks, ServerUpdatePolicy updatePolicy, ServerTaskExecutor executor, Subject subject) {
        super(tasks, updatePolicy, executor, subject);
    }

    @Override
    public void execute() {
        boolean interrupted = false;
        ServerTaskExecutor.ServerOperationListener listener = new ServerTaskExecutor.ServerOperationListener();
        for (ServerUpdateTask task : this.tasks) {
            ServerIdentity identity = task.getServerIdentity();
            if (interrupted || !this.updatePolicy.canUpdateServer(identity)) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Skipping server update task for %s", identity);
                continue;
            }
            if (!this.executor.executeTask((TransactionalProtocolClient.TransactionalOperationListener<ServerTaskExecutor.ServerOperation>)listener, task)) continue;
            try {
                TransactionalProtocolClient.PreparedOperation prepared = listener.retrievePreparedOperation();
                this.recordPreparedOperation(identity, (TransactionalProtocolClient.PreparedOperation<ServerTaskExecutor.ServerOperation>)prepared);
            }
            catch (InterruptedException e) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.interruptedAwaitingPreparedResponse(this.getClass().getSimpleName(), Collections.singleton(identity));
                this.executor.cancelTask(identity);
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

