/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.EnumSet;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.operations.ServerStartHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServerStopHandler
implements OperationStepHandler {
    private static final SimpleAttributeDefinition TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("timeout", ModelType.INT).setDefaultValue(new ModelNode(0))).setAllowNull(true)).build();
    public static final String OPERATION_NAME = "stop";
    public static final OperationDefinition DEFINITION = ServerStartHandler.getOperationDefinition("stop", new AttributeDefinition[]{TIMEOUT});
    private final ServerInventory serverInventory;

    public ServerStopHandler(ServerInventory serverInventory) {
        this.serverInventory = serverInventory;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathElement element = address.getLastElement();
        final String serverName = element.getValue();
        final boolean blocking = operation.get("blocking").asBoolean(false);
        final int timeout = TIMEOUT.resolveModelAttribute(context, operation).asInt();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.authorize(operation, EnumSet.of(Action.ActionEffect.WRITE_RUNTIME));
                ServerStatus status = ServerStopHandler.this.serverInventory.stopServer(serverName, timeout, blocking);
                context.readResource(PathAddress.EMPTY_ADDRESS, false);
                context.getResult().set(status.toString());
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

