/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLHandshakeException;
import javax.security.sasl.SaslException;
import org.jboss.as.controller.CurrentOperationIdHolder;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.impl.ExistingChannelModelControllerClient;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.remote.RemoteProxyController;
import org.jboss.as.controller.remote.TransactionalProtocolOperationHandler;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.SlaveRegistrationException;
import org.jboss.as.domain.controller.operations.ApplyMissingDomainModelResourcesHandler;
import org.jboss.as.domain.controller.operations.PullDownDataForServerConfigOnSlaveHandler;
import org.jboss.as.domain.controller.operations.coordination.DomainControllerLockIdUtils;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.IgnoredNonAffectedServerGroupsUtil;
import org.jboss.as.host.controller.MasterDomainControllerClient;
import org.jboss.as.host.controller.ReconnectPolicy;
import org.jboss.as.host.controller.RemoteDomainConnection;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.ServerInventoryService;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.mgmt.DomainRemoteFileRequestAndHandler;
import org.jboss.as.host.controller.mgmt.HostControllerRegistrationHandler;
import org.jboss.as.host.controller.mgmt.HostInfo;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.repository.RemoteFileRequestAndHandler;
import org.jboss.as.version.ProductConfig;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.GetAccessControlContextAction;
import org.xnio.OptionMap;
import org.xnio.Options;

public class RemoteDomainConnectionService
implements MasterDomainControllerClient,
Service<MasterDomainControllerClient> {
    public static final String DOMAIN_CONNECTION_ID = "domain-connection-id";
    private static final int CONNECTION_TIMEOUT_DEFAULT = 30000;
    private static final String CONNECTION_TIMEOUT_PROPERTY = "jboss.host.domain.connection.timeout";
    private static final int CONNECTION_TIMEOUT = RemoteDomainConnectionService.getSystemProperty("jboss.host.domain.connection.timeout", 30000);
    private static final ModelNode APPLY_EXTENSIONS = new ModelNode();
    private static final ModelNode APPLY_DOMAIN_MODEL = new ModelNode();
    private final ExtensionRegistry extensionRegistry;
    private final ModelController controller;
    private final ProductConfig productConfig;
    private final LocalHostControllerInfo localHostInfo;
    private final RemoteFileRepository remoteFileRepository;
    private final IgnoredDomainResourceRegistry ignoredDomainResourceRegistry;
    private final HostControllerRegistrationHandler.OperationExecutor operationExecutor;
    private final DomainController domainController;
    private final HostControllerEnvironment hostControllerEnvironment;
    private final RunningMode runningMode;
    private final File tempDir;
    private volatile ModelControllerClient masterProxy;
    private volatile TransactionalDomainControllerClient txMasterProxy;
    private final FutureClient futureClient = new FutureClient();
    private final InjectedValue<Endpoint> endpointInjector = new InjectedValue();
    private final InjectedValue<SecurityRealm> securityRealmInjector = new InjectedValue();
    private final InjectedValue<ServerInventory> serverInventoryInjector = new InjectedValue();
    private final ExecutorService executor;
    private ScheduledExecutorService scheduledExecutorService;
    private ManagementChannelHandler handler;
    private volatile RemoteDomainConnection connection;
    private final RemoteFileRepositoryExecutor remoteFileRepositoryExecutor = new RemoteFileRepositoryExecutor(){

        @Override
        public File getFile(String relativePath, byte repoId, HostFileRepository localFileRepository) {
            if (RemoteDomainConnectionService.this.connection.isConnected()) {
                try {
                    return (File)RemoteDomainConnectionService.this.handler.executeRequest((ManagementRequest)new GetFileRequest(repoId, relativePath, localFileRepository), null).getResult().get();
                }
                catch (Exception e) {
                    throw HostControllerLogger.ROOT_LOGGER.failedToGetFileFromRemoteRepository(e);
                }
            }
            return localFileRepository.getFile(relativePath);
        }
    };

    private RemoteDomainConnectionService(ModelController controller, ExtensionRegistry extensionRegistry, LocalHostControllerInfo localHostControllerInfo, ProductConfig productConfig, RemoteFileRepository remoteFileRepository, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, HostControllerRegistrationHandler.OperationExecutor operationExecutor, DomainController domainController, HostControllerEnvironment hostControllerEnvironment, ExecutorService executor, RunningMode runningMode) {
        this.controller = controller;
        this.extensionRegistry = extensionRegistry;
        this.productConfig = productConfig;
        this.localHostInfo = localHostControllerInfo;
        this.remoteFileRepository = remoteFileRepository;
        remoteFileRepository.setRemoteFileRepositoryExecutor(this.remoteFileRepositoryExecutor);
        this.ignoredDomainResourceRegistry = ignoredDomainResourceRegistry;
        this.operationExecutor = operationExecutor;
        this.domainController = domainController;
        this.hostControllerEnvironment = hostControllerEnvironment;
        this.executor = executor;
        this.runningMode = runningMode;
        this.tempDir = hostControllerEnvironment.getDomainTempDir();
    }

    public static Future<MasterDomainControllerClient> install(ServiceTarget serviceTarget, ModelController controller, ExtensionRegistry extensionRegistry, LocalHostControllerInfo localHostControllerInfo, ProductConfig productConfig, String securityRealm, RemoteFileRepository remoteFileRepository, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, HostControllerRegistrationHandler.OperationExecutor operationExecutor, DomainController domainController, HostControllerEnvironment hostControllerEnvironment, ExecutorService executor, RunningMode currentRunningMode) {
        RemoteDomainConnectionService service = new RemoteDomainConnectionService(controller, extensionRegistry, localHostControllerInfo, productConfig, remoteFileRepository, ignoredDomainResourceRegistry, operationExecutor, domainController, hostControllerEnvironment, executor, currentRunningMode);
        ServiceBuilder builder = serviceTarget.addService(MasterDomainControllerClient.SERVICE_NAME, (Service)service).addDependency(ManagementRemotingServices.MANAGEMENT_ENDPOINT, Endpoint.class, service.endpointInjector).addDependency(ServerInventoryService.SERVICE_NAME, ServerInventory.class, service.serverInventoryInjector).setInitialMode(ServiceController.Mode.ACTIVE);
        if (securityRealm != null) {
            SecurityRealm.ServiceUtil.addDependency((ServiceBuilder)builder, service.securityRealmInjector, (String)securityRealm, (boolean)false);
        }
        builder.install();
        return service.futureClient;
    }

    @Override
    public synchronized void register() throws IOException {
        boolean connected = false;
        List<DiscoveryOption> discoveryOptions = this.localHostInfo.getRemoteDomainControllerDiscoveryOptions();
        Iterator<DiscoveryOption> i = discoveryOptions.iterator();
        while (i.hasNext()) {
            DiscoveryOption discoveryOption = i.next();
            long timeout = CONNECTION_TIMEOUT;
            long endTime = System.currentTimeMillis() + timeout;
            int retries = 0;
            URI masterURI = null;
            try {
                discoveryOption.discover();
                String host = discoveryOption.getRemoteDomainControllerHost();
                int port = discoveryOption.getRemoteDomainControllerPort();
                masterURI = new URI("remote://" + NetworkUtils.formatPossibleIpv6Address((String)host) + ":" + port);
                this.connection.setUri(masterURI);
                while (!connected) {
                    try {
                        this.connection.connect();
                        connected = true;
                    }
                    catch (IOException e) {
                        RemoteDomainConnectionService.rethrowIrrecoverableConnectionFailures(e);
                        HostControllerLogger.ROOT_LOGGER.cannotConnect(masterURI, e);
                        if (System.currentTimeMillis() > endTime) {
                            throw HostControllerLogger.ROOT_LOGGER.connectionToMasterTimeout(e, retries, timeout);
                        }
                        try {
                            ReconnectPolicy.CONNECT.wait(retries);
                            ++retries;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            throw HostControllerLogger.ROOT_LOGGER.connectionToMasterInterrupted();
                        }
                    }
                }
                HostControllerLogger.ROOT_LOGGER.connectedToMaster(masterURI);
                this.handler.addHandlerFactory((ManagementRequestHandlerFactory)new TransactionalProtocolOperationHandler(this.controller, (ManagementChannelAssociation)this.handler));
                this.masterProxy = ExistingChannelModelControllerClient.createAndAdd((ManagementChannelHandler)this.handler);
                this.txMasterProxy = new TransactionalDomainControllerClient(this.handler);
                break;
            }
            catch (Exception e) {
                boolean moreOptions = i.hasNext();
                RemoteDomainConnectionService.logConnectionException(masterURI, discoveryOption, moreOptions, e);
                if (moreOptions) continue;
                throw HostControllerLogger.ROOT_LOGGER.discoveryOptionsFailureUnableToConnect(e);
            }
        }
    }

    @Override
    public synchronized void unregister() {
        StreamUtils.safeClose((Closeable)((Object)this.connection));
    }

    @Override
    public void fetchDomainWideConfiguration() {
        try {
            throw new UnsupportedOperationException();
        }
        catch (Throwable throwable) {
            StreamUtils.safeClose((Closeable)((Object)this.connection));
            throw throwable;
        }
    }

    @Override
    public synchronized HostFileRepository getRemoteFileRepository() {
        return this.remoteFileRepository;
    }

    public ModelNode execute(ModelNode operation) throws IOException {
        return this.execute(operation, OperationMessageHandler.logging);
    }

    public ModelNode execute(Operation operation) throws IOException {
        return this.masterProxy.execute(operation, OperationMessageHandler.logging);
    }

    public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
        return this.masterProxy.execute(operation, messageHandler);
    }

    public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        return this.masterProxy.execute(operation, messageHandler);
    }

    public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
        return this.masterProxy.executeAsync(operation, messageHandler);
    }

    public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
        return this.masterProxy.executeAsync(operation, messageHandler);
    }

    @Override
    public void pullDownDataForUpdatedServerConfigAndApplyToModel(OperationContext context, String serverName, String serverGroupName, String socketBindingGroupName) throws OperationFailedException {
        ModelNode op = new ModelNode();
        op.get("operation").set(PullDownDataForServerConfigOnSlaveHandler.OPERATION_NAME);
        op.get("address").setEmptyList();
        op.get("server").set(IgnoredNonAffectedServerGroupsUtil.createServerConfigInfo(serverName, serverGroupName, socketBindingGroupName).toModelNode());
        Integer domainControllerLock = (Integer)context.getAttachment(DomainControllerLockIdUtils.DOMAIN_CONTROLLER_LOCK_ID_ATTACHMENT);
        if (domainControllerLock != null) {
            op.get(new String[]{"operation-headers", "domain-controller-lock-id"}).set(domainControllerLock.intValue());
        }
        op.get(new String[]{"operation-headers", "slave-controller-lock-id"}).set(CurrentOperationIdHolder.getCurrentOperationID().intValue());
        ModelNode result = this.txMasterProxy.executeTransactional(context, op);
        if (result.get("failure-description").isDefined()) {
            throw new OperationFailedException(result.get("failure-description").asString());
        }
        ApplyMissingDomainModelResourcesHandler applyMissingDomainModelResourcesHandler = new ApplyMissingDomainModelResourcesHandler(this.domainController, this.hostControllerEnvironment, this.localHostInfo, this.ignoredDomainResourceRegistry);
        ModelNode applyMissingResourcesOp = ApplyMissingDomainModelResourcesHandler.createPulledMissingDataOperation(result.get("result"));
        context.addStep(applyMissingResourcesOp, (OperationStepHandler)applyMissingDomainModelResourcesHandler, OperationContext.Stage.MODEL, true);
    }

    public void close() throws IOException {
        throw HostControllerLogger.ROOT_LOGGER.closeShouldBeManagedByService();
    }

    public synchronized void start(StartContext context) throws StartException {
        ManagementChannelHandler handler;
        RemoteDomainConnection connection;
        try {
            JBossThreadFactory scheduledThreadFactory = new JBossThreadFactory(new ThreadGroup("domain-connection-pinger-threads"), Boolean.TRUE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)scheduledThreadFactory);
            ModelNode hostInfo = HostInfo.createLocalHostHostInfo(this.localHostInfo, this.productConfig, this.ignoredDomainResourceRegistry, (Resource)ReadRootResourceHandler.grabDomainResource(this.operationExecutor).getChildren("host").iterator().next());
            OptionMap options = OptionMap.builder().set(RemotingOptions.HEARTBEAT_INTERVAL, 15000).set(Options.READ_TIMEOUT, 45000).set(RemotingOptions.RECEIVE_WINDOW_SIZE, 32768).getMap();
            ProtocolChannelClient.Configuration configuration = new ProtocolChannelClient.Configuration();
            configuration.setEndpoint((Endpoint)this.endpointInjector.getValue());
            configuration.setOptionMap(options);
            SecurityRealm realm = (SecurityRealm)this.securityRealmInjector.getOptionalValue();
            connection = new RemoteDomainConnection(this.localHostInfo.getLocalHostName(), hostInfo, configuration, realm, this.localHostInfo.getRemoteDomainControllerUsername(), this.localHostInfo.getRemoteDomainControllerDiscoveryOptions(), this.executor, this.scheduledExecutorService, new RemoteDomainConnection.HostRegistrationCallback(){

                @Override
                public ModelNode resolveSubsystemVersions(ModelNode extensions) {
                    return RemoteDomainConnectionService.this.resolveSubsystems(extensions.asList());
                }

                @Override
                public boolean applyDomainModel(List<ModelNode> bootOperations) {
                    return RemoteDomainConnectionService.this.applyRemoteDomainModel(bootOperations);
                }

                @Override
                public void registrationComplete(ManagementChannelHandler handler) {
                }
            }, this.runningMode);
            handler = connection.getChannelHandler();
            handler.getAttachments().attach(ManagementChannelHandler.TEMP_DIR, (Object)this.tempDir);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        finally {
            this.futureClient.setClient(this);
        }
        this.connection = connection;
        this.handler = handler;
    }

    private ModelNode resolveSubsystems(List<ModelNode> extensions) {
        ArrayList<ModelNode> bootOperations = new ArrayList<ModelNode>();
        for (ModelNode extension : extensions) {
            ModelNode e = new ModelNode();
            e.get("domain-resource-address").add("extension", extension.asString());
            bootOperations.add(e);
        }
        ModelNode operation = APPLY_EXTENSIONS.clone();
        operation.get("domain-model").set(bootOperations);
        ModelNode result = this.controller.execute(operation, OperationMessageHandler.logging, ModelController.OperationTransactionControl.COMMIT, OperationAttachments.EMPTY);
        if (!"success".equals(result.get("outcome").asString())) {
            throw HostControllerLogger.ROOT_LOGGER.failedToAddExtensions(result.get("failure-description"));
        }
        ModelNode subsystems = new ModelNode();
        for (ModelNode extension : extensions) {
            this.extensionRegistry.recordSubsystemVersions(extension.asString(), subsystems);
        }
        return subsystems;
    }

    private boolean applyRemoteDomainModel(List<ModelNode> bootOperations) {
        ModelNode result;
        try {
            ModelNode operation = APPLY_DOMAIN_MODEL.clone();
            operation.get("domain-model").set(bootOperations);
            result = this.controller.execute(operation, OperationMessageHandler.logging, ModelController.OperationTransactionControl.COMMIT, OperationAttachments.EMPTY);
        }
        catch (Exception e) {
            HostControllerLogger.DOMAIN_LOGGER.failedToApplyDomainConfig(e);
            return false;
        }
        String outcome = result.get("outcome").asString();
        boolean success = "success".equals(outcome);
        if (!success) {
            ModelNode failureDesc = result.hasDefined("failure-description") ? result.get("failure-description") : new ModelNode();
            HostControllerLogger.DOMAIN_LOGGER.failedToApplyDomainConfig(outcome, failureDesc);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(final StopContext context) {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    StreamUtils.safeClose((Closeable)((Object)RemoteDomainConnectionService.this.connection));
                    RemoteDomainConnectionService.this.scheduledExecutorService.shutdownNow();
                }
                finally {
                    context.complete();
                }
            }
        };
        try {
            this.executor.execute(r);
        }
        catch (RejectedExecutionException e) {
            r.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public synchronized MasterDomainControllerClient getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    static void rethrowIrrecoverableConnectionFailures(IOException e) throws SlaveRegistrationException {
        Throwable cause = e;
        while ((cause = cause.getCause()) != null) {
            if (cause instanceof SaslException) {
                throw HostControllerLogger.ROOT_LOGGER.authenticationFailureUnableToConnect(cause);
            }
            if (cause instanceof SSLHandshakeException) {
                throw HostControllerLogger.ROOT_LOGGER.sslFailureUnableToConnect(cause);
            }
            if (!(cause instanceof SlaveRegistrationException)) continue;
            throw (SlaveRegistrationException)cause;
        }
    }

    static void logConnectionException(URI uri, DiscoveryOption discoveryOption, boolean moreOptions, Exception e) {
        if (uri == null) {
            HostControllerLogger.ROOT_LOGGER.failedDiscoveringMaster(discoveryOption, e);
        } else {
            HostControllerLogger.ROOT_LOGGER.cannotConnect(uri, e);
        }
        if (!moreOptions) {
            HostControllerLogger.ROOT_LOGGER.noDiscoveryOptionsLeft();
        }
    }

    private static int getSystemProperty(String name, int defaultValue) {
        String value = WildFlySecurityManager.getPropertyPrivileged((String)name, null);
        try {
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    static {
        APPLY_EXTENSIONS.get("operation").set("resolve-subsystems");
        APPLY_EXTENSIONS.get(new String[]{"operation-headers", "execute-for-coordinator"}).set(true);
        APPLY_EXTENSIONS.get("address").setEmptyList();
        APPLY_EXTENSIONS.protect();
        APPLY_DOMAIN_MODEL.get("operation").set("apply-remote-domain-model");
        APPLY_DOMAIN_MODEL.get(new String[]{"operation-headers", "execute-for-coordinator"}).set(true);
        APPLY_DOMAIN_MODEL.get("address").setEmptyList();
        APPLY_DOMAIN_MODEL.protect();
    }

    private static class DelegatingOperationAttachments
    implements OperationAttachments {
        private final OperationContext context;

        private DelegatingOperationAttachments(OperationContext context) {
            this.context = context;
        }

        public boolean isAutoCloseStreams() {
            return false;
        }

        public List<InputStream> getInputStreams() {
            int count = this.context.getAttachmentStreamCount();
            ArrayList<InputStream> result = new ArrayList<InputStream>(count);
            for (int i = 0; i < count; ++i) {
                result.add(this.context.getAttachmentStream(i));
            }
            return result;
        }

        public void close() throws IOException {
        }
    }

    private static class DelegatingMessageHandler
    implements OperationMessageHandler {
        private final OperationContext context;

        DelegatingMessageHandler(OperationContext context) {
            this.context = context;
        }

        public void handleReport(MessageSeverity severity, String message) {
            this.context.report(severity, message);
        }
    }

    private static class TransactionalDomainControllerClient {
        private final RemoteProxyController remoteProxy;

        public TransactionalDomainControllerClient(ManagementChannelHandler handler) {
            this.remoteProxy = RemoteProxyController.create((ManagementChannelHandler)handler, (PathAddress)PathAddress.EMPTY_ADDRESS, (ProxyOperationAddressTranslator)ProxyOperationAddressTranslator.NOOP);
        }

        private ModelNode executeTransactional(OperationContext context, ModelNode operation) {
            DelegatingMessageHandler messageHandler = new DelegatingMessageHandler(context);
            final AtomicReference txRef = new AtomicReference();
            final AtomicReference preparedResultRef = new AtomicReference();
            final AtomicReference finalResultRef = new AtomicReference();
            ProxyController.ProxyOperationControl proxyControl = new ProxyController.ProxyOperationControl(){

                public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                    txRef.set(transaction);
                    preparedResultRef.set(result);
                }

                public void operationFailed(ModelNode response) {
                    finalResultRef.set(response);
                }

                public void operationCompleted(ModelNode response) {
                    finalResultRef.set(response);
                }
            };
            this.remoteProxy.execute(operation, (OperationMessageHandler)messageHandler, proxyControl, (OperationAttachments)new DelegatingOperationAttachments(context));
            ModelNode finalResult = (ModelNode)finalResultRef.get();
            if (finalResult != null) {
                return finalResult;
            }
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    TransactionalDomainControllerClient.this.completeRemoteTransaction(context, operation, txRef, preparedResultRef, finalResultRef);
                }
            }, OperationContext.Stage.MODEL);
            return (ModelNode)preparedResultRef.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completeRemoteTransaction(OperationContext context, ModelNode operation, final AtomicReference<ModelController.OperationTransaction> txRef, AtomicReference<ModelNode> preparedResultRef, AtomicReference<ModelNode> finalResultRef) {
            boolean completeStepCalled = false;
            try {
                context.completeStep(new OperationContext.ResultHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        boolean txCompleted = false;
                        try {
                            ModelController.OperationTransaction tx = (ModelController.OperationTransaction)txRef.get();
                            try {
                                if (resultAction == OperationContext.ResultAction.KEEP) {
                                    tx.commit();
                                } else {
                                    tx.rollback();
                                }
                            }
                            finally {
                                txCompleted = true;
                            }
                        }
                        finally {
                            if (!txCompleted && txRef.get() != null) {
                                ((ModelController.OperationTransaction)txRef.get()).rollback();
                            }
                        }
                    }
                });
                completeStepCalled = true;
            }
            finally {
                if (!completeStepCalled && txRef.get() != null) {
                    txRef.get().rollback();
                }
            }
        }
    }

    private static class ReadRootResourceHandler
    implements OperationStepHandler {
        private Resource resource;

        private ReadRootResourceHandler() {
        }

        static Resource grabDomainResource(HostControllerRegistrationHandler.OperationExecutor executor) {
            ReadRootResourceHandler handler = new ReadRootResourceHandler();
            executor.execute(new ModelNode(), OperationMessageHandler.DISCARD, ModelController.OperationTransactionControl.COMMIT, null, handler);
            return handler.resource;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            this.resource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
            context.stepCompleted();
        }
    }

    private class FutureClient
    extends AsyncFutureTask<MasterDomainControllerClient> {
        protected FutureClient() {
            super(null);
        }

        private void setClient(MasterDomainControllerClient client) {
            super.setResult((Object)client);
        }
    }

    static interface RemoteFileRepositoryExecutor {
        public File getFile(String var1, byte var2, HostFileRepository var3);
    }

    static class RemoteFileRepository
    implements HostFileRepository {
        private final HostFileRepository localFileRepository;
        private volatile RemoteFileRepositoryExecutor remoteFileRepositoryExecutor;

        RemoteFileRepository(HostFileRepository localFileRepository) {
            this.localFileRepository = localFileRepository;
        }

        public final File getFile(String relativePath) {
            return this.getFile(relativePath, (byte)38);
        }

        public final File getConfigurationFile(String relativePath) {
            return this.getFile(relativePath, (byte)39);
        }

        public final File[] getDeploymentFiles(byte[] deploymentHash) {
            File root = this.getDeploymentRoot(deploymentHash);
            return root.listFiles();
        }

        public File getDeploymentRoot(byte[] deploymentHash) {
            String hex = deploymentHash == null ? "" : HashUtil.bytesToHexString((byte[])deploymentHash);
            File file = this.localFileRepository.getDeploymentRoot(deploymentHash);
            if (!file.exists()) {
                return this.getFile(hex, (byte)40);
            }
            return file;
        }

        private File getFile(String relativePath, byte repoId) {
            return this.remoteFileRepositoryExecutor.getFile(relativePath, repoId, this.localFileRepository);
        }

        void setRemoteFileRepositoryExecutor(RemoteFileRepositoryExecutor remoteFileRepositoryExecutor) {
            this.remoteFileRepositoryExecutor = remoteFileRepositoryExecutor;
        }

        public void deleteDeployment(byte[] deploymentHash) {
            this.localFileRepository.deleteDeployment(deploymentHash);
        }
    }

    private class GetFileRequest
    extends AbstractManagementRequest<File, Void> {
        private final byte rootId;
        private final String filePath;
        private final HostFileRepository localFileRepository;

        private GetFileRequest(byte rootId, String filePath, HostFileRepository localFileRepository) {
            this.rootId = rootId;
            this.filePath = filePath;
            this.localFileRepository = localFileRepository;
        }

        public byte getOperationType() {
            return 85;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<File> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
            output.write(32);
            output.writeUTF(RemoteDomainConnectionService.this.localHostInfo.getLocalHostName());
            DomainRemoteFileRequestAndHandler.INSTANCE.sendRequest(output, this.rootId, this.filePath);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<File> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            File localPath;
            switch (this.rootId) {
                case 38: {
                    localPath = this.localFileRepository.getFile(this.filePath);
                    break;
                }
                case 39: {
                    localPath = this.localFileRepository.getConfigurationFile(this.filePath);
                    break;
                }
                case 40: {
                    byte[] hash = HashUtil.hexStringToByteArray((String)this.filePath);
                    localPath = this.localFileRepository.getDeploymentRoot(hash);
                    break;
                }
                default: {
                    localPath = null;
                }
            }
            try {
                DomainRemoteFileRequestAndHandler.INSTANCE.handleResponse(input, localPath, HostControllerLogger.ROOT_LOGGER, resultHandler, context);
            }
            catch (RemoteFileRequestAndHandler.CannotCreateLocalDirectoryException e) {
                throw HostControllerLogger.ROOT_LOGGER.cannotCreateLocalDirectory(e.getDir());
            }
            catch (RemoteFileRequestAndHandler.DidNotReadEntireFileException e) {
                throw HostControllerLogger.ROOT_LOGGER.didNotReadEntireFile(e.getMissing());
            }
        }
    }
}

