/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.resources;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.controller.HostConnectionInfo;
import org.jboss.as.domain.controller.HostRegistrations;
import org.jboss.as.domain.controller.resources.DomainResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HostConnectionResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"host-connection");
    private static final ResourceDescriptionResolver RESOLVER = DomainResolver.getResolver("host-connection", false);
    private static final AttributeDefinition CONNECTION_DEF = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"connected", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime()).build();
    private static final AttributeDefinition TIMESTAMP_DEF = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"timestamp", (ModelType)ModelType.LONG, (boolean)false).setStorageRuntime()).build();
    private static final AttributeDefinition EVENT_TYPE_DEF = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"type", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build();
    private static final AttributeDefinition ADDRESS_DEF = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"address", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build();
    private static final ObjectTypeAttributeDefinition EVENT = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"event", (AttributeDefinition[])new AttributeDefinition[]{EVENT_TYPE_DEF, ADDRESS_DEF, TIMESTAMP_DEF}).setStorageRuntime()).build();
    private static final ObjectListAttributeDefinition EVENT_LIST = ((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"events", (ObjectTypeAttributeDefinition)EVENT).setStorageRuntime()).build();
    private static final OperationDefinition PRUNE_EXPIRED_DEF = new SimpleOperationDefinitionBuilder("prune-expired", RESOLVER).withFlag(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY).build();
    private static final OperationDefinition PRUNE_DISCONNECTED_DEF = new SimpleOperationDefinitionBuilder("prune-disconnected", RESOLVER).withFlag(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY).build();
    private final HostRegistrations slaveHosts;
    private final OperationStepHandler attributeReadHandler = new AttributeReadHandler();

    public HostConnectionResourceDefinition(HostRegistrations slaveHosts) {
        super(PATH, RESOLVER, null, null);
        this.slaveHosts = slaveHosts;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute(CONNECTION_DEF, this.attributeReadHandler);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)EVENT_LIST, this.attributeReadHandler);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerOperationHandler(PRUNE_EXPIRED_DEF, new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                HostConnectionResourceDefinition.this.slaveHosts.pruneExpired();
                context.stepCompleted();
            }
        });
        resourceRegistration.registerOperationHandler(PRUNE_DISCONNECTED_DEF, new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                HostConnectionResourceDefinition.this.slaveHosts.pruneDisconnected();
                context.stepCompleted();
            }
        });
    }

    static void processEvents(HostConnectionInfo info, ModelNode list) {
        for (HostConnectionInfo.Event event : info.getEvents()) {
            event.toModelNode(list.add());
        }
    }

    private class AttributeReadHandler
    implements OperationStepHandler {
        private AttributeReadHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String operationName = operation.require("name").asString();
            String hostName = address.getLastElement().getValue();
            HostConnectionInfo info = HostConnectionResourceDefinition.this.slaveHosts.getHostInfo(hostName);
            if (info != null) {
                ModelNode result = context.getResult();
                switch (operationName) {
                    case "connected": {
                        result.set(info.isConnected());
                        break;
                    }
                    case "events": {
                        HostConnectionResourceDefinition.processEvents(info, result.setEmptyList());
                    }
                }
            }
            context.stepCompleted();
        }
    }
}

