/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ServerGroupDeploymentAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add";
    private final HostFileRepository fileRepository;

    public ServerGroupDeploymentAddHandler(HostFileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode opAddr = operation.get("address");
        final PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        Resource deploymentResource = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)name)}));
        ModelNode deployment = deploymentResource.getModel();
        for (ModelNode content : deployment.require("content").asList()) {
            if (!content.hasDefined(DeploymentAttributes.CONTENT_HASH.getName())) continue;
            DeploymentAttributes.CONTENT_HASH.validateOperation(content);
            this.fileRepository.getDeploymentFiles(DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, content).asBytes());
        }
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode subModel = resource.getModel();
        for (AttributeDefinition def : DeploymentAttributes.SERVER_GROUP_ADD_ATTRIBUTES) {
            def.validateAndSet(operation, subModel);
        }
        if (!DeploymentAttributes.RUNTIME_NAME_NILLABLE.resolveModelAttribute(context, subModel).isDefined()) {
            DeploymentAttributes.RUNTIME_NAME_NILLABLE.validateAndSet(deployment, subModel);
        }
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServerGroupDeploymentAddHandler.this.validateRuntimeNames(name, context, address);
            }
        }, OperationContext.Stage.MODEL);
        context.stepCompleted();
    }

    private void validateRuntimeNames(String deploymentName, OperationContext context, PathAddress address) throws OperationFailedException {
        ModelNode deployment = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        if (DeploymentAttributes.ENABLED.resolveModelAttribute(context, deployment).asBoolean()) {
            Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
            ModelNode domainDeployment = root.getChild(PathElement.pathElement((String)"deployment", (String)deploymentName)).getModel();
            String runtimeName = ServerGroupDeploymentAddHandler.getRuntimeName(deploymentName, deployment, domainDeployment);
            PathAddress sgAddress = address.subAddress(0, address.size() - 1);
            Resource serverGroup = root.navigate(sgAddress);
            for (Resource.ResourceEntry re : serverGroup.getChildren("deployment")) {
                String otherRuntimeName;
                ModelNode otherDepl;
                String reName = re.getName();
                if (deploymentName.equals(reName) || !DeploymentAttributes.ENABLED.resolveModelAttribute(context, otherDepl = re.getModel()).asBoolean() || !runtimeName.equals(otherRuntimeName = ServerGroupDeploymentAddHandler.getRuntimeName(reName, otherDepl, domainDeployment = root.getChild(PathElement.pathElement((String)"deployment", (String)reName)).getModel()))) continue;
                throw DomainControllerLogger.ROOT_LOGGER.runtimeNameMustBeUnique(reName, runtimeName, sgAddress.getLastElement().getValue());
            }
        }
        context.stepCompleted();
    }

    private static String getRuntimeName(String name, ModelNode deployment, ModelNode domainDeployment) {
        if (deployment.hasDefined("runtime-name")) {
            return deployment.get("runtime-name").asString();
        }
        if (domainDeployment.hasDefined("runtime-name")) {
            return domainDeployment.get("runtime-name").asString();
        }
        return name;
    }

    private void isRuntimeNameUniqueForServerGroup(String serverGroupName, OperationContext context, String name, String runtimeName) throws OperationFailedException {
        if (serverGroupName != null) {
            PathAddress address = PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((String)"server-group", (String)serverGroupName), (PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment")});
            Set deployments = context.readResourceFromRoot(address).getChildren("deployment");
            for (Resource.ResourceEntry existingDeployment : deployments) {
                ModelNode existingDeploymentModel = existingDeployment.getModel();
                if (!existingDeploymentModel.hasDefined(DeploymentAttributes.RUNTIME_NAME.getName()) || name.equals(existingDeployment.getName()) || !existingDeploymentModel.get(DeploymentAttributes.RUNTIME_NAME.getName()).asString().equals(runtimeName)) continue;
                throw DomainControllerLogger.ROOT_LOGGER.runtimeNameMustBeUnique(existingDeployment.getName(), runtimeName, serverGroupName);
            }
        }
    }

    private String getServerGroupName(ModelNode operation) {
        if (operation.hasDefined("address")) {
            List address = operation.get("address").asPropertyList();
            for (Property prop : address) {
                if (!"server-group".equals(prop.getName())) continue;
                return prop.getValue().asString();
            }
        }
        return null;
    }
}

