/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.MasterDomainControllerClient;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.resources.ServerConfigResourceDefinition;
import org.jboss.dmr.ModelNode;

public class ServerAddHandler
extends AbstractAddStepHandler {
    public static final String OPERATION_NAME = "add";
    private final LocalHostControllerInfo hostControllerInfo;

    private ServerAddHandler(LocalHostControllerInfo hostControllerInfo) {
        this.hostControllerInfo = hostControllerInfo;
    }

    public static ServerAddHandler create(LocalHostControllerInfo hostControllerInfo) {
        return new ServerAddHandler(hostControllerInfo);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        for (AttributeDefinition attributeDefinition : ServerConfigResourceDefinition.WRITABLE_ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathAddress pathAddress = address.subAddress(0, 1).append(new PathElement[]{PathElement.pathElement((String)"server", (String)address.getLastElement().getValue())});
        ModelNode runningServerAdd = new ModelNode();
        runningServerAdd.get("operation").set(OPERATION_NAME);
        runningServerAdd.get("address").set(pathAddress.toModelNode());
        context.addStep(runningServerAdd, new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)PlaceholderResource.INSTANCE);
            }
        }, OperationContext.Stage.MODEL, true);
        String group = model.require("group").asString();
        String socketBindingGroup = model.hasDefined("socket-binding-group") ? model.get("socket-binding-group").asString() : null;
        Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
        boolean missingData = false;
        if (!context.isBooting() && root.getChild(PathElement.pathElement((String)"server-group", (String)group)) == null) {
            if (this.hostControllerInfo.isMasterDomainController() || !this.hostControllerInfo.isRemoteDomainControllerIgnoreUnaffectedConfiguration()) {
                throw HostControllerLogger.ROOT_LOGGER.noServerGroupCalled(group);
            }
            missingData = true;
        }
        if (socketBindingGroup != null && !context.isBooting() && root.getChild(PathElement.pathElement((String)"socket-binding-group", (String)socketBindingGroup)) == null) {
            if (this.hostControllerInfo.isMasterDomainController() || !this.hostControllerInfo.isRemoteDomainControllerIgnoreUnaffectedConfiguration()) {
                throw HostControllerLogger.ROOT_LOGGER.noSocketBindingGroupCalled(socketBindingGroup);
            }
            missingData = true;
        }
        if (missingData) {
            String serverName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            ServerAddHandler.pullDownMissingDataFromDc(context, serverName, group, socketBindingGroup);
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        throw new IllegalArgumentException();
    }

    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }

    private static void pullDownMissingDataFromDc(OperationContext context, final String serverName, final String serverGroupName, final String socketBindingGroupName) {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                MasterDomainControllerClient masterDomainControllerClient = (MasterDomainControllerClient)context.getServiceRegistry(false).getRequiredService(MasterDomainControllerClient.SERVICE_NAME).getValue();
                masterDomainControllerClient.pullDownDataForUpdatedServerConfigAndApplyToModel(context, serverName, serverGroupName, socketBindingGroupName);
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
                        if (!root.hasChild(PathElement.pathElement((String)"server-group", (String)serverGroupName))) {
                            throw HostControllerLogger.ROOT_LOGGER.noServerGroupCalled(serverGroupName);
                        }
                        if (socketBindingGroupName != null && !root.hasChild(PathElement.pathElement((String)"socket-binding-group", (String)socketBindingGroupName))) {
                            throw HostControllerLogger.ROOT_LOGGER.noSocketBindingGroupCalled(socketBindingGroupName);
                        }
                    }
                }, OperationContext.Stage.MODEL);
            }
        }, OperationContext.Stage.MODEL);
    }
}

