/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.discovery;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.remoting.Protocol;

public interface DiscoveryHostStategy {
    public static final DiscoveryHostStategy DEFAULT_STRATEGY = new DiscoveryHostStategyImpl();

    public void organize(List<? extends DiscoveryOption> var1);

    public static class DiscoveryHostStategyImpl
    implements DiscoveryHostStategy {
        private static final DiscoveryOptionComparator INSTANCE = new DiscoveryOptionComparator();

        @Override
        public void organize(List<? extends DiscoveryOption> options) {
            Collections.sort(options, INSTANCE);
        }

        private static class DiscoveryOptionComparator
        implements Comparator<DiscoveryOption> {
            private DiscoveryOptionComparator() {
            }

            @Override
            public int compare(DiscoveryOption option, DiscoveryOption otherOption) {
                Protocol currentProtocol = Protocol.forName((String)option.getRemoteDomainControllerProtocol());
                Protocol otherProtocol = Protocol.forName((String)otherOption.getRemoteDomainControllerProtocol());
                if (otherProtocol != currentProtocol) {
                    switch (currentProtocol) {
                        case HTTPS_REMOTING: {
                            return 1;
                        }
                        case REMOTE: {
                            if (otherProtocol == Protocol.HTTPS_REMOTING) {
                                return -1;
                            }
                            return 1;
                        }
                        case HTTP_REMOTING: {
                            return -1;
                        }
                    }
                } else if (option.getRemoteDomainControllerHost().equals(otherOption.getRemoteDomainControllerHost())) {
                    return option.getRemoteDomainControllerPort() - otherOption.getRemoteDomainControllerPort();
                }
                return option.getRemoteDomainControllerHost().compareTo(otherOption.getRemoteDomainControllerHost());
            }
        }
    }
}

