/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.transformers;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.domain.controller.transformers.DomainTransformers;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.dmr.ModelNode;

class SystemPropertyTransformers {
    SystemPropertyTransformers() {
    }

    static ChainedTransformationDescriptionBuilder buildTransformerChain(ModelVersion currentVersion) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedInstance((PathElement)SystemPropertyResourceDefinition.PATH, (ModelVersion)currentVersion);
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(currentVersion, DomainTransformers.VERSION_1_3);
        SystemPropertyTransformers.internalRegisterTransformers1_3_AndBelow(builder);
        return chainedBuilder;
    }

    static void registerTransformers1_3_AndBelow(ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(SystemPropertyResourceDefinition.PATH);
        SystemPropertyTransformers.internalRegisterTransformers1_3_AndBelow(builder);
    }

    private static void internalRegisterTransformers1_3_AndBelow(ResourceTransformationDescriptionBuilder builder) {
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{SystemPropertyResourceDefinition.VALUE, SystemPropertyResourceDefinition.BOOT_TIME})).setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

            protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                if (!attributeValue.isDefined()) {
                    attributeValue.set(true);
                }
            }
        }, new String[]{"boot-time"})).end().addRawOperationTransformationOverride("undefine-attribute", new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                if (operation.get("name").asString().equals("boot-time")) {
                    ModelNode op = operation.clone();
                    op.get("operation").set("write-attribute");
                    op.get("value").set(true);
                    return new OperationTransformer.TransformedOperation(op, OperationResultTransformer.ORIGINAL_RESULT);
                }
                return OperationTransformer.DEFAULT.transformOperation(context, address, operation);
            }
        });
    }
}

