/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.mgmt.DomainControllerRuntimeIgnoreTransformationRegistry;
import org.jboss.dmr.ModelNode;

public class ReadMasterDomainModelUtil {
    public static final String DOMAIN_RESOURCE_ADDRESS = "domain-resource-address";
    public static final String DOMAIN_RESOURCE_MODEL = "domain-resource-model";
    private final Set<PathElement> newRootResources = new HashSet<PathElement>();
    private volatile List<ModelNode> describedResources;

    private ReadMasterDomainModelUtil() {
    }

    static ReadMasterDomainModelUtil readMasterDomainResourcesForInitialConnect(OperationContext context, Transformers transformers, Resource domainRoot, DomainControllerRuntimeIgnoreTransformationRegistry runtimeIgnoreTransformationRegistry) throws OperationFailedException {
        Resource transformedResource = transformers.transformRootResource(context, domainRoot);
        ReadMasterDomainModelUtil util = new ReadMasterDomainModelUtil();
        util.describedResources = util.describeAsNodeList(PathAddress.EMPTY_ADDRESS, transformedResource, false);
        return util;
    }

    static ReadMasterDomainModelUtil readMasterDomainResourcesForSlaveRequest(OperationContext context, Set<PathElement> missingRootResources, Transformers transformers, Resource domainRoot, DomainControllerRuntimeIgnoreTransformationRegistry runtimeIgnoreTransformationRegistry) throws OperationFailedException {
        ReadMasterDomainModelUtil util = new ReadMasterDomainModelUtil();
        util.describedResources = new ArrayList<ModelNode>();
        for (PathElement element : missingRootResources) {
            PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{element});
            Resource original = domainRoot.getChild(element);
            if (original == null) {
                throw HostControllerLogger.ROOT_LOGGER.noResourceFor(address);
            }
            Resource resource = transformers.transformResource(context, PathAddress.EMPTY_ADDRESS, original, true);
            util.describe(address, resource, util.describedResources, true);
        }
        return util;
    }

    public static ReadMasterDomainModelUtil readMasterDomainResourcesForPiggyBackFollowingDomainControllerChange(OperationContext context, Set<PathElement> missingRootResources, Transformers transformers, String hostName, DomainControllerRuntimeIgnoreTransformationRegistry ignoreTransformationRegistry) throws OperationFailedException {
        ReadMasterDomainModelUtil util = new ReadMasterDomainModelUtil();
        util.describedResources = new ArrayList<ModelNode>();
        Resource domainRoot = null;
        HashSet<PathElement> allMissingRootResources = new HashSet<PathElement>(missingRootResources);
        for (PathElement element : missingRootResources) {
            if (!element.getKey().equals("profile")) continue;
            if (domainRoot == null) {
                domainRoot = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
            }
            allMissingRootResources.addAll(ignoreTransformationRegistry.getUnknownExtensionsForProfile(domainRoot, hostName, element.getValue()));
        }
        for (PathElement element : allMissingRootResources) {
            PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{element});
            Resource original = context.readResourceFromRoot(address);
            if (original == null) {
                throw HostControllerLogger.ROOT_LOGGER.noResourceFor(address);
            }
            Resource resource = transformers.transformResource(context, address, original, true).getChild(element);
            util.describe(address, resource, util.describedResources, true);
        }
        return util;
    }

    public List<ModelNode> getDescribedResources() {
        return this.describedResources;
    }

    public Set<PathElement> getNewKnownRootResources() {
        return this.newRootResources;
    }

    private List<ModelNode> describeAsNodeList(PathAddress rootAddress, Resource resource, boolean isRuntimeChange) {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        this.describe(rootAddress, resource, list, isRuntimeChange);
        return list;
    }

    private void describe(PathAddress base, Resource resource, List<ModelNode> nodes, boolean isRuntimeChange) {
        if (resource.isProxy() || resource.isRuntime()) {
            return;
        }
        if (base.size() >= 1 && base.getElement(0).getKey().equals("host")) {
            return;
        }
        if (base.size() == 1) {
            this.newRootResources.add(base.getLastElement());
        }
        ModelNode description = new ModelNode();
        description.get(DOMAIN_RESOURCE_ADDRESS).set(base.toModelNode());
        description.get(DOMAIN_RESOURCE_MODEL).set(resource.getModel());
        nodes.add(description);
        for (String childType : resource.getChildTypes()) {
            for (Resource.ResourceEntry entry : resource.getChildren(childType)) {
                this.describe(base.append(new PathElement[]{entry.getPathElement()}), (Resource)entry, nodes, isRuntimeChange);
            }
        }
    }
}

