/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.dmr.ModelNode;

public class ServerGroupDeploymentAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add";
    private final HostFileRepository fileRepository;
    private final ContentRepository contentRepository;

    public ServerGroupDeploymentAddHandler(HostFileRepository fileRepository, ContentRepository contentRepository) {
        this.fileRepository = fileRepository;
        this.contentRepository = contentRepository;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode opAddr = operation.get("address");
        final PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        Resource deploymentResource = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)name)}));
        ModelNode deployment = deploymentResource.getModel();
        for (ModelNode content : deployment.require("content").asList()) {
            if (!content.hasDefined(DeploymentAttributes.CONTENT_HASH.getName())) continue;
            DeploymentAttributes.CONTENT_HASH.validateOperation(content);
            ContentReference reference = ModelContentReference.fromModelAddress((PathAddress)address, (byte[])DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, content).asBytes());
            this.fileRepository.getDeploymentFiles(reference);
            if (this.contentRepository == null) continue;
            this.contentRepository.addContentReference(reference);
        }
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode subModel = resource.getModel();
        for (AttributeDefinition def : DeploymentAttributes.SERVER_GROUP_ADD_ATTRIBUTES) {
            def.validateAndSet(operation, subModel);
        }
        if (!DeploymentAttributes.RUNTIME_NAME_NILLABLE.resolveModelAttribute(context, subModel).isDefined()) {
            DeploymentAttributes.RUNTIME_NAME_NILLABLE.validateAndSet(deployment, subModel);
        }
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServerGroupDeploymentAddHandler.this.validateRuntimeNames(name, context, address);
            }
        }, OperationContext.Stage.MODEL);
        context.stepCompleted();
    }

    private void validateRuntimeNames(String deploymentName, OperationContext context, PathAddress address) throws OperationFailedException {
        ModelNode deployment = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        if (DeploymentAttributes.ENABLED.resolveModelAttribute(context, deployment).asBoolean()) {
            Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
            ModelNode domainDeployment = root.getChild(PathElement.pathElement((String)"deployment", (String)deploymentName)).getModel();
            String runtimeName = ServerGroupDeploymentAddHandler.getRuntimeName(deploymentName, deployment, domainDeployment);
            PathAddress sgAddress = address.subAddress(0, address.size() - 1);
            Resource serverGroup = root.navigate(sgAddress);
            for (Resource.ResourceEntry re : serverGroup.getChildren("deployment")) {
                String otherRuntimeName;
                ModelNode otherDepl;
                String reName = re.getName();
                if (deploymentName.equals(reName) || !DeploymentAttributes.ENABLED.resolveModelAttribute(context, otherDepl = re.getModel()).asBoolean() || !runtimeName.equals(otherRuntimeName = ServerGroupDeploymentAddHandler.getRuntimeName(reName, otherDepl, domainDeployment = root.getChild(PathElement.pathElement((String)"deployment", (String)reName)).getModel()))) continue;
                throw DomainControllerLogger.ROOT_LOGGER.runtimeNameMustBeUnique(reName, runtimeName, sgAddress.getLastElement().getValue());
            }
        }
        context.stepCompleted();
    }

    private static String getRuntimeName(String name, ModelNode deployment, ModelNode domainDeployment) {
        if (deployment.hasDefined("runtime-name")) {
            return deployment.get("runtime-name").asString();
        }
        if (domainDeployment.hasDefined("runtime-name")) {
            return domainDeployment.get("runtime-name").asString();
        }
        return name;
    }
}

