/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.coordination.DomainServerUtils;
import org.jboss.as.domain.management.CoreManagementResourceDefinition;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.access.AccessConstraintResources;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.ManagedServerBootCmdFactory;
import org.jboss.as.host.controller.ManagedServerBootConfiguration;
import org.jboss.as.host.controller.ManagedServerOperationsFactory;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.management.client.content.ManagedDMRContentTypeResource;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ApplyRemoteMasterDomainModelHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "apply-remote-domain-model";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("apply-remote-domain-model", null).withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).setPrivateEntry().build();
    protected final DomainController domainController;
    protected final HostControllerEnvironment hostControllerEnvironment;
    protected final LocalHostControllerInfo localHostInfo;
    protected final IgnoredDomainResourceRegistry ignoredResourceRegistry;
    private final HostFileRepository fileRepository;
    private final ContentRepository contentRepository;
    private final WritableAuthorizerConfiguration authorizerConfiguration;

    public ApplyRemoteMasterDomainModelHandler(DomainController domainController, HostControllerEnvironment hostControllerEnvironment, HostFileRepository fileRepository, ContentRepository contentRepository, LocalHostControllerInfo localHostInfo, IgnoredDomainResourceRegistry ignoredResourceRegistry, WritableAuthorizerConfiguration authorizerConfiguration) {
        this.domainController = domainController;
        this.hostControllerEnvironment = hostControllerEnvironment;
        this.fileRepository = fileRepository;
        this.contentRepository = contentRepository;
        this.localHostInfo = localHostInfo;
        this.ignoredResourceRegistry = ignoredResourceRegistry;
        this.authorizerConfiguration = authorizerConfiguration;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode domainModel = operation.get("domain-model");
        final ModelNode startRoot = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS));
        Set<String> ourServerGroups = this.getOurServerGroups(context);
        HashMap<String, HashSet<ContentReference>> deploymentHashes = new HashMap<String, HashSet<ContentReference>>();
        HashSet<String> relevantDeployments = new HashSet<String>();
        HashSet<ContentReference> requiredContent = new HashSet<ContentReference>();
        Resource rootResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        this.clearDomain(rootResource);
        if (!context.isBooting()) {
            this.authorizerConfiguration.reset();
        }
        ArrayList<ModelNode> addOps = new ArrayList<ModelNode>();
        for (ModelNode resourceDescription : domainModel.asList()) {
            PathAddress resourceAddress = PathAddress.pathAddress((ModelNode)resourceDescription.require("domain-resource-address"));
            if (this.ignoredResourceRegistry.isResourceExcluded(resourceAddress) || resourceAddress.size() == 1 && resourceAddress.getElement(0).getKey().equals("extension")) continue;
            ModelNode resourceModel = resourceDescription.get("domain-resource-model");
            Resource resource = this.getResource(resourceAddress, rootResource, resourceModel, context, addOps);
            if (resource != null && resourceAddress.size() == 1) {
                ModelNode model;
                PathElement pe = resourceAddress.getElement(0);
                String peKey = pe.getKey();
                if (peKey.equals("deployment")) {
                    model = resource.getModel();
                    String id = resourceAddress.getElement(0).getValue();
                    if (!model.hasDefined("content")) continue;
                    for (ModelNode contentItem : model.get("content").asList()) {
                        if (!contentItem.hasDefined("hash")) continue;
                        HashSet<ContentReference> hashes = (HashSet<ContentReference>)deploymentHashes.get(id);
                        if (hashes == null) {
                            hashes = new HashSet<ContentReference>();
                            deploymentHashes.put(id, hashes);
                        }
                        hashes.add(ModelContentReference.fromModelAddress((PathAddress)resourceAddress, (byte[])contentItem.get("hash").asBytes()));
                        if (!this.hostControllerEnvironment.isBackupDomainFiles()) continue;
                        relevantDeployments.add(pe.getValue());
                    }
                    continue;
                }
                if (!peKey.equals("management-client-content") || !(model = resource.getModel()).hasDefined("hash")) continue;
                byte[] hash = model.get("hash").asBytes();
                requiredContent.add(ModelContentReference.fromModelAddress((PathAddress)resourceAddress, (byte[])hash));
                continue;
            }
            if (resourceAddress.size() != 2 || !resourceAddress.getElement(0).getKey().equals("server-group") || !ourServerGroups.contains(resourceAddress.getElement(0).getValue()) || !resourceAddress.getElement(1).getKey().equals("deployment")) continue;
            relevantDeployments.add(resourceAddress.getElement(1).getValue());
        }
        for (String id : relevantDeployments) {
            Set hashes = (Set)deploymentHashes.remove(id);
            if (hashes == null) continue;
            requiredContent.addAll(hashes);
        }
        for (ContentReference reference : requiredContent) {
            this.fileRepository.getDeploymentFiles(reference);
            this.contentRepository.addContentReference(reference);
        }
        if (!context.isBooting()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ApplyRemoteMasterDomainModelHandler.this.makeAffectedServersRestartRequired(context, startRoot);
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.MODEL, true);
        }
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        for (int i = addOps.size() - 1; i >= 0; --i) {
            String stepOpName;
            ModelNode subOperation = (ModelNode)addOps.get(i);
            PathAddress stepAddress = PathAddress.pathAddress((ModelNode)subOperation.get("address"));
            OperationStepHandler stepHandler = registry.getOperationHandler(stepAddress, stepOpName = subOperation.require("operation").asString());
            if (stepHandler == null) {
                ImmutableManagementResourceRegistration child = registry.getSubModel(stepAddress);
                if (child == null) {
                    throw new IllegalStateException(ControllerLogger.ROOT_LOGGER.noSuchResourceType(stepAddress));
                }
                throw new IllegalStateException(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(stepOpName, stepAddress));
            }
            context.addStep(subOperation, stepHandler, OperationContext.Stage.MODEL, true);
        }
        context.stepCompleted();
    }

    private void clearDomain(Resource rootResource) {
        for (Resource.ResourceEntry entry : rootResource.getChildren("path")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("system-property")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("profile")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("interface")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("socket-binding-group")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("deployment")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("server-group")) {
            rootResource.removeChild(entry.getPathElement());
        }
        Resource accessControl = rootResource.navigate(PathAddress.pathAddress((PathElement[])new PathElement[]{CoreManagementResourceDefinition.PATH_ELEMENT, AccessAuthorizationResourceDefinition.PATH_ELEMENT}));
        accessControl.writeModel(new ModelNode());
        for (Resource.ResourceEntry entry : accessControl.getChildren("server-group-scoped-role")) {
            accessControl.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : accessControl.getChildren("host-scoped-role")) {
            accessControl.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : accessControl.getChildren("role-mapping")) {
            accessControl.removeChild(entry.getPathElement());
        }
    }

    protected Resource getResource(PathAddress resourceAddress, Resource rootResource, ModelNode resourceModel, OperationContext context, List<ModelNode> addOps) {
        if (resourceAddress.size() == 0) {
            rootResource.writeModel(resourceModel.clone());
            return rootResource;
        }
        boolean allowCreate = true;
        boolean writeResourceModel = true;
        boolean coreService = false;
        boolean accessControl = false;
        PathElement created = null;
        Resource temp = rootResource;
        int idx = 0;
        for (PathElement element : resourceAddress) {
            temp = temp == null ? null : temp.getChild(element);
            String type = element.getKey();
            assert (!"extension".equals(type)) : "extension resources should be excluded";
            String value = element.getValue();
            if (temp == null) {
                if (idx == 0) {
                    if ("management-client-content".equals(type) && "rollout-plans".equals(value)) {
                        temp = new ManagedDMRContentTypeResource(resourceAddress, "rollout-plan", null, this.contentRepository);
                        context.addResource(resourceAddress, temp);
                    }
                } else if (accessControl) {
                    allowCreate = false;
                    if (idx == resourceAddress.size() - 1) {
                        ModelNode addOp = Util.createAddOperation((PathAddress)resourceAddress);
                        if (resourceModel.isDefined()) {
                            for (Property property : resourceModel.asPropertyList()) {
                                addOp.get(property.getName()).set(property.getValue());
                            }
                        }
                        addOps.add(addOp);
                    }
                }
                if (temp == null && allowCreate) {
                    assert (created == null) : "already created " + created;
                    temp = context.createResource(resourceAddress);
                    created = element;
                }
            } else if ("core-service".equals(type) && "management".equals(value)) {
                coreService = true;
            } else if (coreService && idx == 1 && element.equals(AccessAuthorizationResourceDefinition.PATH_ELEMENT)) {
                accessControl = true;
                if (idx == resourceAddress.size() - 1) {
                    writeResourceModel = false;
                    ModelNode configureOp = Util.createEmptyOperation((String)"configure-from-domain", (PathAddress)resourceAddress);
                    for (AttributeDefinition ad : AccessAuthorizationResourceDefinition.CONFIG_ATTRIBUTES) {
                        String attrName = ad.getName();
                        if (!resourceModel.hasDefined(attrName)) continue;
                        configureOp.get(attrName).set(resourceModel.get(attrName));
                    }
                    addOps.add(configureOp);
                }
            } else if (accessControl && idx == 2 && (AccessConstraintResources.APPLICATION_PATH_ELEMENT.equals(element) || AccessConstraintResources.SENSITIVITY_PATH_ELEMENT.equals(element) || AccessConstraintResources.VAULT_PATH_ELEMENT.equals(element))) {
                accessControl = false;
                allowCreate = false;
            }
            ++idx;
        }
        if (writeResourceModel && temp != null) {
            temp.writeModel(resourceModel);
        }
        return temp;
    }

    private Set<String> getOurServerGroups(OperationContext context) {
        HashSet<String> result = new HashSet<String>();
        Resource root = context.readResource(PathAddress.EMPTY_ADDRESS);
        Resource host = (Resource)root.getChildren("host").iterator().next();
        for (Resource server : host.getChildren("server-config")) {
            ModelNode model = server.getModel();
            result.add(model.get("group").asString());
        }
        return result;
    }

    private void makeAffectedServersRestartRequired(OperationContext context, ModelNode startRoot) {
        Set<ServerIdentity> runningServers;
        Resource domainRootResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode endRoot = Resource.Tools.readModel((Resource)domainRootResource);
        ModelNode hostModel = ((Property)endRoot.require("host").asPropertyList().iterator().next()).getValue();
        ModelNode existingHostModel = ((Property)startRoot.require("host").asPropertyList().iterator().next()).getValue();
        if (!hostModel.hasDefined("server-config")) {
            return;
        }
        HashSet<ServerIdentity> restartServers = new HashSet<ServerIdentity>();
        HashSet<ServerIdentity> reloadServers = new HashSet<ServerIdentity>();
        for (String serverName : hostModel.get("server-config").keys()) {
            ModelNode endOps;
            ManagedServerBootConfiguration startConfig = new ManagedServerBootCmdFactory(serverName, startRoot, existingHostModel, this.hostControllerEnvironment, this.domainController.getExpressionResolver()).createConfiguration();
            ManagedServerBootConfiguration endConfig = new ManagedServerBootCmdFactory(serverName, endRoot, hostModel, this.hostControllerEnvironment, this.domainController.getExpressionResolver()).createConfiguration();
            if (!startConfig.getServerLaunchCommand().equals(endConfig.getServerLaunchCommand())) {
                restartServers.add(this.createServerIdentity(hostModel, serverName));
                continue;
            }
            ModelNode startOps = this.createBootOps(context, serverName, startRoot, existingHostModel);
            if (!this.bootOpsChanged(startOps, endOps = this.createBootOps(context, serverName, endRoot, hostModel))) continue;
            reloadServers.add(this.createServerIdentity(hostModel, serverName));
        }
        Map<String, ProxyController> serverProxies = DomainServerUtils.getServerProxies(this.localHostInfo.getLocalHostName(), domainRootResource, context.getResourceRegistration());
        if (!restartServers.isEmpty()) {
            DomainControllerLogger.ROOT_LOGGER.domainModelChangedOnReConnect(restartServers);
            runningServers = DomainServerUtils.getAllRunningServers(hostModel, this.localHostInfo.getLocalHostName(), serverProxies);
            for (ServerIdentity serverIdentity : restartServers) {
                if (!runningServers.contains(serverIdentity)) continue;
                ApplyRemoteMasterDomainModelHandler.addLifecycleStep(context, serverIdentity, "server-set-restart-required");
            }
        }
        if (!reloadServers.isEmpty()) {
            DomainControllerLogger.ROOT_LOGGER.domainModelChangedOnReConnect(reloadServers);
            runningServers = DomainServerUtils.getAllRunningServers(hostModel, this.localHostInfo.getLocalHostName(), serverProxies);
            for (ServerIdentity serverIdentity : reloadServers) {
                if (!runningServers.contains(serverIdentity)) continue;
                ApplyRemoteMasterDomainModelHandler.addLifecycleStep(context, serverIdentity, "server-set-reload-required");
            }
        }
    }

    private ServerIdentity createServerIdentity(ModelNode hostModel, String serverName) {
        return new ServerIdentity(this.localHostInfo.getLocalHostName(), hostModel.require("server-config").require(serverName).require("group").asString(), serverName);
    }

    private boolean bootOpsChanged(ModelNode startOps, ModelNode endOps) {
        List startOpList = startOps.asList();
        List endOpList = endOps.asList();
        if (startOpList.size() != endOpList.size()) {
            return true;
        }
        HashSet startOpSet = new HashSet(startOpList);
        HashSet endOpSet = new HashSet(endOpList);
        return !startOpSet.equals(endOpSet);
    }

    private ModelNode createBootOps(final OperationContext context, String serverName, ModelNode domainModel, ModelNode hostModel) {
        return ManagedServerOperationsFactory.createBootUpdates(serverName, domainModel, hostModel, this.domainController, new ExpressionResolver(){

            public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
                return context.resolveExpressions(node);
            }
        });
    }

    private static void addLifecycleStep(OperationContext context, ServerIdentity serverIdentity, String operationName) {
        PathAddress serverAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)serverIdentity.getHostName()), PathElement.pathElement((String)"server", (String)serverIdentity.getServerName())});
        OperationStepHandler handler = context.getResourceRegistration().getOperationHandler(serverAddress, operationName);
        ModelNode op = new ModelNode();
        op.get("operation").set(operationName);
        op.get("address").set(serverAddress.toModelNode());
        context.addStep(op, handler, OperationContext.Stage.MODEL, true);
    }
}

