/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.resources;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.operations.HttpManagementAddHandler;
import org.jboss.as.host.controller.operations.HttpManagementRemoveHandler;
import org.jboss.as.host.controller.operations.HttpManagementWriteAttributeHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HttpManagementResourceDefinition
extends SimpleResourceDefinition {
    private static final PathElement RESOURCE_PATH = PathElement.pathElement((String)"management-interface", (String)"http-interface");
    private static final OperationStepHandler VALIDATING_HANDLER = new HttpManagementValidatingHandler();
    public static final SimpleAttributeDefinition SECURITY_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SECURITY_REALM_REF)).build();
    public static final SimpleAttributeDefinition INTERFACE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("interface", ModelType.STRING, false).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_CONFIG)).build();
    public static final SimpleAttributeDefinition HTTP_PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("port", ModelType.INT, true).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(0, 65535, true, true))).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_CONFIG)).build();
    public static final SimpleAttributeDefinition HTTPS_PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("secure-port", ModelType.INT, true).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(0, 65535, true, true))).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_CONFIG)).build();
    public static final SimpleAttributeDefinition SECURE_INTERFACE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("secure-interface", ModelType.STRING, true).setAllowExpression(false)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_CONFIG)).build();
    public static final SimpleAttributeDefinition CONSOLE_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("console-enabled", ModelType.BOOLEAN, true).setAllowExpression(true)).setXmlName(Attribute.CONSOLE_ENABLED.getLocalName())).setDefaultValue(new ModelNode(true))).build();
    public static final SimpleAttributeDefinition HTTP_UPGRADE_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("http-upgrade-enabled", ModelType.BOOLEAN, true).setAllowExpression(true)).setXmlName(Attribute.HTTP_UPGRADE_ENABLED.getLocalName())).setDefaultValue(new ModelNode(false))).build();
    public static final SimpleAttributeDefinition SERVER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server-name", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    public static final SimpleAttributeDefinition SASL_PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sasl-protocol", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).setDefaultValue(new ModelNode("remote"))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    public static final AttributeDefinition[] ATTRIBUTE_DEFINITIONS = new AttributeDefinition[]{INTERFACE, HTTP_PORT, HTTPS_PORT, SECURE_INTERFACE, SECURITY_REALM, CONSOLE_ENABLED, HTTP_UPGRADE_ENABLED, SASL_PROTOCOL, SERVER_NAME};
    private final List<AccessConstraintDefinition> accessConstraints = SensitiveTargetAccessConstraintDefinition.MANAGEMENT_INTERFACES.wrapAsList();

    public HttpManagementResourceDefinition(LocalHostControllerInfoImpl hostControllerInfo, HostControllerEnvironment environment) {
        super(RESOURCE_PATH, (ResourceDescriptionResolver)HostModelUtil.getResourceDescriptionResolver("core", "management", "http-interface"), (OperationStepHandler)new HttpManagementAddHandler(hostControllerInfo, environment), (OperationStepHandler)new HttpManagementRemoveHandler(hostControllerInfo, environment), OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_NONE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attr : ATTRIBUTE_DEFINITIONS) {
            resourceRegistration.registerReadWriteAttribute(attr, null, HttpManagementWriteAttributeHandler.INSTANCE);
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    public static void addValidatingHandler(OperationContext operationContext, ModelNode fromOperation) {
        ModelNode operation = Util.createOperation((String)"validate-http-interface", (PathAddress)PathAddress.pathAddress((ModelNode)fromOperation.require("address")));
        operationContext.addStep(operation, VALIDATING_HANDLER, OperationContext.Stage.MODEL);
    }

    private static class HttpManagementValidatingHandler
    implements OperationStepHandler {
        private HttpManagementValidatingHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
            if (!model.hasDefined(SECURITY_REALM.getName()) && model.hasDefined(HTTPS_PORT.getName())) {
                throw HostControllerLogger.ROOT_LOGGER.noSecurityRealmForSsl();
            }
            context.stepCompleted();
        }
    }
}

