/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;

class ConcurrentGroupServerUpdatePolicy {
    private final ConcurrentGroupServerUpdatePolicy predecessor;
    private final Set<String> groups = new HashSet<String>();
    private int responseCount;
    private boolean failed;

    ConcurrentGroupServerUpdatePolicy(ConcurrentGroupServerUpdatePolicy predecessor, Set<String> groups) {
        this.predecessor = predecessor;
        this.groups.addAll(groups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canSuccessorProceed() {
        if (this.predecessor != null && !this.predecessor.canSuccessorProceed()) {
            return false;
        }
        ConcurrentGroupServerUpdatePolicy concurrentGroupServerUpdatePolicy = this;
        synchronized (concurrentGroupServerUpdatePolicy) {
            while (this.responseCount < this.groups.size()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            return !this.failed;
        }
    }

    public boolean canChildProceed() {
        return this.predecessor == null || this.predecessor.canSuccessorProceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordServerGroupResult(String serverGroup, boolean failed) {
        ConcurrentGroupServerUpdatePolicy concurrentGroupServerUpdatePolicy = this;
        synchronized (concurrentGroupServerUpdatePolicy) {
            if (this.groups.contains(serverGroup)) {
                ++this.responseCount;
                if (failed) {
                    this.failed = true;
                }
            } else {
                throw DomainControllerLogger.ROOT_LOGGER.unknownServerGroup(serverGroup);
            }
            DomainControllerLogger.DOMAIN_DEPLOYMENT_LOGGER.tracef("Recorded group result for '%s': failed = %s", serverGroup, failed);
            this.notifyAll();
        }
    }
}

