/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.NoSuchElementException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.resources.ServerGroupResourceDefinition;
import org.jboss.dmr.ModelNode;

public class ServerGroupAddHandler
implements OperationStepHandler {
    private final boolean master;

    public ServerGroupAddHandler(boolean master) {
        this.master = master;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        for (AttributeDefinition attr : ServerGroupResourceDefinition.ADD_ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
        boolean reloadRequired = false;
        String profile = ServerGroupResourceDefinition.PROFILE.resolveModelAttribute(context, model).asString();
        try {
            context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)ServerGroupResourceDefinition.PROFILE.getName(), (String)profile)}));
        }
        catch (Exception e) {
            if (this.master) {
                throw DomainControllerLogger.ROOT_LOGGER.noProfileCalled(profile);
            }
            reloadRequired = true;
            context.reloadRequired();
        }
        if (operation.hasDefined(ServerGroupResourceDefinition.SOCKET_BINDING_GROUP.getName())) {
            String socketBindingGroup = ServerGroupResourceDefinition.SOCKET_BINDING_GROUP.resolveModelAttribute(context, model).asString();
            try {
                context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)ServerGroupResourceDefinition.SOCKET_BINDING_GROUP.getName(), (String)socketBindingGroup)}));
            }
            catch (NoSuchElementException e) {
                if (this.master) {
                    throw new OperationFailedException(DomainControllerLogger.ROOT_LOGGER.unknown(ServerGroupResourceDefinition.SOCKET_BINDING_GROUP.getName(), socketBindingGroup));
                }
                reloadRequired = true;
                context.reloadRequired();
            }
        } else {
            Object socketBindingGroup = null;
        }
        final boolean revertReloadRequiredOnRollback = reloadRequired;
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                if (resultAction == OperationContext.ResultAction.ROLLBACK && revertReloadRequiredOnRollback) {
                    context.revertReloadRequired();
                }
            }
        });
    }

    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }
}

