/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.dmr.ModelNode;

class OperationRouting {
    private final String singleHost;
    private final Set<String> hosts = new HashSet<String>();
    private final boolean twoStep;

    static OperationRouting determineRouting(OperationContext context, ModelNode operation, LocalHostControllerInfo localHostControllerInfo) throws OperationFailedException {
        ImmutableManagementResourceRegistration rootRegistration = context.getRootResourceRegistration();
        return OperationRouting.determineRouting(operation, localHostControllerInfo, rootRegistration);
    }

    private static OperationRouting determineRouting(ModelNode operation, LocalHostControllerInfo localHostControllerInfo, ImmutableManagementResourceRegistration rootRegistration) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String operationName = operation.require("operation").asString();
        Set<OperationEntry.Flag> operationFlags = OperationRouting.resolveOperationFlags(address, operationName, rootRegistration);
        return OperationRouting.determineRouting(operation, address, operationName, operationFlags, localHostControllerInfo, rootRegistration);
    }

    private static Set<OperationEntry.Flag> resolveOperationFlags(PathAddress address, String operationName, ImmutableManagementResourceRegistration rootRegistration) throws OperationFailedException {
        PathElement pe;
        EnumSet result = null;
        boolean validAddress = false;
        ImmutableManagementResourceRegistration targetReg = rootRegistration.getSubModel(address);
        if (targetReg != null) {
            validAddress = true;
            OperationEntry opE = targetReg.getOperationEntry(PathAddress.EMPTY_ADDRESS, operationName);
            EnumSet enumSet = result = opE == null ? null : opE.getFlags();
        }
        if (result == null && address.size() > 0 && (pe = address.getLastElement()).isWildcard()) {
            String type = pe.getKey();
            PathAddress parent = address.subAddress(0, address.size() - 1);
            Set children = rootRegistration.getChildAddresses(parent);
            if (children != null) {
                EnumSet found = null;
                for (PathElement child : children) {
                    EnumSet flags;
                    if (!type.equals(child.getKey())) continue;
                    validAddress = true;
                    OperationEntry oe = rootRegistration.getOperationEntry(parent.append(new PathElement[]{child}), operationName);
                    EnumSet enumSet = flags = oe == null ? null : oe.getFlags();
                    if (flags == null || found != null && !found.equals(flags)) {
                        found = null;
                        validAddress = false;
                        break;
                    }
                    found = flags;
                }
                result = found;
            }
        }
        if (result == null) {
            if (validAddress) {
                throw new OperationFailedException(new ModelNode(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(operationName, address)));
            }
            throw new OperationFailedException(new ModelNode(ControllerLogger.ROOT_LOGGER.noSuchResourceType(address)));
        }
        return result;
    }

    private static OperationRouting determineRouting(ModelNode operation, PathAddress address, String operationName, Set<OperationEntry.Flag> operationFlags, LocalHostControllerInfo localHostControllerInfo, ImmutableManagementResourceRegistration rootRegistration) throws OperationFailedException {
        PathElement first;
        OperationRouting routing = null;
        String targetHost = null;
        boolean compositeOp = false;
        if (address.size() > 0) {
            first = address.getElement(0);
            if ("host".equals(first.getKey())) {
                targetHost = first.getValue();
            }
        } else {
            compositeOp = "composite".equals(operationName);
        }
        if (targetHost != null) {
            if (operationFlags.contains(OperationEntry.Flag.READ_ONLY) && !operationFlags.contains(OperationEntry.Flag.DOMAIN_PUSH_TO_SERVERS)) {
                routing = new OperationRouting(targetHost, false);
            } else if (address.size() > 1 && "server".equals((first = address.getElement(1)).getKey())) {
                routing = new OperationRouting(targetHost, false);
            }
            if (routing == null) {
                routing = operationFlags.contains(OperationEntry.Flag.HOST_CONTROLLER_ONLY) ? new OperationRouting(targetHost, false) : new OperationRouting(targetHost, true);
            }
        } else if (compositeOp) {
            if (operation.hasDefined("steps")) {
                HashSet<String> allHosts = new HashSet<String>();
                boolean fwdToAllHosts = false;
                for (ModelNode step : operation.get("steps").asList()) {
                    OperationRouting stepRouting = OperationRouting.determineRouting(step, localHostControllerInfo, rootRegistration);
                    if (stepRouting.isTwoStep()) {
                        fwdToAllHosts = fwdToAllHosts || stepRouting.getHosts().isEmpty();
                    }
                    allHosts.addAll(stepRouting.getHosts());
                }
                routing = fwdToAllHosts ? new OperationRouting(true) : new OperationRouting(allHosts);
            } else {
                routing = new OperationRouting(localHostControllerInfo.getLocalHostName(), false);
            }
        } else if (operationFlags.contains(OperationEntry.Flag.READ_ONLY) && !operationFlags.contains(OperationEntry.Flag.DOMAIN_PUSH_TO_SERVERS)) {
            routing = new OperationRouting(localHostControllerInfo.getLocalHostName(), false);
        } else if (!localHostControllerInfo.isMasterDomainController()) {
            routing = new OperationRouting();
        } else if (operationFlags.contains(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY)) {
            routing = new OperationRouting(localHostControllerInfo.getLocalHostName(), false);
        }
        if (routing == null) {
            routing = new OperationRouting(true);
        }
        return routing;
    }

    private OperationRouting() {
        this.twoStep = false;
        this.singleHost = null;
    }

    private OperationRouting(boolean twoStep) {
        this.twoStep = twoStep;
        this.singleHost = null;
    }

    public OperationRouting(String host, boolean twoStep) {
        this.hosts.add(host);
        this.twoStep = twoStep;
        this.singleHost = host;
    }

    public OperationRouting(Collection<String> hosts) {
        this.hosts.addAll(hosts);
        this.twoStep = true;
        this.singleHost = null;
    }

    public Set<String> getHosts() {
        return this.hosts;
    }

    public String getSingleHost() {
        return this.singleHost;
    }

    public boolean isTwoStep() {
        return this.twoStep;
    }

    public boolean isLocalOnly(String localHostName) {
        if (this.singleHost != null) {
            return localHostName.equals(this.singleHost);
        }
        return this.hosts.size() == 1 && this.hosts.contains(localHostName);
    }

    public boolean isLocalCallNeeded(String localHostName) {
        return localHostName.equals(this.singleHost) || this.hosts.size() == 0 || this.hosts.contains(localHostName);
    }
}

