/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.operations.ReadMasterDomainModelUtil;
import org.jboss.as.host.controller.mgmt.DomainControllerRuntimeIgnoreTransformationRegistry;
import org.jboss.dmr.ModelNode;

public class ReadMasterDomainModelHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "read-master-domain-model";
    protected final String host;
    protected final Transformers transformers;
    protected final DomainControllerRuntimeIgnoreTransformationRegistry runtimeIgnoreTransformationRegistry;

    public ReadMasterDomainModelHandler(String host, Transformers transformers, DomainControllerRuntimeIgnoreTransformationRegistry runtimeIgnoreTransformationRegistry) {
        this.host = host;
        this.transformers = transformers;
        this.runtimeIgnoreTransformationRegistry = runtimeIgnoreTransformationRegistry;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.acquireControllerLock();
        Resource rootResource = context.readResource(PathAddress.EMPTY_ADDRESS, true);
        final ReadMasterDomainModelUtil readUtil = ReadMasterDomainModelUtil.readMasterDomainResourcesForInitialConnect(context, this.transformers, rootResource, this.runtimeIgnoreTransformationRegistry);
        context.getResult().set(readUtil.getDescribedResources());
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                if (resultAction == OperationContext.ResultAction.KEEP) {
                    ReadMasterDomainModelHandler.this.runtimeIgnoreTransformationRegistry.addKnownDataForSlave(ReadMasterDomainModelHandler.this.host, readUtil.getNewKnownRootResources());
                }
            }
        });
    }
}

