/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded.logging;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleLoader;
import org.jboss.vfs.VirtualFile;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.core.embedded.logging.EmbeddedLogger;

public class EmbeddedLogger_$logger
extends DelegatingBasicLogger
implements EmbeddedLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = EmbeddedLogger_$logger.class.getName();
    private static final String cannotCloseFile = "WFLYEMB0001: Could not close handle to mounted %s";
    private static final String cannotLoadClassFile = "WFLYEMB0002: Could not load class file %s";
    private static final String errorClosingFile = "WFLYEMB0003: Exception closing file %s";
    private static final String failedToUndeploy = "WFLYEMB0004: Failed to undeploy %s";
    private static final String fileNotFound = "WFLYEMB0005: File on ClassPath could not be found: %s";
    private static final String skippingUnknownFileType = "WFLYEMB0006: Encountered unknown file type, skipping: %s";
    private static final String cannotMountFile = "WFLYEMB0007: Could not mount file '%s'";
    private static final String cannotReadContent = "WFLYEMB0008: Could not read contents of %s";
    private static final String exclusionValuesRequired = "WFLYEMB0009: One or more exclusion values must be specified";
    private static final String invalidJBossHome = "WFLYEMB0011: Invalid JBoss home directory: %s";
    private static final String invalidModulePath = "WFLYEMB0012: Invalid module path: %s";
    private static final String invalidModuleType = "WFLYEMB0013: %s was not of type File[], File, String[] or String, but of type %s";
    private static final String moduleLoaderError = "WFLYEMB0014: Cannot load module %s from: %s";
    private static final String systemPropertyNotFound = "WFLYEMB0016: Cannot find system property: %s";
    private static final String cannotLoadEmbeddedServerFactory = "WFLYEMB0017: Cannot load embedded server factory: %s";
    private static final String cannotGetReflectiveMethod = "WFLYEMB0018: Cannot get reflective method '%s' for: %s";
    private static final String cannotCreateStandaloneServer = "WFLYEMB0019: Cannot create standalone server using factory: %s";
    private static final String cannotSetupEmbeddedServer = "WFLYEMB0020: Cannot setup embedded process";
    private static final String cannotStartEmbeddedServer = "WFLYEMB0021: Cannot start embedded process";
    private static final String cannotInvokeStandaloneServer = "WFLYEMB0022: Cannot invoke '%s' on embedded process";
    private static final String processIsStopping = "WFLYEMB0023: The embedded server is stopping and invocations on the ModelControllerClient are not available";
    private static final String processIsReloading = "WFLYEMB0024: The embedded server is reloading and invocations on the ModelControllerClient are not yet available";
    private static final String cannotConfigureBootLogging = "WFLYEMB0025: Unable to configure embedded server logging from %s";
    private static final String cannotCreateHostController = "WFLYEMB0026: Cannot create host controller using factory: %s";

    public EmbeddedLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void cannotCloseFile(Throwable cause, VirtualFile file) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.cannotCloseFile$str(), (Object)file);
    }

    protected String cannotCloseFile$str() {
        return cannotCloseFile;
    }

    @Override
    public final void cannotLoadClassFile(Throwable cause, VirtualFile file) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.cannotLoadClassFile$str(), (Object)file);
    }

    protected String cannotLoadClassFile$str() {
        return cannotLoadClassFile;
    }

    @Override
    public final void errorClosingFile(Throwable cause, VirtualFile file) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.errorClosingFile$str(), (Object)file);
    }

    protected String errorClosingFile$str() {
        return errorClosingFile;
    }

    @Override
    public final void failedToUndeploy(Throwable cause, File file) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToUndeploy$str(), (Object)file);
    }

    protected String failedToUndeploy$str() {
        return failedToUndeploy;
    }

    @Override
    public final void fileNotFound(VirtualFile file) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.fileNotFound$str(), (Object)file);
    }

    protected String fileNotFound$str() {
        return fileNotFound;
    }

    @Override
    public final void skippingUnknownFileType(VirtualFile file) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.skippingUnknownFileType$str(), (Object)file);
    }

    protected String skippingUnknownFileType$str() {
        return skippingUnknownFileType;
    }

    protected String cannotMountFile$str() {
        return cannotMountFile;
    }

    @Override
    public final RuntimeException cannotMountFile(Throwable cause, String fileName) {
        RuntimeException result = new RuntimeException(String.format(this.cannotMountFile$str(), fileName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotReadContent$str() {
        return cannotReadContent;
    }

    @Override
    public final RuntimeException cannotReadContent(Throwable cause, VirtualFile file) {
        RuntimeException result = new RuntimeException(String.format(this.cannotReadContent$str(), file), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String exclusionValuesRequired$str() {
        return exclusionValuesRequired;
    }

    @Override
    public final IllegalArgumentException exclusionValuesRequired() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.exclusionValuesRequired$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJBossHome$str() {
        return invalidJBossHome;
    }

    @Override
    public final IllegalStateException invalidJBossHome(String jbossHome) {
        IllegalStateException result = new IllegalStateException(String.format(this.invalidJBossHome$str(), jbossHome));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidModulePath$str() {
        return invalidModulePath;
    }

    @Override
    public final IllegalArgumentException invalidModulePath(String file) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidModulePath$str(), file));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidModuleType$str() {
        return invalidModuleType;
    }

    public final RuntimeException invalidModuleType(String moduleName, Class<? extends Object> type) {
        RuntimeException result = new RuntimeException(String.format(this.invalidModuleType$str(), moduleName, type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String moduleLoaderError$str() {
        return moduleLoaderError;
    }

    @Override
    public final RuntimeException moduleLoaderError(Throwable cause, String msg, ModuleLoader moduleLoader) {
        RuntimeException result = new RuntimeException(String.format(this.moduleLoaderError$str(), msg, moduleLoader), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String systemPropertyNotFound$str() {
        return systemPropertyNotFound;
    }

    @Override
    public final IllegalStateException systemPropertyNotFound(String key) {
        IllegalStateException result = new IllegalStateException(String.format(this.systemPropertyNotFound$str(), key));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotLoadEmbeddedServerFactory$str() {
        return cannotLoadEmbeddedServerFactory;
    }

    @Override
    public final IllegalStateException cannotLoadEmbeddedServerFactory(ClassNotFoundException cause, String className) {
        IllegalStateException result = new IllegalStateException(String.format(this.cannotLoadEmbeddedServerFactory$str(), className), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotGetReflectiveMethod$str() {
        return cannotGetReflectiveMethod;
    }

    @Override
    public final IllegalStateException cannotGetReflectiveMethod(NoSuchMethodException cause, String method, String className) {
        IllegalStateException result = new IllegalStateException(String.format(this.cannotGetReflectiveMethod$str(), method, className), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateStandaloneServer$str() {
        return cannotCreateStandaloneServer;
    }

    @Override
    public final IllegalStateException cannotCreateStandaloneServer(Throwable cause, Method createMethod) {
        IllegalStateException result = new IllegalStateException(String.format(this.cannotCreateStandaloneServer$str(), createMethod), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotSetupEmbeddedServer$str() {
        return cannotSetupEmbeddedServer;
    }

    @Override
    public final IllegalStateException cannotSetupEmbeddedServer(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.cannotSetupEmbeddedServer$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotStartEmbeddedServer$str() {
        return cannotStartEmbeddedServer;
    }

    @Override
    public final EmbeddedProcessStartException cannotStartEmbeddedServer(Throwable cause) {
        EmbeddedProcessStartException result = new EmbeddedProcessStartException(String.format(this.cannotStartEmbeddedServer$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInvokeStandaloneServer$str() {
        return cannotInvokeStandaloneServer;
    }

    @Override
    public final IllegalStateException cannotInvokeStandaloneServer(Throwable cause, String methodName) {
        IllegalStateException result = new IllegalStateException(String.format(this.cannotInvokeStandaloneServer$str(), methodName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String processIsStopping$str() {
        return processIsStopping;
    }

    @Override
    public final IllegalStateException processIsStopping() {
        IllegalStateException result = new IllegalStateException(String.format(this.processIsStopping$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String processIsReloading$str() {
        return processIsReloading;
    }

    @Override
    public final IllegalStateException processIsReloading() {
        IllegalStateException result = new IllegalStateException(String.format(this.processIsReloading$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void cannotConfigureBootLogging(File loggingProperties) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotConfigureBootLogging$str(), (Object)loggingProperties);
    }

    protected String cannotConfigureBootLogging$str() {
        return cannotConfigureBootLogging;
    }

    protected String cannotCreateHostController$str() {
        return cannotCreateHostController;
    }

    @Override
    public final IllegalStateException cannotCreateHostController(Throwable cause, Method createMethod) {
        IllegalStateException result = new IllegalStateException(String.format(this.cannotCreateHostController$str(), createMethod), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

