/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import org.jboss.modules.ModuleLoader;
import org.wildfly.core.embedded.AbstractEmbeddedManagedProcess;
import org.wildfly.core.embedded.StandaloneServer;
import org.wildfly.core.embedded.logging.EmbeddedLogger;
import org.wildfly.core.embedded.spi.EmbeddedProcessBootstrap;
import org.wildfly.core.embedded.spi.EmbeddedProcessBootstrapConfiguration;

public class EmbeddedStandaloneServerFactory {
    public static final String JBOSS_EMBEDDED_ROOT = "jboss.embedded.root";
    private static final String SERVER_BASE_DIR = "jboss.server.base.dir";
    private static final String SERVER_CONFIG_DIR = "jboss.server.config.dir";
    private static final String SERVER_DATA_DIR = "jboss.server.data.dir";

    private EmbeddedStandaloneServerFactory() {
    }

    public static StandaloneServer create(File jbossHomeDir, ModuleLoader moduleLoader, Properties systemProps, Map<String, String> systemEnv, String[] cmdargs, ClassLoader embeddedModuleCL) {
        if (jbossHomeDir == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("jbossHomeDir");
        }
        if (moduleLoader == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("moduleLoader");
        }
        if (systemProps == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("systemProps");
        }
        if (systemEnv == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("systemEnv");
        }
        if (cmdargs == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("cmdargs");
        }
        if (embeddedModuleCL == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("embeddedModuleCL");
        }
        EmbeddedStandaloneServerFactory.setupCleanDirectories(jbossHomeDir.toPath(), systemProps);
        return new StandaloneServerImpl(cmdargs, systemProps, systemEnv, moduleLoader, embeddedModuleCL);
    }

    static void setupCleanDirectories(Path jbossHomeDir, Properties props) {
        Path tempRoot = EmbeddedStandaloneServerFactory.getTempRoot(props);
        if (tempRoot == null) {
            return;
        }
        File originalConfigDir = EmbeddedStandaloneServerFactory.getFileUnderAsRoot(jbossHomeDir.toFile(), props, SERVER_CONFIG_DIR, "configuration", true);
        File originalDataDir = EmbeddedStandaloneServerFactory.getFileUnderAsRoot(jbossHomeDir.toFile(), props, SERVER_DATA_DIR, "data", false);
        try {
            Path configDir = tempRoot.resolve("config");
            Files.createDirectory(configDir, new FileAttribute[0]);
            Path dataDir = tempRoot.resolve("data");
            Files.createDirectory(dataDir, new FileAttribute[0]);
            Path deploymentsDir = tempRoot.resolve("deployments");
            Files.createDirectory(deploymentsDir, new FileAttribute[0]);
            EmbeddedStandaloneServerFactory.copyDirectory(originalConfigDir, configDir.toFile());
            if (originalDataDir.exists()) {
                EmbeddedStandaloneServerFactory.copyDirectory(originalDataDir, dataDir.toFile());
            }
            props.put(SERVER_BASE_DIR, tempRoot.toAbsolutePath().toString());
            props.put(SERVER_CONFIG_DIR, configDir.toAbsolutePath().toString());
            props.put(SERVER_DATA_DIR, dataDir.toAbsolutePath().toString());
        }
        catch (IOException e) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotSetupEmbeddedServer(e);
        }
    }

    private static File getFileUnderAsRoot(File jbossHomeDir, Properties props, String propName, String relativeLocation, boolean mustExist) {
        String prop = props.getProperty(propName, null);
        if (prop == null) {
            prop = props.getProperty(SERVER_BASE_DIR, null);
            if (prop == null) {
                File dir = new File(jbossHomeDir, "standalone" + File.separator + relativeLocation);
                if (!(!mustExist || dir.exists() && dir.isDirectory())) {
                    throw EmbeddedLogger.ROOT_LOGGER.embeddedServerDirectoryNotFound("standalone" + File.separator + relativeLocation, jbossHomeDir.getAbsolutePath());
                }
                return dir;
            }
            File server = new File(prop);
            EmbeddedStandaloneServerFactory.validateDirectory(SERVER_BASE_DIR, server);
            return new File(server, relativeLocation);
        }
        File dir = new File(prop);
        EmbeddedStandaloneServerFactory.validateDirectory(SERVER_CONFIG_DIR, dir);
        return dir;
    }

    private static Path getTempRoot(Properties props) {
        String tempRoot = props.getProperty(JBOSS_EMBEDDED_ROOT, null);
        if (tempRoot == null) {
            return null;
        }
        try {
            File root = new File(tempRoot);
            if (!root.exists()) {
                Files.createDirectories(root.toPath(), new FileAttribute[0]);
            }
            EmbeddedStandaloneServerFactory.validateDirectory("jboss.test.clean.root", root);
            return Files.createTempDirectory(root.toPath(), "configs", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotSetupEmbeddedServer(e);
        }
    }

    private static void validateDirectory(String property, File file) {
        if (!file.exists()) {
            throw EmbeddedLogger.ROOT_LOGGER.propertySpecifiedFileDoesNotExist(property, file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw EmbeddedLogger.ROOT_LOGGER.propertySpecifiedFileIsNotADirectory(property, file.getAbsolutePath());
        }
    }

    private static void copyDirectory(File src, File dest) {
        if (src.list() != null) {
            for (String current : src.list()) {
                File srcFile = new File(src, current);
                File destFile = new File(dest, current);
                try {
                    Files.copy(srcFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    if (!srcFile.isDirectory()) continue;
                    EmbeddedStandaloneServerFactory.copyDirectory(srcFile, destFile);
                }
                catch (IOException e) {
                    throw EmbeddedLogger.ROOT_LOGGER.errorCopyingFile(srcFile.getAbsolutePath(), destFile.getAbsolutePath(), e);
                }
            }
        }
    }

    private static class StandaloneServerImpl
    extends AbstractEmbeddedManagedProcess
    implements StandaloneServer {
        private final Properties systemProps;
        private final Map<String, String> systemEnv;
        private final ModuleLoader moduleLoader;

        public StandaloneServerImpl(String[] cmdargs, Properties systemProps, Map<String, String> systemEnv, ModuleLoader moduleLoader, ClassLoader embeddedModuleCL) {
            super(EmbeddedProcessBootstrap.Type.STANDALONE_SERVER, cmdargs, embeddedModuleCL);
            this.systemProps = systemProps;
            this.systemEnv = systemEnv;
            this.moduleLoader = moduleLoader;
        }

        @Override
        public String getProcessState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canQueryProcessState() {
            return false;
        }

        @Override
        EmbeddedProcessBootstrapConfiguration getBootstrapConfiguration() {
            EmbeddedProcessBootstrapConfiguration configuration = super.getBootstrapConfiguration();
            configuration.setModuleLoader(this.moduleLoader);
            configuration.setSystemProperties(this.systemProps);
            configuration.setSystemEnv(this.systemEnv);
            return configuration;
        }
    }
}

