/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.logging.LogManager;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.log.JDKModuleLogger;
import org.jboss.modules.log.ModuleLogger;
import org.wildfly.core.embedded.EmbeddedHostControllerFactory;
import org.wildfly.core.embedded.EmbeddedServerReference;
import org.wildfly.core.embedded.EmbeddedStandAloneServerFactory;
import org.wildfly.core.embedded.HostController;
import org.wildfly.core.embedded.StandaloneServer;
import org.wildfly.core.embedded.logging.EmbeddedLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class EmbeddedServerFactory {
    private static final String MODULE_ID_EMBEDDED = "org.wildfly.embedded";
    private static final String MODULE_ID_LOGMANAGER = "org.jboss.logmanager";
    private static final String MODULE_ID_VFS = "org.jboss.vfs";
    private static final String SYSPROP_KEY_CLASS_PATH = "java.class.path";
    private static final String SYSPROP_KEY_MODULE_PATH = "module.path";
    private static final String SYSPROP_KEY_LOGMANAGER = "java.util.logging.manager";
    private static final String SYSPROP_KEY_JBOSS_HOME_DIR = "jboss.home.dir";
    private static final String SYSPROP_KEY_JBOSS_MODULES_DIR = "jboss.modules.dir";
    private static final String SYSPROP_VALUE_JBOSS_LOGMANAGER = "org.jboss.logmanager.LogManager";

    private EmbeddedServerFactory() {
    }

    public static StandaloneServer create(String jbossHomePath, String modulePath, String ... systemPackages) {
        return EmbeddedServerFactory.create(jbossHomePath, modulePath, systemPackages, null);
    }

    public static StandaloneServer create(String jbossHomePath, String modulePath, String[] systemPackages, String[] cmdargs) {
        if (jbossHomePath == null || jbossHomePath.isEmpty()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        File jbossHomeDir = new File(jbossHomePath);
        if (!jbossHomeDir.isDirectory()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        if (modulePath == null) {
            modulePath = jbossHomeDir.getAbsolutePath() + File.separator + "modules";
        }
        return EmbeddedServerFactory.create(EmbeddedServerFactory.setupModuleLoader(modulePath, systemPackages), jbossHomeDir, cmdargs);
    }

    public static EmbeddedServerReference createStandalone(String jbossHomePath, String modulePath, String[] systemPackages, String[] cmdargs) {
        return (EmbeddedServerReference)EmbeddedServerFactory.create(jbossHomePath, modulePath, systemPackages, cmdargs);
    }

    public static StandaloneServer create(ModuleLoader moduleLoader, File jbossHomeDir) {
        return EmbeddedServerFactory.create(moduleLoader, jbossHomeDir, new String[0]);
    }

    public static StandaloneServer create(ModuleLoader moduleLoader, File jbossHomeDir, String[] cmdargs) {
        Object standaloneServerImpl;
        Method createServerMethod;
        Class standaloneServerClass;
        Class embeddedServerFactoryClass;
        Module embeddedModule;
        EmbeddedServerFactory.setupVfsModule(moduleLoader);
        EmbeddedServerFactory.setupLoggingSystem(moduleLoader);
        WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_HOME_DIR, (String)jbossHomeDir.getAbsolutePath());
        try {
            embeddedModule = moduleLoader.loadModule(ModuleIdentifier.create((String)MODULE_ID_EMBEDDED));
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_EMBEDDED, moduleLoader);
        }
        ModuleClassLoader embeddedModuleCL = embeddedModule.getClassLoader();
        try {
            embeddedServerFactoryClass = embeddedModuleCL.loadClass(EmbeddedStandAloneServerFactory.class.getName());
            standaloneServerClass = embeddedModuleCL.loadClass(StandaloneServer.class.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotLoadEmbeddedServerFactory(cnfe, EmbeddedStandAloneServerFactory.class.getName());
        }
        try {
            createServerMethod = embeddedServerFactoryClass.getMethod("create", File.class, ModuleLoader.class, Properties.class, Map.class, String[].class);
        }
        catch (NoSuchMethodException nsme) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotGetReflectiveMethod(nsme, "create", embeddedServerFactoryClass.getName());
        }
        try {
            Properties sysprops = WildFlySecurityManager.getSystemPropertiesPrivileged();
            Map sysenv = WildFlySecurityManager.getSystemEnvironmentPrivileged();
            String[] args = cmdargs != null ? cmdargs : new String[]{};
            standaloneServerImpl = createServerMethod.invoke(null, jbossHomeDir, moduleLoader, sysprops, sysenv, args);
        }
        catch (InvocationTargetException ite) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotCreateStandaloneServer(ite.getCause(), createServerMethod);
        }
        catch (IllegalAccessException iae) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotCreateStandaloneServer(iae, createServerMethod);
        }
        EmbeddedServerReference server = new EmbeddedServerReference(standaloneServerClass, standaloneServerImpl);
        return server;
    }

    public static EmbeddedServerReference createStandalone(ModuleLoader moduleLoader, File jbossHomeDir, String[] cmdargs) {
        return (EmbeddedServerReference)EmbeddedServerFactory.create(moduleLoader, jbossHomeDir, cmdargs);
    }

    public static EmbeddedServerReference createHostController(String jbossHomePath, String modulePath, String[] systemPackages, String[] cmdargs) {
        if (jbossHomePath == null || jbossHomePath.isEmpty()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        File jbossHomeDir = new File(jbossHomePath);
        if (!jbossHomeDir.isDirectory()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        if (modulePath == null) {
            modulePath = jbossHomeDir.getAbsolutePath() + File.separator + "modules";
        }
        return EmbeddedServerFactory.createHostController(EmbeddedServerFactory.setupModuleLoader(modulePath, systemPackages), jbossHomeDir, cmdargs);
    }

    public static EmbeddedServerReference createHostController(ModuleLoader moduleLoader, File jbossHomeDir, String[] cmdargs) {
        Object hostControllerImpl;
        Method createServerMethod;
        Class hostControllerClass;
        Class embeddedHostControllerFactoryClass;
        Module embeddedModule;
        EmbeddedServerFactory.setupVfsModule(moduleLoader);
        EmbeddedServerFactory.setupLoggingSystem(moduleLoader);
        WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_HOME_DIR, (String)jbossHomeDir.getAbsolutePath());
        try {
            embeddedModule = moduleLoader.loadModule(ModuleIdentifier.create((String)MODULE_ID_EMBEDDED));
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_EMBEDDED, moduleLoader);
        }
        ModuleClassLoader embeddedModuleCL = embeddedModule.getClassLoader();
        try {
            embeddedHostControllerFactoryClass = embeddedModuleCL.loadClass(EmbeddedHostControllerFactory.class.getName());
            hostControllerClass = embeddedModuleCL.loadClass(HostController.class.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotLoadEmbeddedServerFactory(cnfe, EmbeddedHostControllerFactory.class.getName());
        }
        try {
            createServerMethod = embeddedHostControllerFactoryClass.getMethod("create", File.class, ModuleLoader.class, Properties.class, Map.class, String[].class);
        }
        catch (NoSuchMethodException nsme) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotGetReflectiveMethod(nsme, "create", embeddedHostControllerFactoryClass.getName());
        }
        try {
            Properties sysprops = WildFlySecurityManager.getSystemPropertiesPrivileged();
            Map sysenv = WildFlySecurityManager.getSystemEnvironmentPrivileged();
            String[] args = cmdargs != null ? cmdargs : new String[]{};
            hostControllerImpl = createServerMethod.invoke(null, jbossHomeDir, moduleLoader, sysprops, sysenv, args);
        }
        catch (InvocationTargetException ite) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotCreateStandaloneServer(ite.getCause(), createServerMethod);
        }
        catch (IllegalAccessException iae) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotCreateStandaloneServer(iae, createServerMethod);
        }
        return new EmbeddedServerReference(hostControllerClass, hostControllerImpl);
    }

    private static String trimPathToModulesDir(String modulePath) {
        int index = modulePath.indexOf(File.pathSeparator);
        return index == -1 ? modulePath : modulePath.substring(0, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleLoader setupModuleLoader(String modulePath, String ... systemPackages) {
        assert (modulePath != null) : "modulePath not null";
        WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_MODULES_DIR, (String)EmbeddedServerFactory.trimPathToModulesDir(modulePath));
        String classPath = WildFlySecurityManager.getPropertyPrivileged((String)SYSPROP_KEY_CLASS_PATH, null);
        try {
            WildFlySecurityManager.clearPropertyPrivileged((String)SYSPROP_KEY_CLASS_PATH);
            WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_MODULE_PATH, (String)modulePath);
            StringBuilder packages = new StringBuilder("org.jboss.modules,org.jboss.msc,org.jboss.dmr,org.jboss.threads,org.jboss.as.controller.client");
            if (systemPackages != null) {
                for (ModuleLoader packageName : systemPackages) {
                    packages.append(",");
                    packages.append((String)packageName);
                }
            }
            WildFlySecurityManager.setPropertyPrivileged((String)"jboss.modules.system.pkgs", (String)packages.toString());
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            return moduleLoader;
        }
        finally {
            WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_CLASS_PATH, (String)classPath);
        }
    }

    private static void setupVfsModule(ModuleLoader moduleLoader) {
        Module vfsModule;
        ModuleIdentifier vfsModuleID = ModuleIdentifier.create((String)MODULE_ID_VFS);
        try {
            vfsModule = moduleLoader.loadModule(vfsModuleID);
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_VFS, moduleLoader);
        }
        Module.registerURLStreamHandlerFactoryModule((Module)vfsModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupLoggingSystem(ModuleLoader moduleLoader) {
        Module logModule;
        ModuleIdentifier logModuleId = ModuleIdentifier.create((String)MODULE_ID_LOGMANAGER);
        try {
            logModule = moduleLoader.loadModule(logModuleId);
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_LOGMANAGER, moduleLoader);
        }
        ModuleClassLoader logModuleClassLoader = logModule.getClassLoader();
        ClassLoader tccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)logModuleClassLoader);
            WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_LOGMANAGER, (String)SYSPROP_VALUE_JBOSS_LOGMANAGER);
            Class<?> actualLogManagerClass = LogManager.getLogManager().getClass();
            if (actualLogManagerClass == LogManager.class) {
                System.err.println("Cannot not load JBoss LogManager. The LogManager has likely been accessed prior to this initialization.");
            } else {
                Module.setModuleLogger((ModuleLogger)new JDKModuleLogger());
            }
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)tccl);
        }
    }
}

