/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.core.embedded.HostController;
import org.wildfly.core.embedded.StandaloneServer;
import org.wildfly.core.embedded.logging.EmbeddedLogger;

public final class EmbeddedServerReference
implements StandaloneServer,
HostController {
    private final Object server;
    private final Method methodStart;
    private final Method methodStop;
    private final Method methodGetModelControllerClient;

    EmbeddedServerReference(Class<?> serverClass, Object serverImpl) {
        this.server = serverImpl;
        try {
            this.methodStart = serverClass.getMethod("start", new Class[0]);
            this.methodStop = serverClass.getMethod("stop", new Class[0]);
            this.methodGetModelControllerClient = serverClass.getMethod("getModelControllerClient", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotGetReflectiveMethod(nsme, nsme.getMessage(), serverClass.getName());
        }
    }

    @Override
    public void start() {
        this.invokeOnServer(this.methodStart, new Object[0]);
    }

    @Override
    public void stop() {
        this.invokeOnServer(this.methodStop, new Object[0]);
    }

    @Override
    public ModelControllerClient getModelControllerClient() {
        ModelControllerClient client = (ModelControllerClient)this.invokeOnServer(this.methodGetModelControllerClient, new Object[0]);
        return client;
    }

    public StandaloneServer getStandaloneServer() {
        return (StandaloneServer)this.server;
    }

    @Override
    public HostController getHostController() {
        return (HostController)this.server;
    }

    private Object invokeOnServer(Method method, Object ... args) {
        try {
            return method.invoke(this.server, args);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            Throwable cause = ex;
            if (ex instanceof InvocationTargetException) {
                cause = ((InvocationTargetException)ex).getCause();
            }
            throw EmbeddedLogger.ROOT_LOGGER.cannotInvokeStandaloneServer(cause, method.getName());
        }
    }
}

